/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.LookupValueResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class LookupJsonValueDialog
extends MirthDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ObjectMapper objectMapper = new ObjectMapper();
    private JLabel keyLabel;
    private JTextField keyField;
    private JLabel valueLabel;
    private RSyntaxTextArea rawTextArea;
    private RTextScrollPane rawScrollPane;
    private JTree treeView;
    private JScrollPane treeScrollPane;
    private JTabbedPane tabbedPane;
    private JButton saveButton;
    private JButton cancelButton;
    private Frame parent;
    private LookupValue lookupValue;
    private LookupGroup lookupGroup;
    private boolean isEdit = false;
    private boolean saved = false;

    public LookupJsonValueDialog(Frame frame, LookupValue lookupValue, LookupGroup lookupGroup, boolean bl) {
        super((Window)frame, true);
        this.parent = frame;
        this.isEdit = bl;
        this.lookupValue = lookupValue;
        this.lookupGroup = lookupGroup;
        this.initComponents();
        this.initLayout();
        this.resetComponents(lookupValue);
        this.setDefaultCloseOperation(2);
        this.setTitle(String.format("Group %s - %s", lookupGroup.getName(), bl ? "Edit Value" : "Add Value"));
        this.setPreferredSize(new Dimension(700, 500));
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.keyLabel = new JLabel("Key:");
        this.keyField = new JTextField();
        this.valueLabel = new JLabel("Value:");
        this.rawTextArea = new RSyntaxTextArea(5, 30);
        this.rawTextArea.setSyntaxEditingStyle("text/json");
        this.rawTextArea.setCodeFoldingEnabled(true);
        this.rawTextArea.setAntiAliasingEnabled(true);
        this.rawTextArea.setLineWrap(true);
        this.rawTextArea.setWrapStyleWord(true);
        this.rawScrollPane = new RTextScrollPane((Component)this.rawTextArea);
        this.rawScrollPane.setVerticalScrollBarPolicy(20);
        this.rawScrollPane.setHorizontalScrollBarPolicy(30);
        this.treeView = new JTree(new DefaultMutableTreeNode("No data"));
        this.treeScrollPane = new JScrollPane(this.treeView);
        this.installTreeContextMenu();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Raw", (Component)this.rawScrollPane);
        this.tabbedPane.addTab("Tree", this.treeScrollPane);
        this.tabbedPane.addChangeListener(changeEvent -> {
            if (this.tabbedPane.getSelectedComponent() == this.treeScrollPane) {
                this.updateTreeFromRaw();
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(actionEvent -> this.save());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align center, insets 0 0 0 0, fill", "25[right][grow,fill]", ""));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)this.keyLabel, "right");
        jPanel.add((Component)this.keyField, "wmin 200, growx");
        jPanel.add((Component)this.valueLabel, "newline, right");
        jPanel.add((Component)this.tabbedPane, "wmin 200, hmin 200, grow, push");
        this.add(jPanel, "grow, push");
        this.add(new JSeparator(), "newline, sx, growx");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel2.add(this.saveButton);
        jPanel2.add(this.cancelButton);
        this.add(jPanel2, "newline, sx, growx");
    }

    private void installTreeContextMenu() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Copy");
        JMenuItem jMenuItem2 = new JMenuItem("Copy JSONPath");
        jMenuItem.addActionListener(actionEvent -> this.copySelectedNodeValue());
        jMenuItem2.addActionListener(actionEvent -> this.copySelectedNodePath());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        this.treeView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowMenu(mouseEvent);
            }

            private void maybeShowMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = LookupJsonValueDialog.this.treeView.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    LookupJsonValueDialog.this.treeView.setSelectionPath(treePath);
                    jPopupMenu.show(LookupJsonValueDialog.this.treeView, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void resetComponents(LookupValue lookupValue) {
        this.keyField.setText(lookupValue.getKeyValue());
        String string = lookupValue.getValueData();
        if (StringUtils.isEmpty((CharSequence)string)) {
            this.rawTextArea.setText("");
        } else {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(string);
                String string2 = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
                this.rawTextArea.setText(string2);
            }
            catch (Exception exception) {
                this.rawTextArea.setText(string);
            }
        }
        this.keyField.setEnabled(!this.isEdit);
    }

    private void save() {
        String string;
        JsonNode jsonNode;
        if (!this.validateProperties()) {
            return;
        }
        this.resetInvalidComponents();
        String string2 = this.keyField.getText().trim();
        String string3 = this.rawTextArea.getText().trim();
        try {
            jsonNode = this.objectMapper.readTree(string3);
        }
        catch (Exception exception) {
            this.rawTextArea.setBackground(UIConstants.INVALID_COLOR);
            this.showError("Invalid JSON value");
            this.tabbedPane.setSelectedComponent((Component)this.rawScrollPane);
            return;
        }
        try {
            string = this.objectMapper.writeValueAsString((Object)jsonNode);
        }
        catch (Exception exception) {
            this.logger.error("Error normalizing JSON before save", (Throwable)exception);
            this.showError("Unexpected error while normalizing JSON: " + exception.getMessage());
            return;
        }
        try {
            this.lookupValue.setKeyValue(string2);
            this.lookupValue.setValueData(string);
            if (!this.isEdit) {
                int n;
                boolean bl;
                try {
                    bl = LookupServiceClient.getInstance().checkValueExists(this.lookupGroup.getId(), this.lookupValue.getKeyValue());
                }
                catch (LookupApiClientException lookupApiClientException) {
                    this.showError("Error checking for existing value: " + lookupApiClientException.getError().getMessage());
                    return;
                }
                catch (Exception exception) {
                    this.logger.error("Unexpected error while checking existing value", (Throwable)exception);
                    this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
                    return;
                }
                if (bl && (n = JOptionPane.showConfirmDialog((Component)((Object)this), "A value with the same key already exists. Do you want to overwrite it?", "Confirm Overwrite", 0, 2)) != 0) {
                    return;
                }
            }
            LookupValueResponse lookupValueResponse = LookupServiceClient.getInstance().setValue(this.lookupGroup.getId(), this.lookupValue);
            this.lookupValue.setKeyValue(lookupValueResponse.getKey());
            this.lookupValue.setValueData(lookupValueResponse.getValue());
            this.lookupValue.setCreatedDate(lookupValueResponse.getCreatedDate());
            this.lookupValue.setUpdatedDate(lookupValueResponse.getUpdatedDate());
            this.saved = true;
            this.close();
        }
        catch (LookupApiClientException lookupApiClientException) {
            this.showError(lookupApiClientException.getError().getMessage());
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while saving value", (Throwable)exception);
            this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
    }

    private void updateTreeFromRaw() {
        String string = this.rawTextArea.getText().trim();
        try {
            JsonNode jsonNode = this.objectMapper.readTree(string);
            DefaultMutableTreeNode defaultMutableTreeNode = this.buildTreeNode(jsonNode, "root", "$");
            this.treeView.setModel(new DefaultTreeModel(defaultMutableTreeNode));
            this.expandAll(this.treeView);
        }
        catch (Exception exception) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Invalid JSON (fix in Raw tab)");
            this.treeView.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        }
    }

    private DefaultMutableTreeNode buildTreeNode(JsonNode jsonNode, String string, String string2) {
        JsonTreeNodeData jsonTreeNodeData = new JsonTreeNodeData(string, string2, jsonNode);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(jsonTreeNodeData);
        if (jsonNode.isObject()) {
            jsonNode.fields().forEachRemaining(entry -> {
                String string2 = (String)entry.getKey();
                JsonNode jsonNode = (JsonNode)entry.getValue();
                String string3 = string2 + "." + string2;
                defaultMutableTreeNode.add(this.buildTreeNode(jsonNode, string2, string3));
            });
        } else if (jsonNode.isArray()) {
            int n = 0;
            for (JsonNode jsonNode2 : jsonNode) {
                String string3 = "[" + n + "]";
                String string4 = string2 + string3;
                defaultMutableTreeNode.add(this.buildTreeNode(jsonNode2, string3, string4));
                ++n;
            }
        } else {
            String string5 = jsonNode.isNull() ? "null" : jsonNode.asText();
            JsonTreeNodeData jsonTreeNodeData2 = new JsonTreeNodeData(string + ": " + string5, string2, jsonNode);
            defaultMutableTreeNode.setUserObject(jsonTreeNodeData2);
        }
        return defaultMutableTreeNode;
    }

    private void expandAll(JTree jTree) {
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    private void copySelectedNodePath() {
        Object object = this.treeView.getLastSelectedPathComponent();
        if (!(object instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof JsonTreeNodeData) {
            JsonTreeNodeData jsonTreeNodeData = (JsonTreeNodeData)object2;
            String string = jsonTreeNodeData.jsonPath;
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                this.copyToClipboard(string);
                this.showInformation("Copied JSONPath: " + string);
            }
        }
    }

    private void copySelectedNodeValue() {
        Object object = this.treeView.getLastSelectedPathComponent();
        if (!(object instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof JsonTreeNodeData) {
            JsonTreeNodeData jsonTreeNodeData = (JsonTreeNodeData)object2;
            JsonNode jsonNode = jsonTreeNodeData.node;
            try {
                String string = jsonNode.isObject() || jsonNode.isArray() ? this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode) : this.objectMapper.writeValueAsString((Object)jsonNode);
                this.copyToClipboard(string);
                this.showInformation("Copied value to clipboard.");
            }
            catch (Exception exception) {
                this.logger.error("Error copying JSON value", (Throwable)exception);
                this.showError("Error copying value: " + exception.getMessage());
            }
        }
    }

    private void copyToClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private void close() {
        this.dispose();
    }

    public boolean isSaved() {
        return this.saved;
    }

    private boolean validateProperties() {
        String string;
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        this.resetInvalidComponents();
        String string2 = this.keyField.getText().trim();
        if (StringUtils.isEmpty((CharSequence)string2)) {
            bl = false;
            this.keyField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a key.").append(System.lineSeparator());
        }
        if (StringUtils.isEmpty((CharSequence)(string = this.rawTextArea.getText().trim()))) {
            bl = false;
            this.rawTextArea.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a JSON value.").append(System.lineSeparator());
        }
        if (!bl) {
            this.showError(stringBuilder.toString());
        }
        return bl;
    }

    public void resetInvalidComponents() {
        this.keyField.setBackground(null);
        this.rawTextArea.setBackground(null);
    }

    protected void showInformation(String string) {
        PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)this), string);
    }

    protected void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }

    private static class JsonTreeNodeData {
        final String label;
        final String jsonPath;
        final JsonNode node;

        JsonTreeNodeData(String string, String string2, JsonNode jsonNode) {
            this.label = string;
            this.jsonPath = string2;
            this.node = jsonNode;
        }

        public String toString() {
            return this.label;
        }
    }
}

