/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.panel;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.dynamiclookup.client.panel.NoGroupSelectedPanel;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.CacheStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.GroupStatisticsResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class CacheStatusPanel
extends JPanel {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
    private final Frame parent = PlatformUI.MIRTH_FRAME;
    private JPanel noGroupSelectedPanel;
    private JPanel contentPanel;
    private LookupGroup selectedGroup;

    public CacheStatusPanel() {
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.noGroupSelectedPanel = new NoGroupSelectedPanel();
    }

    private void initLayout() {
        this.setLayout(new CardLayout());
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("insets 8, wrap 1, fill", "[grow]", "[]"));
        this.contentPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.add((Component)this.contentPanel, "content");
        this.add((Component)this.noGroupSelectedPanel, "noGroup");
    }

    public void updateCaches(LookupGroup lookupGroup) {
        boolean bl = lookupGroup != null;
        this.contentPanel.setVisible(bl);
        this.noGroupSelectedPanel.setVisible(!bl);
        this.selectedGroup = lookupGroup;
        if (bl) {
            this.refreshUI();
        }
    }

    private void refreshUI() {
        Object object;
        boolean bl;
        this.contentPanel.removeAll();
        GroupStatisticsResponse groupStatisticsResponse = this.fetchGroupStatistics(this.selectedGroup);
        if (groupStatisticsResponse == null || groupStatisticsResponse.getCacheStatistics() == null) {
            this.showError("Failed to fetch cache statistics.");
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
            return;
        }
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fill, gapx 5", "[220!][grow, fill]", "[]"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel jPanel2 = this.createTextInfoPanel(groupStatisticsResponse);
        jPanel.add((Component)jPanel2, "growy");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("insets 0, wrap 1", "[grow, fill]", "[]10[]10[]"));
        jPanel3.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Statistics Visualizations"));
        long l = groupStatisticsResponse.getTotalLookups();
        long l2 = groupStatisticsResponse.getCacheHits();
        long l3 = l - l2;
        ChartPanel chartPanel = this.createGroupLookupsBreakdownChartPanel(l2, l3);
        jPanel3.add((Component)chartPanel, "growx, wrap");
        CacheStatistics cacheStatistics = groupStatisticsResponse.getCacheStatistics();
        boolean bl2 = bl = cacheStatistics.getConfiguredMaxEntries() > 0;
        if (bl) {
            object = new DefaultCategoryDataset();
            object.addValue((double)cacheStatistics.getCurrentEntryCount(), (Comparable)((Object)"Cache"), (Comparable)((Object)"Current Entries"));
            object.addValue((double)cacheStatistics.getConfiguredMaxEntries(), (Comparable)((Object)"Cache"), (Comparable)((Object)"Configured Max"));
            JFreeChart jFreeChart = ChartFactory.createBarChart((String)"Cache Entry Count", (String)"Category", (String)"Entries", (CategoryDataset)object, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            ChartPanel chartPanel2 = new ChartPanel(jFreeChart);
            chartPanel2.setPreferredSize(new Dimension(300, 200));
            jPanel3.add((Component)chartPanel2, "growx, wrap");
            if (!cacheStatistics.isStatsSupported()) {
                JPanel jPanel4 = new JPanel();
                jPanel4.setBackground(UIConstants.BACKGROUND_COLOR);
                jPanel4.add(new JLabel("<html><span style='font-size:14pt;'><b>Hit/Miss distribution is not available for this eviction policy.</b></span></html>"));
                jPanel3.add(jPanel4);
            } else if (cacheStatistics.getHitCount() > 0L || cacheStatistics.getMissCount() > 0L) {
                DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
                defaultPieDataset.setValue((Comparable)((Object)"Hits"), (double)cacheStatistics.getHitCount());
                defaultPieDataset.setValue((Comparable)((Object)"Misses"), (double)cacheStatistics.getMissCount());
                JFreeChart jFreeChart2 = ChartFactory.createPieChart((String)"Hit vs Miss Distribution", (PieDataset)defaultPieDataset, (boolean)true, (boolean)true, (boolean)false);
                ChartPanel chartPanel3 = new ChartPanel(jFreeChart2);
                chartPanel3.setPreferredSize(new Dimension(300, 200));
                jPanel3.add((Component)chartPanel3, "growx, wrap");
            } else {
                JPanel jPanel5 = new JPanel();
                jPanel5.setBackground(UIConstants.BACKGROUND_COLOR);
                jPanel5.add(new JLabel("<html><span style='font-size:14pt;'><b>Hit/Miss distribution will appear after lookups occur.</b></span></html>"));
                jPanel3.add(jPanel5);
            }
        }
        object = new JScrollPane(jPanel3);
        ((JComponent)object).setBorder(null);
        ((JComponent)object).setPreferredSize(new Dimension(400, 600));
        jPanel.add((Component)object, "grow, wrap");
        this.contentPanel.add((Component)jPanel, "span, grow, push");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private GroupStatisticsResponse fetchGroupStatistics(LookupGroup lookupGroup) {
        try {
            return LookupServiceClient.getInstance().getGroupStatistics(lookupGroup.getId());
        }
        catch (ClientException clientException) {
            this.logger.error("Failed to fetch group statistics for group ID {}", (Object)lookupGroup.getId(), (Object)clientException);
            this.showError("Unable to fetch group statistics for the selected group:\n" + clientException.getMessage());
            return null;
        }
    }

    private void resetGroupStatistics(LookupGroup lookupGroup) {
        try {
            LookupServiceClient.getInstance().resetGroupStatistics(lookupGroup.getId());
        }
        catch (ClientException clientException) {
            this.logger.error("Failed to reset group statistics for group ID {}", (Object)lookupGroup.getId(), (Object)clientException);
            this.showError("Unable to reset group statistics for the selected group:\n" + clientException.getMessage());
        }
    }

    private void clearGroupCache(LookupGroup lookupGroup) {
        try {
            LookupServiceClient.getInstance().clearGroupCache(lookupGroup.getId());
        }
        catch (ClientException clientException) {
            this.logger.error("Failed to clear group cache for group ID {}", (Object)lookupGroup.getId(), (Object)clientException);
            this.showError("Unable to clear group cache for the selected group:\n" + clientException.getMessage());
        }
    }

    private JPanel createTextInfoPanel(GroupStatisticsResponse groupStatisticsResponse) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.00%");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("insets 8, wrap 1, fillx", "[left]", "[]5"));
        jPanel2.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Lookup Group Statistics"));
        jPanel2.setToolTipText("These statistics are retrieved from the database (persistent values).");
        jPanel2.add(new JLabel("Group ID: " + groupStatisticsResponse.getGroupId()));
        jPanel2.add(new JLabel("Total Lookups: " + decimalFormat.format(groupStatisticsResponse.getTotalLookups())));
        jPanel2.add(new JLabel("Cache Hits: " + decimalFormat.format(groupStatisticsResponse.getCacheHits())));
        jPanel2.add(new JLabel("Hit Rate (Group Level): " + decimalFormat2.format(groupStatisticsResponse.getHitRate())));
        jPanel2.add(new JLabel("Last Accessed: " + this.formatDisplayDate(groupStatisticsResponse.getLastAccessed())));
        jPanel2.add(new JLabel("Reset Date: " + this.formatDisplayDate(groupStatisticsResponse.getResetDate())));
        CacheStatistics cacheStatistics = groupStatisticsResponse.getCacheStatistics();
        boolean bl = cacheStatistics.getConfiguredMaxEntries() > 0;
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("insets 8, wrap 1, fillx", "[left]", "[]5"));
        jPanel3.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Cache Performance"));
        jPanel3.setToolTipText("These statistics come from in-memory cache metrics (real-time values).");
        if (bl) {
            jPanel3.add(new JLabel("Eviction Policy: " + cacheStatistics.getEvictionPolicy()));
            jPanel3.add(new JLabel("Current Entry Count: " + cacheStatistics.getCurrentEntryCount()));
            jPanel3.add(new JLabel("Configured Max Entries: " + cacheStatistics.getConfiguredMaxEntries()));
            if (cacheStatistics.isStatsSupported()) {
                jPanel3.add(new JLabel("Hit Count: " + decimalFormat.format(cacheStatistics.getHitCount())));
                jPanel3.add(new JLabel("Miss Count: " + decimalFormat.format(cacheStatistics.getMissCount())));
                jPanel3.add(new JLabel("Eviction Count: " + decimalFormat.format(cacheStatistics.getEvictionCount())));
                jPanel3.add(new JLabel("Hit Ratio (Cache Level): " + decimalFormat2.format(cacheStatistics.getHitRatio())));
                jPanel3.add(new JLabel("Miss Ratio (Cache Level): " + decimalFormat2.format(cacheStatistics.getMissRatio())));
                jPanel3.add(new JLabel("Total Load Time: " + cacheStatistics.getTotalLoadTimeFormatted()));
            } else {
                jPanel3.add(new JLabel("<html><div style='font-size:12pt; font-weight:bold;'>Cache statistics are not<br>supported for this eviction policy.</div></html>"));
            }
        } else {
            jPanel3.add(new JLabel("<html><div style='font-size:12pt; font-weight:bold;'>Cache statistics is disabled.</div></html>"));
            jPanel3.setEnabled(false);
        }
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(this.buildActionButtonsPanel(bl));
        return jPanel;
    }

    private JPanel buildActionButtonsPanel(boolean bl) {
        JButton jButton = new JButton("Reset Group Statistics");
        jButton.setToolTipText("Clears database-stored lookup counters for this group.");
        jButton.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset group statistics?", "Confirm Reset", 0);
            if (n == 0) {
                this.resetGroupStatistics(this.selectedGroup);
                this.refreshUI();
            }
        });
        JButton jButton2 = new JButton("Clear Cache");
        jButton2.setToolTipText("Clears all entries and in-memory cache metrics for this group.");
        jButton2.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to clear the in-memory cache?", "Confirm Clear", 0);
            if (n == 0) {
                this.clearGroupCache(this.selectedGroup);
                this.refreshUI();
            }
        });
        jButton2.setEnabled(bl);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private ChartPanel createGroupLookupsBreakdownChartPanel(long l, long l2) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)"Lookups"), (Comparable)((Object)"Cache Hits"));
        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)"Lookups"), (Comparable)((Object)"Misses"));
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)"Group Lookups Breakdown", (String)"Result Type", (String)"Count", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        DrawingSupplier drawingSupplier = categoryPlot.getDrawingSupplier();
        final Paint paint = drawingSupplier.getNextPaint();
        final Paint paint2 = drawingSupplier.getNextPaint();
        BarRenderer barRenderer = new BarRenderer(){

            public Paint getItemPaint(int n, int n2) {
                return n2 == 0 ? paint : paint2;
            }
        };
        barRenderer.setBarPainter((BarPainter)new StandardBarPainter());
        barRenderer.setShadowVisible(false);
        barRenderer.setDrawBarOutline(false);
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(300, 200));
        return chartPanel;
    }

    private String formatDisplayDate(Date date) {
        if (date == null) {
            return "-";
        }
        return this.formatter.format(date);
    }

    private void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)this.parent, string);
    }
}

