/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v3;

import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.datatypes.hl7v3.HL7V3SerializationProperties;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class HL7V3Serializer
implements IMessageSerializer {
    private HL7V3SerializationProperties serializationProperties;

    public HL7V3Serializer(SerializerProperties properties) {
        this.serializationProperties = (HL7V3SerializationProperties)properties.getSerializationProperties();
    }

    public boolean isSerializationRequired(boolean toXml) {
        boolean serializationRequired = false;
        return serializationRequired;
    }

    public String transformWithoutSerializing(String message, MessageSerializer outboundSerializer) throws MessageSerializerException {
        try {
            if (this.serializationProperties.isStripNamespaces()) {
                return StringUtil.stripNamespaces((String)message);
            }
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error transforming HL7 v3.x", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error transforming HL7 v3.x", (Throwable)e));
        }
        return null;
    }

    public String toXML(String source) throws MessageSerializerException {
        try {
            if (this.serializationProperties.isStripNamespaces()) {
                source = StringUtil.stripNamespaces((String)source);
            }
            source = source.trim();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error transforming HL7 v3.x", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error transforming HL7 v3.x", (Throwable)e));
        }
        return source;
    }

    public String fromXML(String source) throws MessageSerializerException {
        return source;
    }

    public Map<String, Object> getMetaDataFromMessage(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mirth_version", "3.0");
        StringBuilder builder = new StringBuilder();
        boolean found = false;
        for (int index = 0; index < message.length() - 1; ++index) {
            char c = message.charAt(index);
            char next = message.charAt(index + 1);
            if (!found && c == '<' && (next >= 'A' && next <= 'Z' || next >= 'a' && next <= 'z' || next == '_')) {
                found = true;
                continue;
            }
            if (!found) continue;
            if (c <= ' ' || c == '/' || c == '>') break;
            builder.append(c);
        }
        if (builder.length() > 0) {
            map.put("message_type", builder.toString());
        }
        return map;
    }

    public void populateMetaData(String message, Map<String, Object> map) {
    }

    public String toJSON(String message) throws MessageSerializerException {
        return null;
    }

    public String fromJSON(String message) throws MessageSerializerException {
        return null;
    }
}

