/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.connectors.jms.JmsConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.Map;

public class JmsReceiverProperties
extends JmsConnectorProperties
implements SourceConnectorPropertiesInterface {
    private SourceConnectorProperties sourceConnectorProperties = new SourceConnectorProperties();
    private String selector = "";
    private String reconnectIntervalMillis = "10000";
    private boolean durableTopic = false;

    public SourceConnectorProperties getSourceConnectorProperties() {
        return this.sourceConnectorProperties;
    }

    @Override
    public String getName() {
        return "JMS Listener";
    }

    @Override
    public String toFormattedString() {
        String newLine = "\n";
        StringBuilder builder = new StringBuilder(super.toFormattedString());
        if (!this.selector.isEmpty()) {
            builder.append("SELECTOR: " + this.selector + newLine);
        }
        if (!this.isUseJndi()) {
            builder.append("DURABLE TOPIC: " + (this.durableTopic ? "yes" : "no") + newLine);
        }
        return builder.toString();
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getReconnectIntervalMillis() {
        return this.reconnectIntervalMillis;
    }

    public void setReconnectIntervalMillis(String reconnectIntervalMillis) {
        this.reconnectIntervalMillis = reconnectIntervalMillis;
    }

    public boolean isDurableTopic() {
        return this.durableTopic;
    }

    public void setDurableTopic(boolean durableTopic) {
        this.durableTopic = durableTopic;
    }

    public boolean canBatch() {
        return true;
    }

    @Override
    public Map<String, Object> getPurgedProperties() {
        Map<String, Object> purgedProperties = super.getPurgedProperties();
        purgedProperties.put("sourceConnectorProperties", this.sourceConnectorProperties.getPurgedProperties());
        purgedProperties.put("reconnectIntervalMillis", PurgeUtil.getNumericValue((String)this.reconnectIntervalMillis));
        purgedProperties.put("durableTopic", this.durableTopic);
        return purgedProperties;
    }
}

