/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.textviewer;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.plugins.AttachmentViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class TextViewer
extends AttachmentViewer {
    public TextViewer(String name) {
        super(name);
    }

    public boolean handleMultiple() {
        return false;
    }

    public void viewAttachments(String channelId, Long messageId, String attachmentId) {
        Frame frame = new Frame("Text Viewer");
        frame.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        frame.setBackground(UIConstants.BACKGROUND_COLOR);
        try {
            final Attachment attachment = this.parent.mirthClient.getAttachment(channelId, messageId, attachmentId);
            boolean isRTF = attachment.getType().toLowerCase().contains("rtf");
            boolean isBase64Encoded = Base64.isBase64((byte[])attachment.getContent());
            byte[] attachmentContent = isBase64Encoded ? Base64.decodeBase64((byte[])attachment.getContent()) : attachment.getContent();
            final JEditorPane jEditorPane = new JEditorPane(isRTF ? "text/rtf" : "text/plain", StringUtils.newStringUtf8((byte[])attachmentContent));
            jEditorPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(jEditorPane);
            final JCheckBox base64CheckBox = new JCheckBox("Decode Base64 Data");
            base64CheckBox.setBackground(frame.getBackground());
            base64CheckBox.setToolTipText("Check this option if the attachment data is Base64 encoded.");
            base64CheckBox.setSelected(isBase64Encoded);
            base64CheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        jEditorPane.setText(StringUtils.newStringUtf8((byte[])(base64CheckBox.isSelected() ? Base64.decodeBase64((byte[])attachment.getContent()) : attachment.getContent())));
                        jEditorPane.setCaretPosition(0);
                    }
                    catch (Exception e) {
                        base64CheckBox.setSelected(!base64CheckBox.isSelected());
                        TextViewer.this.parent.alertThrowable((Component)TextViewer.this.parent, (Throwable)e);
                    }
                }
            });
            if (!isBase64Encoded) {
                base64CheckBox.setVisible(false);
            }
            frame.add((Component)base64CheckBox, "gapleft 6, gaptop 6");
            frame.add((Component)scrollPane, "newline, grow, push");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    e.getWindow().dispose();
                }
            });
            frame.setSize(600, 800);
            Dimension dlgSize = frame.getSize();
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocation();
            if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
                frame.setLocationRelativeTo(null);
            } else {
                frame.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            }
            frame.setVisible(true);
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)this.parent, (Throwable)e);
        }
    }

    public boolean isContentTypeViewable(String contentType) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)"rtf") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)"text");
    }

    public void start() {
    }

    public void stop() {
    }

    public void reset() {
    }

    public String getPluginPointName() {
        return "Text Viewer";
    }
}

