/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.dimse;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DICOMDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private DestinationConnectorProperties destinationConnectorProperties;
    private String host;
    private String port;
    private String applicationEntity;
    private String localHost;
    private String localPort;
    private String localApplicationEntity;
    private String template;
    private String acceptTo;
    private String async;
    private String bufSize;
    private String connectTo;
    private String priority;
    private String passcode;
    private boolean pdv1;
    private String rcvpdulen;
    private String reaper;
    private String releaseTo;
    private String rspTo;
    private String shutdownDelay;
    private String sndpdulen;
    private String soCloseDelay;
    private String sorcvbuf;
    private String sosndbuf;
    private boolean stgcmt;
    private boolean tcpDelay;
    private boolean ts1;
    private boolean uidnegrsp;
    private String username;
    private String keyPW;
    private String keyStore;
    private String keyStorePW;
    private boolean noClientAuth;
    private boolean nossl2;
    private String tls;
    private String trustStore;
    private String trustStorePW;

    public DICOMDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties();
        this.host = "127.0.0.1";
        this.port = "104";
        this.template = "${DICOMMESSAGE}";
        this.acceptTo = "5000";
        this.async = "0";
        this.bufSize = "1";
        this.connectTo = "0";
        this.priority = "med";
        this.passcode = "";
        this.pdv1 = false;
        this.rcvpdulen = "16";
        this.reaper = "10";
        this.releaseTo = "5";
        this.rspTo = "60";
        this.shutdownDelay = "1000";
        this.sndpdulen = "16";
        this.soCloseDelay = "50";
        this.sorcvbuf = "0";
        this.sosndbuf = "0";
        this.stgcmt = false;
        this.tcpDelay = true;
        this.ts1 = false;
        this.uidnegrsp = false;
        this.username = "";
        this.applicationEntity = "";
        this.keyPW = "";
        this.keyStore = "";
        this.keyStorePW = "";
        this.noClientAuth = true;
        this.nossl2 = true;
        this.tls = "notls";
        this.trustStore = "";
        this.trustStorePW = "";
        this.localHost = "";
        this.localPort = "";
        this.localApplicationEntity = "";
    }

    public DICOMDispatcherProperties(DICOMDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.host = props.getHost();
        this.port = props.getPort();
        this.template = props.getTemplate();
        this.acceptTo = props.getAcceptTo();
        this.async = props.getAsync();
        this.bufSize = props.getBufSize();
        this.connectTo = props.getConnectTo();
        this.priority = props.getPriority();
        this.passcode = props.getPasscode();
        this.pdv1 = props.isPdv1();
        this.rcvpdulen = props.getRcvpdulen();
        this.reaper = props.getReaper();
        this.releaseTo = props.getReleaseTo();
        this.rspTo = props.getRspTo();
        this.shutdownDelay = props.getShutdownDelay();
        this.sndpdulen = props.getSndpdulen();
        this.soCloseDelay = props.getSoCloseDelay();
        this.sorcvbuf = props.getSorcvbuf();
        this.sosndbuf = props.getSosndbuf();
        this.stgcmt = props.isStgcmt();
        this.tcpDelay = props.isTcpDelay();
        this.ts1 = props.isTs1();
        this.uidnegrsp = props.isUidnegrsp();
        this.username = props.getUsername();
        this.applicationEntity = props.getApplicationEntity();
        this.keyPW = props.getKeyPW();
        this.keyStore = props.getKeyStore();
        this.keyStorePW = props.getKeyStorePW();
        this.noClientAuth = props.isNoClientAuth();
        this.nossl2 = props.isNossl2();
        this.tls = props.getTls();
        this.trustStore = props.getTrustStore();
        this.trustStorePW = props.getTrustStorePW();
        this.localHost = props.getLocalHost();
        this.localPort = props.getLocalPort();
        this.localApplicationEntity = props.getLocalApplicationEntity();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getApplicationEntity() {
        return this.applicationEntity;
    }

    public void setApplicationEntity(String applicationEntity) {
        this.applicationEntity = applicationEntity;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(String localPort) {
        this.localPort = localPort;
    }

    public String getLocalApplicationEntity() {
        return this.localApplicationEntity;
    }

    public void setLocalApplicationEntity(String localApplicationEntity) {
        this.localApplicationEntity = localApplicationEntity;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getAcceptTo() {
        return this.acceptTo;
    }

    public void setAcceptTo(String acceptTo) {
        this.acceptTo = acceptTo;
    }

    public String getAsync() {
        return this.async;
    }

    public void setAsync(String async) {
        this.async = async;
    }

    public String getBufSize() {
        return this.bufSize;
    }

    public void setBufSize(String bufSize) {
        this.bufSize = bufSize;
    }

    public String getConnectTo() {
        return this.connectTo;
    }

    public void setConnectTo(String connectTo) {
        this.connectTo = connectTo;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public boolean isPdv1() {
        return this.pdv1;
    }

    public void setPdv1(boolean pdv1) {
        this.pdv1 = pdv1;
    }

    public String getRcvpdulen() {
        return this.rcvpdulen;
    }

    public void setRcvpdulen(String rcvpdulen) {
        this.rcvpdulen = rcvpdulen;
    }

    public String getReaper() {
        return this.reaper;
    }

    public void setReaper(String reaper) {
        this.reaper = reaper;
    }

    public String getReleaseTo() {
        return this.releaseTo;
    }

    public void setReleaseTo(String releaseTo) {
        this.releaseTo = releaseTo;
    }

    public String getRspTo() {
        return this.rspTo;
    }

    public void setRspTo(String rspTo) {
        this.rspTo = rspTo;
    }

    public String getShutdownDelay() {
        return this.shutdownDelay;
    }

    public void setShutdownDelay(String shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
    }

    public String getSndpdulen() {
        return this.sndpdulen;
    }

    public void setSndpdulen(String sndpdulen) {
        this.sndpdulen = sndpdulen;
    }

    public String getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public void setSoCloseDelay(String soCloseDelay) {
        this.soCloseDelay = soCloseDelay;
    }

    public String getSorcvbuf() {
        return this.sorcvbuf;
    }

    public void setSorcvbuf(String sorcvbuf) {
        this.sorcvbuf = sorcvbuf;
    }

    public String getSosndbuf() {
        return this.sosndbuf;
    }

    public void setSosndbuf(String sosndbuf) {
        this.sosndbuf = sosndbuf;
    }

    public boolean isStgcmt() {
        return this.stgcmt;
    }

    public void setStgcmt(boolean stgcmt) {
        this.stgcmt = stgcmt;
    }

    public boolean isTcpDelay() {
        return this.tcpDelay;
    }

    public void setTcpDelay(boolean tcpDelay) {
        this.tcpDelay = tcpDelay;
    }

    public boolean isTs1() {
        return this.ts1;
    }

    public void setTs1(boolean ts1) {
        this.ts1 = ts1;
    }

    public boolean isUidnegrsp() {
        return this.uidnegrsp;
    }

    public void setUidnegrsp(boolean uidnegrsp) {
        this.uidnegrsp = uidnegrsp;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getKeyPW() {
        return this.keyPW;
    }

    public void setKeyPW(String keyPW) {
        this.keyPW = keyPW;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePW() {
        return this.keyStorePW;
    }

    public void setKeyStorePW(String keyStorePW) {
        this.keyStorePW = keyStorePW;
    }

    public boolean isNoClientAuth() {
        return this.noClientAuth;
    }

    public void setNoClientAuth(boolean noClientAuth) {
        this.noClientAuth = noClientAuth;
    }

    public boolean isNossl2() {
        return this.nossl2;
    }

    public void setNossl2(boolean nossl2) {
        this.nossl2 = nossl2;
    }

    public String getTls() {
        return this.tls;
    }

    public void setTls(String tls) {
        this.tls = tls;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePW() {
        return this.trustStorePW;
    }

    public void setTrustStorePW(String trustStorePW) {
        this.trustStorePW = trustStorePW;
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public String getProtocol() {
        return "DICOM";
    }

    public String getName() {
        return "DICOM Sender";
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("REMOTE ADDRESS: ");
        builder.append(this.host + ":" + this.port);
        builder.append(newLine);
        if (StringUtils.isNotBlank((CharSequence)this.localHost)) {
            builder.append("LOCAL ADDRESS: ");
            builder.append(this.localHost + ":" + this.localPort);
            builder.append(newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)this.applicationEntity)) {
            builder.append("REMOTE APPLICATION ENTITY: ");
            builder.append(this.applicationEntity);
            builder.append(newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)this.localApplicationEntity)) {
            builder.append("LOCAL APPLICATION ENTITY: ");
            builder.append(this.localApplicationEntity);
            builder.append(newLine);
        }
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            builder.append("USERNAME: ");
            builder.append(this.username);
            builder.append(newLine);
        }
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.template);
        return builder.toString();
    }

    public ConnectorProperties clone() {
        return new DICOMDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return false;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("templateLines", PurgeUtil.countLines((String)this.template));
        purgedProperties.put("acceptTo", PurgeUtil.getNumericValue((String)this.acceptTo));
        purgedProperties.put("async", PurgeUtil.getNumericValue((String)this.async));
        purgedProperties.put("bufSize", PurgeUtil.getNumericValue((String)this.bufSize));
        purgedProperties.put("connectTo", PurgeUtil.getNumericValue((String)this.connectTo));
        purgedProperties.put("priority", this.priority);
        purgedProperties.put("pdv1", this.pdv1);
        purgedProperties.put("rcvpdulen", PurgeUtil.getNumericValue((String)this.rcvpdulen));
        purgedProperties.put("reaper", PurgeUtil.getNumericValue((String)this.reaper));
        purgedProperties.put("releaseTo", PurgeUtil.getNumericValue((String)this.releaseTo));
        purgedProperties.put("rspTo", PurgeUtil.getNumericValue((String)this.rspTo));
        purgedProperties.put("shutdownDelay", PurgeUtil.getNumericValue((String)this.shutdownDelay));
        purgedProperties.put("sndpdulen", PurgeUtil.getNumericValue((String)this.sndpdulen));
        purgedProperties.put("soCloseDelay", PurgeUtil.getNumericValue((String)this.soCloseDelay));
        purgedProperties.put("sorcvbuf", PurgeUtil.getNumericValue((String)this.sorcvbuf));
        purgedProperties.put("sosndbuf", PurgeUtil.getNumericValue((String)this.sosndbuf));
        purgedProperties.put("stgcmt", this.stgcmt);
        purgedProperties.put("tcpDelay", this.tcpDelay);
        purgedProperties.put("ts1", this.ts1);
        purgedProperties.put("uidnegrsp", this.uidnegrsp);
        purgedProperties.put("noClientAuth", this.noClientAuth);
        purgedProperties.put("nossl2", this.nossl2);
        purgedProperties.put("tls", this.tls);
        return purgedProperties;
    }
}

