/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.plugins.dynamiclookup.shared.model.AdvancedJsonFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonCondition;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonOperator;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonValueType;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import java.util.ArrayList;

public final class AdvancedJsonFilterBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private AdvancedJsonFilterBuilder() {
    }

    public static String toJson(AdvancedJsonFilterState advancedJsonFilterState) throws Exception {
        return JsonUtils.toJson(advancedJsonFilterState);
    }

    public static AdvancedJsonFilterState fromJson(String string) throws Exception {
        return JsonUtils.fromJson(string, AdvancedJsonFilterState.class);
    }

    public static String toConditionsJsonArray(AdvancedJsonFilterState advancedJsonFilterState) {
        if (advancedJsonFilterState == null || advancedJsonFilterState.getConditions() == null || advancedJsonFilterState.getConditions().isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        boolean bl = true;
        for (JsonCondition jsonCondition : advancedJsonFilterState.getConditions()) {
            String string;
            if (jsonCondition == null) continue;
            String string2 = AdvancedJsonFilterBuilder.trim(jsonCondition.getField());
            String string3 = string = jsonCondition.getValue() != null ? jsonCondition.getValue().toString().trim() : "";
            if (string2.isEmpty() || string.isEmpty()) continue;
            if (!bl) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append("  {\n");
            stringBuilder.append("    \"field\": \"").append(AdvancedJsonFilterBuilder.escapeJson(string2)).append("\",\n");
            stringBuilder.append("    \"op\": \"").append(AdvancedJsonFilterBuilder.mapOperatorToSymbol(jsonCondition.getOp())).append("\",\n");
            stringBuilder.append("    \"valueType\": \"").append(jsonCondition.getValueType() != null ? jsonCondition.getValueType().name() : JsonValueType.STRING.name()).append("\",\n");
            stringBuilder.append("    \"value\": \"").append(AdvancedJsonFilterBuilder.escapeJson(string)).append("\"\n");
            stringBuilder.append("  }");
            bl = false;
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    public static AdvancedJsonFilterState fromLookupHelperInputs(String string, String string2) {
        AdvancedJsonFilterState advancedJsonFilterState = new AdvancedJsonFilterState();
        if (string != null && !string.trim().isEmpty()) {
            advancedJsonFilterState.setKeyPattern(string.trim());
        }
        if (string2 == null) {
            return advancedJsonFilterState;
        }
        String string3 = string2.trim();
        if (string3.isEmpty() || "[]".equals(string3)) {
            return advancedJsonFilterState;
        }
        try {
            JsonNode jsonNode = MAPPER.readTree(string3);
            if (jsonNode == null || !jsonNode.isArray()) {
                throw new IllegalArgumentException("Invalid filter JSON (expected array): " + string2);
            }
            ArrayList<JsonCondition> arrayList = new ArrayList<JsonCondition>();
            for (JsonNode jsonNode2 : jsonNode) {
                String string4;
                if (jsonNode2 == null || !jsonNode2.isObject()) continue;
                String string5 = AdvancedJsonFilterBuilder.trim(AdvancedJsonFilterBuilder.text(jsonNode2, "field"));
                String string6 = AdvancedJsonFilterBuilder.trim(AdvancedJsonFilterBuilder.text(jsonNode2, "op"));
                String string7 = AdvancedJsonFilterBuilder.trim(AdvancedJsonFilterBuilder.text(jsonNode2, "valueType"));
                JsonNode jsonNode3 = jsonNode2.get("value");
                String string8 = string4 = jsonNode3 == null || jsonNode3.isNull() ? "" : jsonNode3.asText("").trim();
                if (string5.isEmpty() || string4.isEmpty()) continue;
                JsonCondition jsonCondition = new JsonCondition();
                jsonCondition.setField(string5);
                jsonCondition.setOp(AdvancedJsonFilterBuilder.mapSymbolToOperator(string6));
                jsonCondition.setValueType(string7.isEmpty() ? JsonValueType.STRING : JsonValueType.valueOf(string7));
                jsonCondition.setValue(string4);
                arrayList.add(jsonCondition);
            }
            advancedJsonFilterState.setConditions(arrayList);
            return advancedJsonFilterState;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid filter JSON: " + string2, exception);
        }
    }

    private static String text(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        return jsonNode2 == null || jsonNode2.isNull() ? null : jsonNode2.asText();
    }

    private static String trim(String string) {
        return string != null ? string.trim() : "";
    }

    private static String escapeJson(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String mapOperatorToSymbol(JsonOperator jsonOperator) {
        if (jsonOperator == null) {
            throw new IllegalArgumentException("Operator cannot be null");
        }
        switch (jsonOperator) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case LESS_THAN: {
                return "<";
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + String.valueOf((Object)jsonOperator));
    }

    private static JsonOperator mapSymbolToOperator(String string) {
        String string2 = AdvancedJsonFilterBuilder.trim(string);
        if ("=".equals(string2)) {
            return JsonOperator.EQUAL;
        }
        if ("!=".equals(string2)) {
            return JsonOperator.NOT_EQUAL;
        }
        if (">=".equals(string2)) {
            return JsonOperator.GREATER_OR_EQUAL;
        }
        if ("<=".equals(string2)) {
            return JsonOperator.LESS_OR_EQUAL;
        }
        if (">".equals(string2)) {
            return JsonOperator.GREATER_THAN;
        }
        if ("<".equals(string2)) {
            return JsonOperator.LESS_THAN;
        }
        throw new IllegalArgumentException("Unsupported operator symbol: '" + string + "'");
    }
}

