/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.capability;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class DatabaseInfo {
    private final DatabaseType type;
    private final int majorVersion;
    private final int minorVersion;
    private final String productName;
    private final String productVersion;

    @JsonCreator
    public DatabaseInfo(@JsonProperty(value="type") DatabaseType databaseType, @JsonProperty(value="majorVersion") int n, @JsonProperty(value="minorVersion") int n2, @JsonProperty(value="productName") String string, @JsonProperty(value="productVersion") String string2) {
        this.type = Objects.requireNonNull(databaseType, "type");
        this.majorVersion = n;
        this.minorVersion = n2;
        this.productName = string;
        this.productVersion = string2;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public boolean isAtLeast(int n, int n2) {
        if (this.majorVersion > n) {
            return true;
        }
        if (this.majorVersion < n) {
            return false;
        }
        return this.minorVersion >= n2;
    }

    public String toString() {
        return "DatabaseInfo{type=" + String.valueOf((Object)this.type) + ", major=" + this.majorVersion + ", minor=" + this.minorVersion + ", productName='" + this.productName + "', productVersion='" + this.productVersion + "'}";
    }

    public static enum DatabaseType {
        DERBY,
        POSTGRESQL,
        MYSQL,
        SQLSERVER,
        ORACLE;

    }
}

