/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.capability;

import com.mirth.connect.plugins.dynamiclookup.shared.capability.DatabaseInfo;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonOperator;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonValueType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class LookupJsonCapability {
    private final DatabaseInfo databaseInfo;
    private final boolean jsonSupported;
    private final Set<String> supportedJsonIndexModes;
    private final int maxIdentifierLength;
    private static volatile LookupJsonCapability instance;

    private LookupJsonCapability(DatabaseInfo databaseInfo, boolean bl, Set<String> set, int n) {
        this.databaseInfo = Objects.requireNonNull(databaseInfo, "databaseInfo");
        this.jsonSupported = bl;
        this.supportedJsonIndexModes = Collections.unmodifiableSet(new HashSet<String>(set));
        this.maxIdentifierLength = n;
    }

    public static LookupJsonCapability forDatabase(DatabaseInfo databaseInfo) {
        Objects.requireNonNull(databaseInfo, "dbInfo");
        switch (databaseInfo.getType()) {
            case POSTGRESQL: {
                if (databaseInfo.isAtLeast(9, 4)) {
                    return LookupJsonCapability.postgres9_4(databaseInfo);
                }
                return LookupJsonCapability.noJson(databaseInfo);
            }
            case MYSQL: {
                if (databaseInfo.isAtLeast(8, 0)) {
                    return LookupJsonCapability.mysql8_0(databaseInfo);
                }
                return LookupJsonCapability.noJson(databaseInfo);
            }
            case SQLSERVER: {
                return LookupJsonCapability.sqlserver(databaseInfo);
            }
            case ORACLE: {
                if (databaseInfo.isAtLeast(12, 2)) {
                    return LookupJsonCapability.oracle12_2(databaseInfo);
                }
                return LookupJsonCapability.noJson(databaseInfo);
            }
        }
        return LookupJsonCapability.noJson(databaseInfo);
    }

    private static LookupJsonCapability noJson(DatabaseInfo databaseInfo) {
        return new LookupJsonCapability(databaseInfo, false, Collections.emptySet(), 32);
    }

    private static LookupJsonCapability postgres9_4(DatabaseInfo databaseInfo) {
        return new LookupJsonCapability(databaseInfo, true, Set.of("NONE", "FIELD"), 63);
    }

    private static LookupJsonCapability mysql8_0(DatabaseInfo databaseInfo) {
        return new LookupJsonCapability(databaseInfo, true, Set.of("NONE", "FIELD"), 64);
    }

    private static LookupJsonCapability sqlserver(DatabaseInfo databaseInfo) {
        return new LookupJsonCapability(databaseInfo, true, Set.of("NONE", "FIELD"), 128);
    }

    private static LookupJsonCapability oracle12_2(DatabaseInfo databaseInfo) {
        return new LookupJsonCapability(databaseInfo, true, Set.of("NONE", "FIELD"), 128);
    }

    public static synchronized void initialize(DatabaseInfo databaseInfo) {
        if (instance != null) {
            return;
        }
        instance = LookupJsonCapability.forDatabase(databaseInfo);
    }

    public static LookupJsonCapability getInstance() {
        if (instance == null) {
            throw new IllegalStateException("LookupJsonCapability has not been initialized.");
        }
        return instance;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public boolean isJsonSupported() {
        return this.jsonSupported;
    }

    public Set<String> getSupportedJsonIndexModes() {
        return this.supportedJsonIndexModes;
    }

    public boolean isJsonIndexModeSupported(String string) {
        if (!this.jsonSupported || string == null) {
            return false;
        }
        for (String string2 : this.supportedJsonIndexModes) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public int getMaxIdentifierLength() {
        return this.maxIdentifierLength;
    }

    public boolean supportsValueType(JsonValueType jsonValueType) {
        if (!this.jsonSupported || jsonValueType == null) {
            return false;
        }
        switch (this.databaseInfo.getType()) {
            case POSTGRESQL: 
            case MYSQL: 
            case SQLSERVER: 
            case ORACLE: {
                return jsonValueType == JsonValueType.STRING || jsonValueType == JsonValueType.NUMBER || jsonValueType == JsonValueType.BOOLEAN;
            }
        }
        return jsonValueType == JsonValueType.STRING;
    }

    public boolean supportsOperator(JsonValueType jsonValueType, JsonOperator jsonOperator) {
        if (!this.jsonSupported || jsonValueType == null || jsonOperator == null) {
            return false;
        }
        switch (this.databaseInfo.getType()) {
            case POSTGRESQL: 
            case MYSQL: 
            case SQLSERVER: 
            case ORACLE: {
                switch (jsonValueType) {
                    case STRING: 
                    case BOOLEAN: {
                        return jsonOperator == JsonOperator.EQUAL || jsonOperator == JsonOperator.NOT_EQUAL;
                    }
                    case NUMBER: {
                        return jsonOperator == JsonOperator.EQUAL || jsonOperator == JsonOperator.NOT_EQUAL || jsonOperator == JsonOperator.GREATER_THAN || jsonOperator == JsonOperator.GREATER_OR_EQUAL || jsonOperator == JsonOperator.LESS_THAN || jsonOperator == JsonOperator.LESS_OR_EQUAL;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return "LookupJsonCapability{db=" + String.valueOf(this.databaseInfo) + ", jsonSupported=" + this.jsonSupported + ", modes=" + String.valueOf(this.supportedJsonIndexModes) + ", maxIdentifierLength=" + this.maxIdentifierLength + "}";
    }
}

