/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.constant;

import java.util.Locale;

public final class LookupConstants {
    public static final String VALUE_TYPE_TEXT = "TEXT";
    public static final String VALUE_TYPE_JSON = "JSON";
    public static final String JSON_INDEX_NONE = "NONE";
    public static final String JSON_INDEX_FIELD = "FIELD";

    private LookupConstants() {
    }

    public static String normalizeValueType(String string) {
        if (string == null) {
            return VALUE_TYPE_TEXT;
        }
        switch (string.toUpperCase(Locale.ROOT)) {
            case "JSON": {
                return VALUE_TYPE_JSON;
            }
        }
        return VALUE_TYPE_TEXT;
    }

    public static String normalizeJsonIndexMode(String string) {
        if (string == null) {
            return JSON_INDEX_NONE;
        }
        switch (string.toUpperCase(Locale.ROOT)) {
            case "FIELD": {
                return JSON_INDEX_FIELD;
            }
        }
        return JSON_INDEX_NONE;
    }

    public static boolean isJsonValueType(String string) {
        return VALUE_TYPE_JSON.equalsIgnoreCase(string);
    }

    public static boolean isTextValueType(String string) {
        return VALUE_TYPE_TEXT.equalsIgnoreCase(string);
    }

    public static boolean isFieldMode(String string) {
        return JSON_INDEX_FIELD.equalsIgnoreCase(string);
    }

    public static boolean isNoneMode(String string) {
        return JSON_INDEX_NONE.equalsIgnoreCase(string);
    }
}

