/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.dto.response;

import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.CacheStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupStatistics;
import java.util.Date;

public class GroupStatisticsResponse {
    private int groupId;
    private long totalLookups;
    private long cacheHits;
    private double hitRate;
    private Date lastAccessed;
    private Date resetDate;
    private CacheStatistics cacheStatistics;

    public int getGroupId() {
        return this.groupId;
    }

    public long getTotalLookups() {
        return this.totalLookups;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public double getHitRate() {
        return this.hitRate;
    }

    public Date getLastAccessed() {
        return this.lastAccessed;
    }

    public Date getResetDate() {
        return this.resetDate;
    }

    public CacheStatistics getCacheStatistics() {
        return this.cacheStatistics;
    }

    public static GroupStatisticsResponse fromResult(LookupStatistics lookupStatistics, CacheStatistics cacheStatistics) {
        GroupStatisticsResponse groupStatisticsResponse = new GroupStatisticsResponse();
        groupStatisticsResponse.groupId = lookupStatistics.getGroupId();
        groupStatisticsResponse.totalLookups = lookupStatistics.getTotalLookups();
        groupStatisticsResponse.cacheHits = lookupStatistics.getCacheHits();
        groupStatisticsResponse.hitRate = GroupStatisticsResponse.computeHitRate(lookupStatistics.getCacheHits(), lookupStatistics.getTotalLookups());
        groupStatisticsResponse.lastAccessed = lookupStatistics.getLastAccessed();
        groupStatisticsResponse.resetDate = lookupStatistics.getResetDate();
        groupStatisticsResponse.cacheStatistics = cacheStatistics;
        return groupStatisticsResponse;
    }

    private static double computeHitRate(long l, long l2) {
        return l2 > 0L ? (double)l / (double)l2 : 0.0;
    }
}

