/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.panel;

import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.plugins.messagetrends.client.plugin.MessageTrendsClientPlugin;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageTrendsProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;

public class MessageTrendsSettingPanel
extends AbstractSettingsPanel {
    private MessageTrendsClientPlugin plugin;
    private JPanel enabledPanel;
    private JLabel enabledLabel;
    private MirthRadioButton yesEnabledRadio;
    private MirthRadioButton noEnabledRadio;
    private ButtonGroup enabledButtonGroup;
    private Frame parent;
    private MessageTrendsProperties messageTrendsProperties;

    public MessageTrendsSettingPanel(String string, MessageTrendsClientPlugin messageTrendsClientPlugin) {
        super(string);
        this.plugin = messageTrendsClientPlugin;
        this.parent = PlatformUI.MIRTH_FRAME;
        this.messageTrendsProperties = MessageTrendsProperties.fromProperties((Properties)new Properties());
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.enabledPanel = new JPanel();
        this.enabledPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.enabledPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Enable", 0, 0, new Font("Tahoma", 1, 11)));
        this.enabledLabel = new JLabel("Enable:");
        this.yesEnabledRadio = new MirthRadioButton("Yes");
        this.yesEnabledRadio.setFocusable(false);
        this.yesEnabledRadio.setBackground(Color.white);
        this.yesEnabledRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageTrendsSettingPanel.this.enabledActionPerformed();
            }
        });
        this.noEnabledRadio = new MirthRadioButton("No");
        this.noEnabledRadio.setFocusable(false);
        this.noEnabledRadio.setBackground(Color.white);
        this.noEnabledRadio.setSelected(true);
        this.noEnabledRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageTrendsSettingPanel.this.enabledActionPerformed();
            }
        });
        this.enabledButtonGroup = new ButtonGroup();
        this.enabledButtonGroup.add((AbstractButton)this.yesEnabledRadio);
        this.enabledButtonGroup.add((AbstractButton)this.noEnabledRadio);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3, novisualpadding, insets 12", "[grow]"));
        this.enabledPanel.setLayout((LayoutManager)new MigLayout("hidemode 3, novisualpadding, insets 0", "[120,right][grow]"));
        this.enabledPanel.add(this.enabledLabel);
        this.enabledPanel.add((Component)this.yesEnabledRadio, "split, gapleft 12");
        this.enabledPanel.add((Component)this.noEnabledRadio, "wrap");
        this.add(this.enabledPanel, "grow, sx, wrap");
    }

    private void enabledActionPerformed() {
    }

    public void setProperties(Properties properties) {
        this.messageTrendsProperties = MessageTrendsProperties.fromProperties((Properties)properties);
        this.yesEnabledRadio.setSelected(this.messageTrendsProperties.isEnabled());
        this.noEnabledRadio.setSelected(!this.messageTrendsProperties.isEnabled());
    }

    public Properties getProperties() {
        this.messageTrendsProperties.setEnabled(this.yesEnabledRadio.isSelected());
        return this.messageTrendsProperties.toProperties();
    }

    public void doRefresh() {
        if (PlatformUI.MIRTH_FRAME.alertRefresh()) {
            return;
        }
        this.resetInvalidSettings();
        final String string = this.getFrame().startWorking("Loading " + this.getTabName() + " properties...");
        final Properties properties = new Properties();
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    Properties properties2 = MessageTrendsSettingPanel.this.plugin.getPropertiesFromServer();
                    if (properties2 != null) {
                        properties.putAll((Map<?, ?>)properties2);
                    }
                }
                catch (Exception exception) {
                    MessageTrendsSettingPanel.this.getFrame().alertThrowable((Component)MessageTrendsSettingPanel.this.getFrame(), (Throwable)exception);
                }
                return null;
            }

            @Override
            public void done() {
                MessageTrendsSettingPanel.this.setProperties(properties);
                MessageTrendsSettingPanel.this.getFrame().stopWorking(string);
            }
        };
        swingWorker.execute();
    }

    public boolean doSave() {
        final String string = this.getFrame().startWorking("Saving " + this.getTabName() + " properties...");
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    MessageTrendsSettingPanel.this.plugin.setPropertiesToServer(MessageTrendsSettingPanel.this.getProperties());
                }
                catch (Exception exception) {
                    MessageTrendsSettingPanel.this.getFrame().alertThrowable((Component)MessageTrendsSettingPanel.this.getFrame(), (Throwable)exception);
                }
                return null;
            }

            @Override
            public void done() {
                MessageTrendsSettingPanel.this.setSaveEnabled(false);
                MessageTrendsSettingPanel.this.getFrame().stopWorking(string);
            }
        };
        swingWorker.execute();
        return true;
    }

    public void resetInvalidSettings() {
    }

    protected void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }
}

