/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.plugins.dashboardstatus.ConnectionLogItem;
import com.mirth.connect.plugins.dashboardstatus.DashboardConnectorStatusClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DashboardConnectorStatusPanel
extends JPanel {
    private static final String ID_COLUMN_HEADER = "Id";
    private static final String CHANNEL_COLUMN_HEADER = "Channel";
    private static final String TIME_COLUMN_HEADER = "Timestamp";
    private static final String CONNECTOR_INFO_COLUMN_HEADER = "Connector Info";
    private static final String EVENT_COLUMN_HEADER = "Event";
    private static final String INFORMATION_COLUMN_HEADER = "Info";
    private static final int PAUSED = 0;
    private static final int RESUMED = 1;
    private HashMap<String, Integer> channelStates = new HashMap();
    private JPopupMenu rightclickPopup;
    private ImageIcon greenBullet;
    private ImageIcon yellowBullet;
    private ImageIcon redBullet;
    private ImageIcon blueBullet;
    private ImageIcon blackBullet;
    private static final String NO_CHANNEL_SELECTED = "No Channel Selected";
    private String selectedChannelId;
    private Map<String, List<Integer>> selectedConnectors;
    private DashboardConnectorStatusClient dcsc;
    private Preferences userPreferences;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private int currentDashboardLogSize;
    private JButton clearLog;
    private JScrollPane jScrollPane1;
    private JButton logSizeChange;
    private JLabel logSizeText;
    private JTextField logSizeTextField;
    private MirthTable logTable;
    private JButton pauseResume;

    public DashboardConnectorStatusPanel(DashboardConnectorStatusClient dcsc) {
        this.dcsc = dcsc;
        this.greenBullet = new ImageIcon(Frame.class.getResource("images/bullet_green.png"));
        this.yellowBullet = new ImageIcon(Frame.class.getResource("images/bullet_yellow.png"));
        this.redBullet = new ImageIcon(Frame.class.getResource("images/bullet_red.png"));
        this.blueBullet = new ImageIcon(Frame.class.getResource("images/bullet_blue.png"));
        this.blackBullet = new ImageIcon(Frame.class.getResource("images/bullet_black.png"));
        this.channelStates.put(NO_CHANNEL_SELECTED, 1);
        this.initComponents();
        this.initLayouts();
        this.clearLog.setIcon(UIConstants.ICON_X);
        this.clearLog.setToolTipText("Clear Displayed Log");
        this.logSizeChange.setIcon(UIConstants.ICON_CHECK);
        this.logSizeChange.setToolTipText("Change Log Display Size");
        this.makeLogTable();
        this.logSizeTextField.setDocument((Document)new MirthFieldConstraints(3, false, false, true));
        this.userPreferences = Preferences.userNodeForPackage(Mirth.class);
        this.currentDashboardLogSize = this.userPreferences.getInt("dashboardLogSize", 250);
        this.logSizeTextField.setText("" + this.currentDashboardLogSize);
    }

    public void initLayouts() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.pauseResume, -2, -1, -2).addGap(2, 2, 2).addComponent(this.clearLog, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 336, Short.MAX_VALUE).addComponent(this.logSizeText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logSizeTextField, -2, 45, -2).addGap(2, 2, 2).addComponent(this.logSizeChange, -2, -1, -2).addGap(2, 2, 2)).addComponent(this.jScrollPane1, -1, 508, Short.MAX_VALUE));
        layout.linkSize(0, this.clearLog, this.logSizeChange, this.pauseResume);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 345, Short.MAX_VALUE).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pauseResume, -2, -1, -2).addComponent(this.clearLog, -2, -1, -2).addComponent(this.logSizeChange, -2, -1, -2).addComponent(this.logSizeTextField, -2, -1, -2).addComponent(this.logSizeText))));
        layout.linkSize(1, this.clearLog, this.logSizeChange, this.pauseResume);
    }

    public void makeLogTable() {
        this.updateTable(null);
        this.logTable.setDoubleBuffered(true);
        this.logTable.setSelectionMode(0);
        this.logTable.getColumnExt((Object)ID_COLUMN_HEADER).setVisible(false);
        this.logTable.getColumnExt((Object)EVENT_COLUMN_HEADER).setCellRenderer((TableCellRenderer)new ImageCellRenderer());
        this.logTable.packTable(10);
        this.logTable.setRowHeight(20);
        this.logTable.setOpaque(true);
        this.logTable.setRowSelectionAllowed(false);
        this.logTable.setSortable(true);
        this.logTable.setFocusable(false);
        this.logTable.setHorizontalScrollEnabled(true);
        this.logTable.setAutoResizeMode(4);
        this.createPopupMenu();
        this.jScrollPane1.setViewportView((Component)this.logTable);
    }

    public void createPopupMenu() {
        this.rightclickPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Pause Log");
        menuItem.setIcon(UIConstants.ICON_PAUSE);
        menuItem.addActionListener(new PauseResumeActionListener());
        this.rightclickPopup.add(menuItem);
        menuItem = new JMenuItem("Resume Log");
        menuItem.setIcon(UIConstants.ICON_RESUME);
        menuItem.addActionListener(new PauseResumeActionListener());
        this.rightclickPopup.add(menuItem);
        this.rightclickPopup.addSeparator();
        menuItem = new JMenuItem("Clear Log");
        menuItem.setIcon(UIConstants.ICON_X);
        menuItem.addActionListener(new ClearLogActionListener());
        this.rightclickPopup.add(menuItem);
        this.rightclickPopup.getComponent(0).setVisible(true);
        this.rightclickPopup.getComponent(1).setVisible(false);
        PopupListener popupListener = new PopupListener(this.rightclickPopup);
        this.jScrollPane1.addMouseListener(popupListener);
        this.logTable.addMouseListener((MouseListener)popupListener);
    }

    public int getCurrentDashboardLogSize() {
        return this.currentDashboardLogSize;
    }

    public void setSelectedChannelId(String channelId) {
        this.selectedChannelId = channelId;
    }

    public void setSelectedConnectors(Map<String, List<Integer>> selectedConnectors) {
        this.selectedConnectors = selectedConnectors;
    }

    public boolean isPaused(String channelId) {
        if (this.channelStates.containsKey(channelId)) {
            return this.channelStates.get(channelId) == 0;
        }
        this.channelStates.put(channelId, 1);
        return false;
    }

    public void resetAllChannelStates() {
        this.channelStates.clear();
    }

    public void adjustPauseResumeButton(String channelId) {
        if (this.isPaused(channelId)) {
            this.pauseResume.setIcon(UIConstants.ICON_RESUME);
            this.pauseResume.setToolTipText("Resume Log");
            this.rightclickPopup.getComponent(0).setVisible(false);
            this.rightclickPopup.getComponent(1).setVisible(true);
        } else {
            this.pauseResume.setIcon(UIConstants.ICON_PAUSE);
            this.pauseResume.setToolTipText("Pause Log");
            this.rightclickPopup.getComponent(0).setVisible(true);
            this.rightclickPopup.getComponent(1).setVisible(false);
        }
    }

    public synchronized void updateTable(LinkedList<ConnectionLogItem> channelLogs) {
        Object[][] tableData;
        if (channelLogs != null) {
            tableData = new Object[channelLogs.size()][6];
            int tableSize = 0;
            for (int i = 0; i < channelLogs.size(); ++i) {
                ConnectionLogItem logItem = channelLogs.get(i);
                String channelId = logItem.getChannelId();
                Integer metaDataId = logItem.getMetadataId().intValue();
                boolean addRow = false;
                if (this.selectedConnectors == null) {
                    addRow = true;
                } else {
                    List<Integer> selectedMetaDataIds = this.selectedConnectors.get(channelId);
                    boolean bl = addRow = selectedMetaDataIds != null && (selectedMetaDataIds.contains(null) || selectedMetaDataIds.contains(metaDataId));
                }
                if (!addRow) continue;
                ++tableSize;
                tableData[i][0] = logItem.getLogId();
                tableData[i][1] = logItem.getDateAdded();
                tableData[i][2] = logItem.getChannelName();
                tableData[i][3] = logItem.getConnectorType();
                if (logItem.getEventState().equalsIgnoreCase("IDLE")) {
                    tableData[i][4] = new CellData(this.yellowBullet, "Idle");
                } else if (logItem.getEventState().equalsIgnoreCase("READING")) {
                    tableData[i][4] = new CellData(this.greenBullet, "Reading");
                } else if (logItem.getEventState().equalsIgnoreCase("WRITING")) {
                    tableData[i][4] = new CellData(this.greenBullet, "Writing");
                } else if (logItem.getEventState().equalsIgnoreCase("POLLING")) {
                    tableData[i][4] = new CellData(this.greenBullet, "Polling");
                } else if (logItem.getEventState().equalsIgnoreCase("RECEIVING")) {
                    tableData[i][4] = new CellData(this.greenBullet, "Receiving");
                } else if (logItem.getEventState().equalsIgnoreCase("SENDING")) {
                    tableData[i][4] = new CellData(this.greenBullet, "Sending");
                } else if (logItem.getEventState().equalsIgnoreCase("WAITING FOR RESPONSE")) {
                    tableData[i][4] = new CellData(this.yellowBullet, "Waiting for Response");
                } else if (logItem.getEventState().equalsIgnoreCase("CONNECTED")) {
                    tableData[i][4] = new CellData(this.greenBullet, "Connected");
                } else if (logItem.getEventState().equalsIgnoreCase("CONNECTING")) {
                    tableData[i][4] = new CellData(this.yellowBullet, "Connecting");
                } else if (logItem.getEventState().equalsIgnoreCase("DISCONNECTED")) {
                    tableData[i][4] = new CellData(this.redBullet, "Disconnected");
                } else if (logItem.getEventState().equalsIgnoreCase("INFO")) {
                    tableData[i][4] = new CellData(this.blueBullet, INFORMATION_COLUMN_HEADER);
                } else if (logItem.getEventState().equalsIgnoreCase("FAILURE")) {
                    tableData[i][4] = new CellData(this.blackBullet, "Failure");
                }
                tableData[i][5] = logItem.getInformation();
            }
            if (tableData.length > tableSize) {
                Object[][] newTableData = new Object[tableSize][6];
                int j = 0;
                for (int i = 0; i < tableData.length; ++i) {
                    if (tableData[i][0] == null) continue;
                    newTableData[j] = tableData[i];
                    ++j;
                }
                tableData = newTableData;
            }
        } else {
            tableData = new Object[0][6];
        }
        if (this.logTable != null) {
            RefreshTableModel model = (RefreshTableModel)this.logTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.logTable = new MirthTable();
            this.logTable.setModel((TableModel)new RefreshTableModel(tableData, new String[]{ID_COLUMN_HEADER, TIME_COLUMN_HEADER, CHANNEL_COLUMN_HEADER, CONNECTOR_INFO_COLUMN_HEADER, EVENT_COLUMN_HEADER, INFORMATION_COLUMN_HEADER}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false, false, false, false, false};
                }

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.logTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    private void initComponents() {
        this.logSizeChange = new JButton();
        this.clearLog = new JButton();
        this.pauseResume = new JButton();
        this.logSizeTextField = new JTextField();
        this.logSizeText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.logTable = null;
        this.logSizeChange.setBorderPainted(false);
        this.logSizeChange.setContentAreaFilled(false);
        this.logSizeChange.setMargin(new Insets(4, 4, 4, 4));
        this.logSizeChange.setMaximumSize(new Dimension(24, 24));
        this.logSizeChange.setMinimumSize(new Dimension(24, 24));
        this.logSizeChange.setPreferredSize(new Dimension(24, 24));
        this.logSizeChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardConnectorStatusPanel.this.logSizeChangeActionPerformed(evt);
            }
        });
        this.logSizeChange.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DashboardConnectorStatusPanel.this.logSizeChangeMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DashboardConnectorStatusPanel.this.logSizeChangeMouseExited(evt);
            }
        });
        this.clearLog.setBorderPainted(false);
        this.clearLog.setContentAreaFilled(false);
        this.clearLog.setMargin(new Insets(4, 4, 4, 4));
        this.clearLog.setMaximumSize(new Dimension(24, 24));
        this.clearLog.setMinimumSize(new Dimension(24, 24));
        this.clearLog.setPreferredSize(new Dimension(24, 24));
        this.clearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardConnectorStatusPanel.this.clearLogActionPerformed(evt);
            }
        });
        this.clearLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DashboardConnectorStatusPanel.this.clearLogMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DashboardConnectorStatusPanel.this.clearLogMouseExited(evt);
            }
        });
        this.pauseResume.setBorderPainted(false);
        this.pauseResume.setContentAreaFilled(false);
        this.pauseResume.setMargin(new Insets(4, 4, 4, 4));
        this.pauseResume.setMaximumSize(new Dimension(24, 24));
        this.pauseResume.setMinimumSize(new Dimension(24, 24));
        this.pauseResume.setPreferredSize(new Dimension(24, 24));
        this.pauseResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardConnectorStatusPanel.this.pauseResumeActionPerformed(evt);
            }
        });
        this.pauseResume.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DashboardConnectorStatusPanel.this.pauseResumeMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DashboardConnectorStatusPanel.this.pauseResumeMouseExited(evt);
            }
        });
        this.logSizeTextField.setHorizontalAlignment(4);
        this.logSizeTextField.setMaximumSize(new Dimension(45, 19));
        this.logSizeTextField.setMinimumSize(new Dimension(45, 19));
        this.logSizeTextField.setPreferredSize(new Dimension(45, 19));
        this.logSizeText.setText("Log Size:");
        this.jScrollPane1.setViewportView((Component)this.logTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.pauseResume, -2, -1, -2).addGap(2, 2, 2).addComponent(this.clearLog, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 336, Short.MAX_VALUE).addComponent(this.logSizeText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logSizeTextField, -2, 45, -2).addGap(2, 2, 2).addComponent(this.logSizeChange, -2, -1, -2).addGap(2, 2, 2)).addComponent(this.jScrollPane1, -1, 508, Short.MAX_VALUE));
        layout.linkSize(0, this.clearLog, this.logSizeChange, this.pauseResume);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 345, Short.MAX_VALUE).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pauseResume, -2, -1, -2).addComponent(this.clearLog, -2, -1, -2).addComponent(this.logSizeChange, -2, -1, -2).addComponent(this.logSizeTextField, -2, -1, -2).addComponent(this.logSizeText))));
        layout.linkSize(1, this.clearLog, this.logSizeChange, this.pauseResume);
    }

    private void pauseResumeActionPerformed(ActionEvent evt) {
        if (!this.isPaused(this.selectedChannelId)) {
            this.channelStates.put(this.selectedChannelId, 0);
        } else {
            this.channelStates.put(this.selectedChannelId, 1);
        }
        this.adjustPauseResumeButton(this.selectedChannelId);
    }

    private void clearLogActionPerformed(ActionEvent evt) {
        this.dcsc.clearLog(this.selectedChannelId);
    }

    private void logSizeChangeActionPerformed(ActionEvent evt) {
        if (this.logSizeTextField.getText().length() == 0) {
            this.parent.alertWarning((Component)this, "Please enter a valid number.");
            return;
        }
        int newDashboardLogSize = Integer.parseInt(this.logSizeTextField.getText());
        if (newDashboardLogSize != this.currentDashboardLogSize) {
            if (newDashboardLogSize <= 0) {
                this.parent.alertWarning((Component)this, "Please enter a log size that is larger than 0.");
            } else {
                this.userPreferences.putInt("dashboardLogSize", newDashboardLogSize);
                this.currentDashboardLogSize = newDashboardLogSize;
                this.dcsc.resetLogSize(newDashboardLogSize, this.selectedChannelId);
            }
        }
    }

    private void logSizeChangeMouseExited(MouseEvent evt) {
        this.logSizeChange.setBorderPainted(false);
        this.logSizeChange.setContentAreaFilled(false);
    }

    private void logSizeChangeMouseEntered(MouseEvent evt) {
        this.logSizeChange.setBorderPainted(true);
        this.logSizeChange.setContentAreaFilled(true);
    }

    private void clearLogMouseExited(MouseEvent evt) {
        this.clearLog.setBorderPainted(false);
        this.clearLog.setContentAreaFilled(false);
    }

    private void clearLogMouseEntered(MouseEvent evt) {
        this.clearLog.setBorderPainted(true);
        this.clearLog.setContentAreaFilled(true);
    }

    private void pauseResumeMouseExited(MouseEvent evt) {
        this.pauseResume.setBorderPainted(false);
        this.pauseResume.setContentAreaFilled(false);
    }

    private void pauseResumeMouseEntered(MouseEvent evt) {
        this.pauseResume.setBorderPainted(true);
        this.pauseResume.setContentAreaFilled(true);
    }

    class PauseResumeActionListener
    implements ActionListener {
        PauseResumeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DashboardConnectorStatusPanel.this.isPaused(DashboardConnectorStatusPanel.this.selectedChannelId)) {
                DashboardConnectorStatusPanel.this.channelStates.put(DashboardConnectorStatusPanel.this.selectedChannelId, 0);
            } else {
                DashboardConnectorStatusPanel.this.channelStates.put(DashboardConnectorStatusPanel.this.selectedChannelId, 1);
            }
            DashboardConnectorStatusPanel.this.adjustPauseResumeButton(DashboardConnectorStatusPanel.this.selectedChannelId);
        }
    }

    class ClearLogActionListener
    implements ActionListener {
        ClearLogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardConnectorStatusPanel.this.dcsc.clearLog(DashboardConnectorStatusPanel.this.selectedChannelId);
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

