/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.xml;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReceiver;
import com.mirth.connect.plugins.datatypes.xml.XMLBatchProperties;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.message.DebuggableBatchAdaptor;
import com.mirth.connect.server.message.DebuggableBatchAdaptorFactory;
import com.mirth.connect.server.userutil.SourceMap;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLBatchAdaptor
extends DebuggableBatchAdaptor {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private BufferedReader bufferedReader;
    private XPathFactory xPathFactory = XPathFactory.newInstance();
    private NodeList nodeList;
    private int currentNode = 0;

    public XMLBatchAdaptor(DebuggableBatchAdaptorFactory factory, SourceConnector sourceConnector, BatchRawMessage batchRawMessage) {
        super((BatchAdaptorFactory)factory, sourceConnector, batchRawMessage);
    }

    public void cleanup() throws BatchMessageException {
    }

    protected String getNextMessage(int batchSequenceId) throws Exception {
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReader) {
            if (batchSequenceId == 1) {
                BatchMessageReader batchMessageReader = (BatchMessageReader)this.batchRawMessage.getBatchMessageSource();
                this.bufferedReader = new BufferedReader(batchMessageReader.getReader());
            }
            return this.getMessageFromReader();
        }
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReceiver) {
            return this.getMessageFromReceiver((BatchMessageReceiver)this.batchRawMessage.getBatchMessageSource());
        }
        return null;
    }

    private String getMessageFromReceiver(BatchMessageReceiver batchMessageReceiver) throws Exception {
        byte[] bytes = null;
        if (batchMessageReceiver.canRead()) {
            try {
                bytes = batchMessageReceiver.readBytes();
            }
            finally {
                batchMessageReceiver.readCompleted();
            }
            if (bytes != null) {
                return batchMessageReceiver.getStringFromBytes(bytes);
            }
        }
        return null;
    }

    private String getMessageFromReader() throws Exception {
        XMLBatchProperties batchProperties = (XMLBatchProperties)this.getBatchProperties();
        XMLBatchProperties.SplitType splitType = batchProperties.getSplitType();
        if (splitType == XMLBatchProperties.SplitType.Element_Name || splitType == XMLBatchProperties.SplitType.Level || splitType == XMLBatchProperties.SplitType.XPath_Query) {
            Node node;
            if (this.nodeList == null) {
                StringBuilder query = new StringBuilder();
                if (splitType == XMLBatchProperties.SplitType.Element_Name) {
                    query.append("//*[local-name()='");
                    query.append(batchProperties.getElementName());
                    query.append("']");
                } else if (splitType == XMLBatchProperties.SplitType.Level) {
                    query.append("/*");
                    for (int i = 0; i < batchProperties.getLevel(); ++i) {
                        query.append("/*");
                    }
                } else if (splitType == XMLBatchProperties.SplitType.XPath_Query) {
                    query.append(batchProperties.getQuery());
                }
                XPath xpath = this.xPathFactory.newXPath();
                this.nodeList = (NodeList)xpath.evaluate(query.toString(), new InputSource(this.bufferedReader), XPathConstants.NODESET);
            }
            if (this.currentNode < this.nodeList.getLength() && (node = this.nodeList.item(this.currentNode++)) != null) {
                return this.toXML(node);
            }
        } else if (splitType == XMLBatchProperties.SplitType.JavaScript) {
            if (StringUtils.isEmpty((CharSequence)batchProperties.getBatchScript())) {
                throw new BatchMessageException("No batch script was set.");
            }
            try {
                final String batchScriptId = ScriptController.getScriptId((String)"Batch", (String)this.sourceConnector.getChannelId());
                Boolean debug = ((DebuggableBatchAdaptorFactory)this.getFactory()).isDebug();
                MirthContextFactory contextFactory = this.getContextFactoryAndRecompile(this.contextFactoryController, debug, batchScriptId, batchProperties.getBatchScript());
                this.triggerDebug(debug);
                String result = (String)JavaScriptUtil.execute((JavaScriptTask)new JavaScriptTask<String>(contextFactory, "XML Batch Adaptor", this.sourceConnector){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String doCall() throws Exception {
                        Script compiledScript = CompiledScriptCache.getInstance().getCompiledScript(batchScriptId);
                        if (compiledScript == null) {
                            XMLBatchAdaptor.this.logger.error("Batch script could not be found in cache");
                            return null;
                        }
                        Logger scriptLogger = LogManager.getLogger((String)"Batch".toLowerCase());
                        try {
                            Scriptable scope = JavaScriptScopeUtil.getBatchProcessorScope((ContextFactory)this.getContextFactory(), (Object)scriptLogger, (String)XMLBatchAdaptor.this.sourceConnector.getChannelId(), (String)XMLBatchAdaptor.this.sourceConnector.getChannel().getName(), XMLBatchAdaptor.this.getScopeObjects(XMLBatchAdaptor.this.bufferedReader));
                            String string = (String)Context.jsToJava((Object)this.executeScript(compiledScript, scope), String.class);
                            return string;
                        }
                        finally {
                            Context.exit();
                        }
                    }
                });
                if (StringUtils.isEmpty((CharSequence)result)) {
                    return null;
                }
                return result;
            }
            catch (JavaScriptExecutorException e) {
                this.logger.error((Object)e.getCause());
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        } else {
            throw new BatchMessageException("No valid batch splitting method configured");
        }
        return null;
    }

    private String toXML(Node node) throws Exception {
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return ((Object)writer).toString();
    }

    private Map<String, Object> getScopeObjects(Reader in) {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        scopeObjects.put("reader", in);
        scopeObjects.put("sourceMap", new SourceMap(Collections.unmodifiableMap(this.batchRawMessage.getSourceMap())));
        return scopeObjects;
    }
}

