/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.globalmapviewer;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.globalmapviewer.GlobalMapController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.util.GlobalChannelVariableStoreFactory;
import com.mirth.connect.server.util.GlobalVariableStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultGlobalMapController
extends GlobalMapController {
    private static final ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    protected static final String GLOBAL_MAP_KEY = "<Global Map>";
    private static Serializer serializer = ObjectXMLSerializer.getInstance();
    private static Logger logger = LogManager.getLogger(DefaultGlobalMapController.class);

    @Override
    public Map<String, Map<String, Map<String, String>>> getAllMaps(Set<String> channelIds, boolean includeGlobalMap) throws ControllerException {
        HashMap<String, Object> localMaps = new HashMap<String, Object>();
        if (includeGlobalMap) {
            HashMap globalMap = new HashMap();
            for (Map.Entry<String, Object> entry : GlobalVariableStore.getInstance().getVariables().entrySet()) {
                globalMap.put((String)entry.getKey(), this.serializeGlobalMapVariableValue(entry));
            }
            localMaps.put(null, globalMap);
        }
        if (channelIds == null) {
            channelIds = new HashSet(GlobalChannelVariableStoreFactory.getInstance().globalChannelVariableMap.keySet());
        }
        for (String channelId : channelIds) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : GlobalChannelVariableStoreFactory.getInstance().get(channelId).getVariables().entrySet()) {
                hashMap.put((String)entry.getKey(), this.serializeGlobalMapVariableValue(entry));
            }
            localMaps.put(channelId, hashMap);
        }
        HashMap<String, Map<String, Map<String, String>>> serverMap = new HashMap<String, Map<String, Map<String, String>>>();
        serverMap.put(configurationController.getServerId(), localMaps);
        return serverMap;
    }

    @Override
    public Map<String, String> getGlobalMap() {
        HashMap<String, String> globalMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : GlobalVariableStore.getInstance().getVariables().entrySet()) {
            globalMap.put((String)entry.getKey(), this.serializeGlobalMapVariableValue(entry));
        }
        return globalMap;
    }

    @Override
    public Map<String, String> getGlobalChannelMap(String channelId) {
        HashMap<String, String> globalChannelMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : GlobalChannelVariableStoreFactory.getInstance().get(channelId).getVariables().entrySet()) {
            globalChannelMap.put((String)entry.getKey(), this.serializeGlobalMapVariableValue(entry));
        }
        return globalChannelMap;
    }

    protected String serializeGlobalMapVariableValue(Map.Entry<String, Object> globalMapVariable) {
        String serializedValue = "";
        try {
            serializedValue = serializer.serialize(globalMapVariable.getValue());
        }
        catch (Exception e) {
            logger.warn("Non-serializable value found in map, converting value to string with key: " + globalMapVariable.getKey());
            serializedValue = String.valueOf(globalMapVariable.getValue() == null ? "" : globalMapVariable.getValue().toString());
        }
        return serializedValue;
    }
}

