-- SQL Server Migration script for Lookup Table Management System

-- Create LOOKUP_GROUP table
CREATE TABLE LOOKUP_GROUP (
    ID INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
    NAME NVARCHAR(255) NOT NULL,
    DESCRIPTION NVARCHAR(MAX),
    VERSION NVARCHAR(50),
    CACHE_SIZE INT DEFAULT 1000,
    CACHE_POLICY NVARCHAR(50) DEFAULT 'LRU',
    CREATED_DATE DATETIME DEFAULT GETDATE(),
    UPDATED_DATE DATETIME DEFAULT GETDATE()
);

CREATE UNIQUE INDEX IDX_LOOKUP_GROUP_NAME ON LOOKUP_GROUP (NAME);

-- Create LOOKUP_AUDIT table
CREATE TABLE LOOKUP_AUDIT (
    ID BIGINT IDENTITY(1,1) NOT NULL PRIMARY KEY,
    GROUP_ID INT NOT NULL,
    TABLE_NAME NVARCHAR(255) NOT NULL,
    KEY_VALUE NVARCHAR(255) NOT NULL,
    ACTION NVARCHAR(50) NOT NULL,
    OLD_VALUE NVARCHAR(MAX),
    NEW_VALUE NVARCHAR(MAX),
    USER_ID NVARCHAR(255),
    AUDIT_TIMESTAMP DATETIME DEFAULT GETDATE(),
    FOREIGN KEY (GROUP_ID) REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
);

CREATE INDEX IDX_LOOKUP_AUDIT_GROUP ON LOOKUP_AUDIT (GROUP_ID);
CREATE INDEX IDX_LOOKUP_AUDIT_KEY ON LOOKUP_AUDIT (TABLE_NAME, KEY_VALUE);

-- Optional statistics table
CREATE TABLE LOOKUP_STATISTICS (
    GROUP_ID INT NOT NULL PRIMARY KEY,
    TOTAL_LOOKUPS BIGINT DEFAULT 0,
    CACHE_HITS BIGINT DEFAULT 0,
    LAST_ACCESSED DATETIME NULL,
    RESET_DATE DATETIME DEFAULT GETDATE(),
    FOREIGN KEY (GROUP_ID) REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
);