/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import com.innovarhealthcare.launcher.CodeBase;
import com.innovarhealthcare.launcher.Credential;
import com.innovarhealthcare.launcher.JavaConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ProcessLauncher {
    public void launch(JavaConfig javaConfig, Credential credential, CodeBase codeBase, boolean isShowConsole) throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaConfig.getJavaHomeBuilder());
        command.add(javaConfig.getMaxHeapSizeBuilder());
        if (StringUtils.isNotBlank(javaConfig.getJvmOptions())) {
            command.addAll(javaConfig.getJvmOptionsList());
        }
        if (SystemUtils.IS_OS_MAC) {
            command.add("-Xdock:icon=icon.png");
            command.add("-Xdock:name=BridgeLink Administrator Launcher");
            if ("Java 17".equals(javaConfig.getJavaHome())) {
                command.add("--add-opens=java.desktop/com.apple.eawt=ALL-UNNAMED");
            }
        }
        if ("Java 17".equals(javaConfig.getJavaHome())) {
            command.add("--add-modules=java.sql.rowset");
            command.add("--add-exports=java.base/com.sun.crypto.provider=ALL-UNNAMED");
            command.add("--add-exports=java.base/sun.security.provider=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.lang.reflect=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.math=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.net=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.security=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.security.cert=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.text=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.util=ALL-UNNAMED");
            command.add("--add-opens=java.base/sun.security.pkcs=ALL-UNNAMED");
            command.add("--add-opens=java.base/sun.security.rsa=ALL-UNNAMED");
            command.add("--add-opens=java.base/sun.security.x509=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/java.awt=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/java.awt.color=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/java.awt.font=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/javax.swing=ALL-UNNAMED");
            command.add("--add-opens=java.xml/com.sun.org.apache.xalan.internal.xsltc.trax=ALL-UNNAMED");
        }
        command.add("-cp");
        command.add(String.join((CharSequence)File.pathSeparator, codeBase.getClasspath()));
        command.add(codeBase.getMainClass());
        command.add(codeBase.getHost());
        command.add(codeBase.getVersion());
        if (StringUtils.isNotBlank(credential.getUsername())) {
            command.add(credential.getUsername());
        }
        if (StringUtils.isNotBlank(credential.getPassword())) {
            command.add(credential.getPassword());
        }
        ProcessBuilder targetPb = new ProcessBuilder(command);
        targetPb.redirectErrorStream(true);
        if (isShowConsole) {
            ProcessBuilder consolePb = new ProcessBuilder(javaConfig.getJavaHomeBuilder(), "-Xmx256m", "-cp", "lib/java-console.jar", "com.innovarhealthcare.launcher.JavaConsoleDialog");
            Process consoleProcess = consolePb.start();
            if (!consoleProcess.isAlive()) {
                throw new IOException("Console process failed to start");
            }
            Process targetProcess = targetPb.start();
            if (!targetProcess.isAlive()) {
                throw new IOException("Target process failed to start");
            }
            Thread pipeThread = new Thread(() -> {
                try (OutputStream consoleInput = consoleProcess.getOutputStream();
                     InputStream targetOutput = targetProcess.getInputStream();){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = targetOutput.read(buffer)) != -1) {
                        consoleInput.write(buffer, 0, bytesRead);
                        consoleInput.flush();
                    }
                    consoleInput.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            pipeThread.start();
        } else {
            Process targetProcess = targetPb.start();
            if (!targetProcess.isAlive()) {
                throw new IOException("Target process failed to start");
            }
        }
    }
}

