/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.JDKAccessFactory;
import com.azul.crs.client.sysinfo.SystemInfoProvider;
import com.azul.crs.util.logging.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Inventory {
    public static final String INSTANCE_TAGS_PROPERTY = "com.azul.crs.instance.tags";
    public static final String HOST_NAME_KEY = "hostName";
    public static final String SYSTEM_PROPS_KEY = "systemProperties";
    public static final String CPU_INFO_KEY = "cpuInfo";
    public static final String MAIN_METHOD = "mainMethod";
    public static final String ENVIRONMENT_KEY = "osEnvironment";
    private Logger logger = Logger.getLogger(Inventory.class);
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public Inventory populate(Predicate<String> predicate, Predicate<String> predicate2) {
        this.map.put(HOST_NAME_KEY, this.hostName());
        this.map.put(SYSTEM_PROPS_KEY, new HashMap(this.systemProperties(predicate2)));
        this.map.put(ENVIRONMENT_KEY, this.osEnvironment());
        return this;
    }

    public Inventory systemInformation() {
        try {
            this.map.put(CPU_INFO_KEY, SystemInfoProvider.getCPUInfo());
        }
        catch (Exception exception) {
            this.logger.warning("Failed to get system information. The data may be incomplete", exception);
        }
        return this;
    }

    public Inventory mainMethod(String string) {
        if (string != null) {
            this.map.put(MAIN_METHOD, string);
        }
        return this;
    }

    public String hostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.logger.warning("cannot get host name %s", unknownHostException.toString());
            String string = this.getHostNameViaReflection();
            if (string == null) {
                string = this.getHostNameFromNetworkInterface();
            }
            if (string == null) {
                string = "<UNKNOWN>";
            }
            return string;
        }
    }

    public static String instanceTags() {
        return System.getProperties().getProperty(INSTANCE_TAGS_PROPERTY);
    }

    public Map systemProperties(Predicate<String> predicate) {
        Properties properties = (Properties)System.getProperties().clone();
        return properties.entrySet().stream().filter(entry -> predicate.test(entry.getKey().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, String> osEnvironment() {
        String[] stringArray = new String[]{"AZ_CRS_ARGUMENTS", "CRS_IMAGE", "CRS_OWNER", "CRS_SERVICE", "CRS_DATACENTER", "CRS_TAGS"};
        return System.getenv().entrySet().stream().filter(entry -> Arrays.stream(stringArray).anyMatch(((String)entry.getKey())::equals)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static List<String> jvmArgs() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments();
    }

    public Map<String, Object> toMap() {
        return this.map;
    }

    private String getHostNameViaReflection() {
        try {
            return JDKAccessFactory.getAccessor().getHostNameViaReflection();
        }
        catch (InternalError internalError) {
            this.logger.warning("cannot get host name", internalError);
            return null;
        }
    }

    private String getHostNameFromNetworkInterface() {
        try {
            String string = null;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress instanceof Inet4Address) {
                        return inetAddress.getCanonicalHostName();
                    }
                    string = inetAddress.getCanonicalHostName();
                }
            }
            return string;
        }
        catch (SocketException socketException) {
            this.logger.warning("cannot get host name for iface %s", socketException.toString());
            return null;
        }
    }
}

