/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util.async;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.util.Utils;
import com.azul.crs.client.util.async.AsyncPipeline;
import com.azul.crs.util.logging.Logger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;

public class AsyncResourceHandler<T> {
    private static final Logger logger = Logger.getLogger(AsyncPipeline.class);
    private static final AtomicLong unhandledExceptionsCounter = new AtomicLong();
    private T obj = null;
    private final AsyncPipeline<T> pipeline;
    AsyncResourceHandler<T> outer = null;
    AsyncResourceHandler<T> inner = null;
    public Consumer<Exception> errorHandler = null;
    public Runnable finalizer = null;
    public Function<AsyncResourceHandler<T>, AsyncResourceHandler<T>> allocator = null;
    volatile boolean finalized = false;
    volatile Exception exception;

    AsyncResourceHandler(AsyncPipeline<T> asyncPipeline) {
        this.pipeline = asyncPipeline;
    }

    public T getObject() {
        return this.obj;
    }

    public AsyncResourceHandler<T> next() {
        return this.inner;
    }

    public static void dump() {
        logger.trace("unhandled exceptions: %d", unhandledExceptionsCounter.get());
    }

    private synchronized void cancelImpl(Exception exception) {
        if (this.outer == null) {
            logger.debug("on(%s) cancel(%s) obj(%s)", Utils.toStringWithIdentityHash(this), exception, Utils.toStringWithIdentityHash(this.obj));
            if (this.errorHandler == null) {
                unhandledExceptionsCounter.incrementAndGet();
            }
        }
        this.exception = exception;
        if (this.errorHandler != null) {
            try {
                this.errorHandler.accept(exception);
            }
            catch (Throwable throwable) {
                logger.debug("Exception during finalizer: on(%s) obj(%s) exception(%s)", Utils.toStringWithIdentityHash(this), Utils.toStringWithIdentityHash(this.obj), throwable);
                unhandledExceptionsCounter.incrementAndGet();
            }
        }
        if (this.outer != null) {
            super.cancelImpl(exception);
        }
    }

    public void cancel(Exception exception) {
        this.cancelImpl(exception);
        this.finalize();
    }

    public synchronized void finalize() {
        if (Tweaks.DEBUG_ASYNC_UTILS) {
            logger.trace("on(%s) finalize: obj(%s)", Utils.toStringWithIdentityHash(this), Utils.toStringWithIdentityHash(this.obj));
        }
        if (this.finalized) {
            return;
        }
        this.finalized = true;
        if (this.finalizer != null) {
            try {
                this.finalizer.run();
            }
            catch (Throwable throwable) {
                logger.debug("Exception during finalizer: on(%s) obj(%s) exception(%s)", Utils.toStringWithIdentityHash(this), Utils.toStringWithIdentityHash(this.obj), throwable);
                unhandledExceptionsCounter.incrementAndGet();
            }
        }
        if (this.outer != null) {
            this.outer.finalize();
        }
    }

    public void accept(T t) {
        if (Tweaks.DEBUG_ASYNC_UTILS) {
            logger.trace("on(%s) accept: obj(%s) => t(%s)", Utils.toStringWithIdentityHash(this), Utils.toStringWithIdentityHash(this.obj), Utils.toStringWithIdentityHash(t));
        }
        if (this.finalized) {
            return;
        }
        if (this.exception != null) {
            return;
        }
        try {
            this.obj = t;
            if (this.allocator != null) {
                AsyncResourceHandler<T> asyncResourceHandler = this.allocator.apply(this);
                this.inner = asyncResourceHandler;
            } else {
                this.finalize();
            }
        }
        catch (Exception exception) {
            this.cancel(exception);
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "[pipeline=" + Utils.toStringWithIdentityHash(this.pipeline) + ", obj=" + (this.obj == null ? null : this.obj.getClass().getName() + "@" + System.identityHashCode(this.obj)) + "]";
    }
}

