/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.digest;

import com.azul.crs.digest.ConstantPool;
import com.azul.crs.digest.CountingInputStream;
import com.azul.crs.digest.Digest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

final class ByteCodeProcessor {
    private final ByteBuffer buffer = ByteBuffer.allocate(20);
    private final ConstantPoolMapper cp;
    private boolean wide = false;
    private static final T[] NONE = new T[0];

    ByteCodeProcessor(ConstantPool constantPool) {
        this.cp = new ConstantPoolMapper(constantPool);
    }

    void processMethodByteCode(CountingInputStream countingInputStream, Digest digest) throws IOException {
        int n;
        OpCode opCode = OpCode.getOpCode(countingInputStream.readUnsignedByte());
        this.buffer.clear();
        this.buffer.putShort((short)opCode.replaceWith.ordinal());
        if (opCode == OpCode.TABLESWITCH || opCode == OpCode.LOOKUPSWITCH) {
            n = countingInputStream.position() % 4;
            int n2 = n == 0 ? 0 : 4 - n;
            for (int i = 0; i < n2; ++i) {
                byte by = countingInputStream.readByte();
                if (by == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + (Object)((Object)opCode) + ":" + by);
            }
            countingInputStream.readInt();
        }
        switch (opCode.switchCase) {
            case TABLESWITCH: {
                int n3 = countingInputStream.readInt();
                int n4 = countingInputStream.readInt();
                this.buffer.putInt(n3);
                this.buffer.putInt(n4);
                for (n = 0; n < n4 - n3 + 1 << 2; ++n) {
                    countingInputStream.read();
                }
                break;
            }
            case LOOKUPSWITCH: {
                int n5 = countingInputStream.readInt();
                this.buffer.putInt(n5);
                for (n = 0; n < n5 << 3; ++n) {
                    countingInputStream.read();
                }
                break;
            }
            case DISCARD_SHORT_IMMEDIATE: {
                countingInputStream.readShort();
                break;
            }
            case DISCARD_INT_IMMEDIATE: {
                countingInputStream.readInt();
                break;
            }
            case DISCARD_IMMEDIATE_REF: {
                if (this.wide) {
                    countingInputStream.readUnsignedShort();
                    this.wide = false;
                    break;
                }
                countingInputStream.readUnsignedByte();
                break;
            }
            case WIDE: {
                this.wide = true;
                break;
            }
            case NEWARRAY: {
                this.buffer.put(countingInputStream.readByte());
                break;
            }
            case CONSTANT_FIELDREF: {
                int n6 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n6));
                break;
            }
            case CONSTANT_CLASS: {
                int n7 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n7));
                break;
            }
            case INVOKESPECIAL: {
                int n8 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n8));
                break;
            }
            case INVOKEVIRTUAL: {
                int n9 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n9));
                break;
            }
            case INVOKEINTERFACE: {
                int n10 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n10));
                this.buffer.putInt(countingInputStream.readUnsignedByte());
                this.buffer.putInt(countingInputStream.readUnsignedByte());
                break;
            }
            case INVOKEDYNAMIC: {
                int n11 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n11));
                this.buffer.putInt(countingInputStream.readUnsignedByte());
                this.buffer.putInt(countingInputStream.readUnsignedByte());
                break;
            }
            case LDC_W: {
                int n12 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n12));
                break;
            }
            case LDC: {
                int n13 = countingInputStream.readUnsignedByte();
                this.buffer.putInt(this.cp.mapIndex(n13));
                break;
            }
            case ANEWARRAY: {
                int n14 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(this.cp.mapIndex(n14));
                break;
            }
            case MULTIANEWARRAY: {
                int n15 = countingInputStream.readUnsignedShort();
                this.buffer.putInt(countingInputStream.readUnsignedByte());
                this.buffer.putInt(this.cp.mapIndex(n15));
                break;
            }
            case IINC: {
                short s;
                if (this.wide) {
                    countingInputStream.readUnsignedShort();
                    s = countingInputStream.readShort();
                    this.wide = false;
                } else {
                    countingInputStream.readUnsignedByte();
                    s = countingInputStream.readByte();
                }
                this.buffer.putInt(s);
                break;
            }
            case NO_ARG: {
                break;
            }
            default: {
                block29: for (T t : opCode.operandTypes) {
                    switch (t) {
                        case BYTE: {
                            this.buffer.put(countingInputStream.readByte());
                            continue block29;
                        }
                        case SHORT: {
                            this.buffer.putShort(countingInputStream.readShort());
                            continue block29;
                        }
                        case INT: {
                            this.buffer.putInt(countingInputStream.readInt());
                            continue block29;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached!");
                        }
                    }
                }
            }
        }
        digest.update(this.buffer);
    }

    private static final class ConstantPoolMapper
    extends HashMap<Integer, Integer> {
        private final ConstantPool cp;
        private int counter = 0;

        public ConstantPoolMapper(ConstantPool constantPool) {
            this.cp = constantPool;
        }

        public int mapIndex(int n2) {
            n2 = this.cp.dedup(n2);
            return this.computeIfAbsent(n2, n -> this.counter++);
        }
    }

    static enum OpCode {
        NOP,
        ACONST_NULL,
        ICONST_M1,
        ICONST_0,
        ICONST_1,
        ICONST_2,
        ICONST_3,
        ICONST_4,
        ICONST_5,
        LCONST_0,
        LCONST_1,
        FCONST_0,
        FCONST_1,
        FCONST_2,
        DCONST_0,
        DCONST_1,
        BIPUSH(T.BYTE),
        SIPUSH(T.SHORT),
        LDC(OpCodeCase.LDC, T.BYTE),
        LDC_W(LDC, OpCodeCase.LDC_W, T.SHORT),
        LDC2_W(LDC, OpCodeCase.LDC_W, T.SHORT),
        ILOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        LLOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        FLOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        DLOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ALOAD(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ILOAD_0(ILOAD, OpCodeCase.NO_ARG),
        ILOAD_1(ILOAD, OpCodeCase.NO_ARG),
        ILOAD_2(ILOAD, OpCodeCase.NO_ARG),
        ILOAD_3(ILOAD, OpCodeCase.NO_ARG),
        LLOAD_0(LLOAD, OpCodeCase.NO_ARG),
        LLOAD_1(LLOAD, OpCodeCase.NO_ARG),
        LLOAD_2(LLOAD, OpCodeCase.NO_ARG),
        LLOAD_3(LLOAD, OpCodeCase.NO_ARG),
        FLOAD_0(FLOAD, OpCodeCase.NO_ARG),
        FLOAD_1(FLOAD, OpCodeCase.NO_ARG),
        FLOAD_2(FLOAD, OpCodeCase.NO_ARG),
        FLOAD_3(FLOAD, OpCodeCase.NO_ARG),
        DLOAD_0(DLOAD, OpCodeCase.NO_ARG),
        DLOAD_1(DLOAD, OpCodeCase.NO_ARG),
        DLOAD_2(DLOAD, OpCodeCase.NO_ARG),
        DLOAD_3(DLOAD, OpCodeCase.NO_ARG),
        ALOAD_0(ALOAD, OpCodeCase.NO_ARG),
        ALOAD_1(ALOAD, OpCodeCase.NO_ARG),
        ALOAD_2(ALOAD, OpCodeCase.NO_ARG),
        ALOAD_3(ALOAD, OpCodeCase.NO_ARG),
        IALOAD,
        LALOAD,
        FALOAD,
        DALOAD,
        AALOAD,
        BALOAD,
        CALOAD,
        SALOAD,
        ISTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        LSTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        FSTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        DSTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ASTORE(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        ISTORE_0(ISTORE, OpCodeCase.NO_ARG),
        ISTORE_1(ISTORE, OpCodeCase.NO_ARG),
        ISTORE_2(ISTORE, OpCodeCase.NO_ARG),
        ISTORE_3(ISTORE, OpCodeCase.NO_ARG),
        LSTORE_0(LSTORE, OpCodeCase.NO_ARG),
        LSTORE_1(LSTORE, OpCodeCase.NO_ARG),
        LSTORE_2(LSTORE, OpCodeCase.NO_ARG),
        LSTORE_3(LSTORE, OpCodeCase.NO_ARG),
        FSTORE_0(FSTORE, OpCodeCase.NO_ARG),
        FSTORE_1(FSTORE, OpCodeCase.NO_ARG),
        FSTORE_2(FSTORE, OpCodeCase.NO_ARG),
        FSTORE_3(FSTORE, OpCodeCase.NO_ARG),
        DSTORE_0(DSTORE, OpCodeCase.NO_ARG),
        DSTORE_1(DSTORE, OpCodeCase.NO_ARG),
        DSTORE_2(DSTORE, OpCodeCase.NO_ARG),
        DSTORE_3(DSTORE, OpCodeCase.NO_ARG),
        ASTORE_0(ASTORE, OpCodeCase.NO_ARG),
        ASTORE_1(ASTORE, OpCodeCase.NO_ARG),
        ASTORE_2(ASTORE, OpCodeCase.NO_ARG),
        ASTORE_3(ASTORE, OpCodeCase.NO_ARG),
        IASTORE,
        LASTORE,
        FASTORE,
        DASTORE,
        AASTORE,
        BASTORE,
        CASTORE,
        SASTORE,
        POP,
        POP2,
        DUP,
        DUP_X1,
        DUP_X2,
        DUP2,
        DUP2_X1,
        DUP2_X2,
        SWAP,
        IADD,
        LADD,
        FADD,
        DADD,
        ISUB,
        LSUB,
        FSUB,
        DSUB,
        IMUL,
        LMUL,
        FMUL,
        DMUL,
        IDIV,
        LDIV,
        FDIV,
        DDIV,
        IREM,
        LREM,
        FREM,
        DREM,
        INEG,
        LNEG,
        FNEG,
        DNEG,
        ISHL,
        LSHL,
        ISHR,
        LSHR,
        IUSHR,
        LUSHR,
        IAND,
        LAND,
        IOR,
        LOR,
        IXOR,
        LXOR,
        IINC(OpCodeCase.IINC, T.BYTE, T.BYTE),
        I2L,
        I2F,
        I2D,
        L2I,
        L2F,
        L2D,
        F2I,
        F2L,
        F2D,
        D2I,
        D2L,
        D2F,
        I2B,
        I2C,
        I2S,
        LCMP,
        FCMPL,
        FCMPG,
        DCMPL,
        DCMPG,
        IFEQ(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFNE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFLT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFGE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFGT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFLE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPEQ(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPNE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPLT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPGE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPGT(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ICMPLE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ACMPEQ(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IF_ACMPNE(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        GOTO(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        JSR(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        RET(OpCodeCase.DISCARD_IMMEDIATE_REF, T.BYTE),
        TABLESWITCH(OpCodeCase.TABLESWITCH),
        LOOKUPSWITCH(OpCodeCase.LOOKUPSWITCH),
        IRETURN,
        LRETURN,
        FRETURN,
        DRETURN,
        ARETURN,
        RETURN,
        GETSTATIC(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        PUTSTATIC(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        GETFIELD(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        PUTFIELD(OpCodeCase.CONSTANT_FIELDREF, T.SHORT),
        INVOKEVIRTUAL(OpCodeCase.INVOKEVIRTUAL, T.SHORT),
        INVOKESPECIAL(OpCodeCase.INVOKESPECIAL, T.SHORT),
        INVOKESTATIC(OpCodeCase.INVOKESPECIAL, T.SHORT),
        INVOKEINTERFACE(OpCodeCase.INVOKEINTERFACE, T.SHORT, T.BYTE, T.BYTE),
        INVOKEDYNAMIC(OpCodeCase.INVOKEDYNAMIC, T.SHORT, T.BYTE, T.BYTE),
        NEW(OpCodeCase.CONSTANT_CLASS, T.SHORT),
        NEWARRAY(OpCodeCase.NEWARRAY, T.BYTE),
        ANEWARRAY(OpCodeCase.ANEWARRAY, T.SHORT),
        ARRAYLENGTH,
        ATHROW,
        CHECKCAST(OpCodeCase.CONSTANT_CLASS, T.SHORT),
        INSTANCEOF(OpCodeCase.CONSTANT_CLASS, T.SHORT),
        MONITORENTER,
        MONITOREXIT,
        WIDE(OpCodeCase.WIDE),
        MULTIANEWARRAY(OpCodeCase.MULTIANEWARRAY, T.SHORT, T.BYTE),
        IFNULL(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        IFNONNULL(OpCodeCase.DISCARD_SHORT_IMMEDIATE, T.SHORT),
        GOTO_W(GOTO, OpCodeCase.DISCARD_INT_IMMEDIATE, T.INT),
        JSR_W(JSR, OpCodeCase.DISCARD_INT_IMMEDIATE, T.INT),
        BREAKPOINT,
        LDC_QUICK,
        LDC_W_QUICK(LDC_QUICK),
        LDC2_W_QUICK(LDC_QUICK),
        GETFIELD_QUICK,
        PUTFIELD_QUICK,
        GETFIELD2_QUICK,
        PUTFIELD2_QUICK,
        GETSTATIC_QUICK,
        PUTSTATIC_QUICK,
        GETSTATIC2_QUICK,
        PUTSTATIC2_QUICK,
        INVOKEVIRTUAL_QUICK,
        INVOKENONVIRTUAL_QUICK,
        INVOKESUPER_QUICK,
        INVOKESTATIC_QUICK,
        INVOKEINTERFACE_QUICK,
        INVOKEVIRTUALOBJECT_QUICK,
        RESERVED_220,
        NEW_QUICK,
        ANEWARRAY_QUICK,
        MULTIANEWARRAY_QUICK,
        CHECKCAST_QUICK,
        INSTANCEOF_QUICK,
        INVOKEVIRTUAL_QUICK_W(INVOKEVIRTUAL_QUICK),
        GETFIELD_QUICK_W(GETFIELD_QUICK),
        PUTFIELD_QUICK_W(PUTFIELD_QUICK),
        RESERVED_229,
        RESERVED_230,
        RESERVED_231,
        RESERVED_232,
        RESERVED_233,
        RESERVED_234,
        RESERVED_235,
        RESERVED_236,
        RESERVED_237,
        RESERVED_238,
        RESERVED_239,
        RESERVED_240,
        RESERVED_241,
        RESERVED_242,
        RESERVED_243,
        RESERVED_244,
        RESERVED_245,
        RESERVED_246,
        RESERVED_247,
        RESERVED_248,
        RESERVED_249,
        RESERVED_250,
        RESERVED_251,
        RESERVED_252,
        RESERVED_253,
        IMPDEP1,
        IMPDEP2;

        final OpCode replaceWith;
        final OpCodeCase switchCase;
        final T[] operandTypes;
        private static final OpCode[] opCodes;

        static OpCode getOpCode(int n) {
            return opCodes[n];
        }

        private OpCode() {
            this.replaceWith = this;
            this.switchCase = OpCodeCase.SWITCH_DEFAULT;
            this.operandTypes = NONE;
        }

        private OpCode(T ... tArray) {
            this.replaceWith = this;
            this.switchCase = OpCodeCase.SWITCH_DEFAULT;
            this.operandTypes = tArray;
        }

        private OpCode(OpCode opCode) {
            this.replaceWith = opCode;
            this.switchCase = OpCodeCase.SWITCH_DEFAULT;
            this.operandTypes = NONE;
        }

        private OpCode(OpCodeCase opCodeCase) {
            this.replaceWith = this;
            this.switchCase = opCodeCase;
            this.operandTypes = NONE;
        }

        private OpCode(OpCodeCase opCodeCase, T ... tArray) {
            this.replaceWith = this;
            this.switchCase = opCodeCase;
            this.operandTypes = tArray;
        }

        private OpCode(OpCode opCode, OpCodeCase opCodeCase) {
            this.replaceWith = opCode;
            this.switchCase = opCodeCase;
            this.operandTypes = NONE;
        }

        private OpCode(OpCode opCode, OpCodeCase opCodeCase, T ... tArray) {
            this.replaceWith = opCode;
            this.switchCase = opCodeCase;
            this.operandTypes = tArray;
        }

        static {
            opCodes = OpCode.values();
        }
    }

    private static enum T {
        BYTE,
        SHORT,
        INT;

    }

    private static enum OpCodeCase {
        SWITCH_DEFAULT,
        TABLESWITCH,
        LOOKUPSWITCH,
        DISCARD_SHORT_IMMEDIATE,
        DISCARD_INT_IMMEDIATE,
        DISCARD_IMMEDIATE_REF,
        WIDE,
        NEWARRAY,
        CONSTANT_FIELDREF,
        CONSTANT_CLASS,
        INVOKESPECIAL,
        INVOKEVIRTUAL,
        INVOKEINTERFACE,
        INVOKEDYNAMIC,
        LDC_W,
        LDC,
        ANEWARRAY,
        MULTIANEWARRAY,
        IINC,
        NO_ARG;

    }
}

