/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.digest;

import com.azul.crs.digest.ByteCodeProcessor;
import com.azul.crs.digest.ConstantPool;
import com.azul.crs.digest.CountingInputStream;
import com.azul.crs.digest.Digest;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;

public final class ShadedClassHashCalculator {
    private ShadedClassHashCalculator() {
    }

    public static void updateHash(InputStream inputStream, Digest digest) throws IllegalAccessException, IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != -889275714) {
            throw new IllegalAccessException("Error reading class - not valid type");
        }
        digest.update(dataInputStream.readShort());
        digest.update(dataInputStream.readShort());
        ConstantPool constantPool = ConstantPool.readConstantPool(dataInputStream);
        if (constantPool == null) {
            throw new IllegalAccessException("Error reading class - not valid class");
        }
        digest.update(dataInputStream.readShort());
        digest.update(constantPool.getClassShortName(dataInputStream.readUnsignedShort()));
        digest.update(constantPool.getClassShortName(dataInputStream.readUnsignedShort()));
        TreeSet<String> treeSet = new TreeSet<String>();
        int n3 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n3; ++i) {
            treeSet.add(constantPool.getClassShortName(dataInputStream.readUnsignedShort()));
        }
        treeSet.forEach(digest::update);
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        n3 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n3; ++i) {
            n = dataInputStream.readShort();
            int n4 = dataInputStream.readUnsignedShort();
            dataInputStream.readShort();
            ShadedClassHashCalculator.skipAttributes(dataInputStream);
            stringBuilder.setLength(0);
            stringBuilder.append(constantPool.getStringConstant(n4));
            stringBuilder.append(n);
            treeSet2.add(stringBuilder.toString());
        }
        treeSet2.forEach(digest::update);
        TreeSet<String> treeSet3 = new TreeSet<String>();
        n3 = dataInputStream.readUnsignedShort();
        for (n = 0; n < n3; ++n) {
            Digest digest2 = Digest.get();
            digest2.update(dataInputStream.readShort());
            digest2.update(constantPool.getStringConstant(dataInputStream.readUnsignedShort()));
            dataInputStream.readShort();
            ShadedClassHashCalculator.processMethodAttribures(dataInputStream, constantPool, digest2);
            treeSet3.add(digest2.asHexString());
        }
        treeSet3.forEach(digest::update);
    }

    private static void skipAttributes(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            dataInputStream.readShort();
            dataInputStream.skipBytes(dataInputStream.readInt());
        }
    }

    private static void processMethodAttribures(DataInputStream dataInputStream, ConstantPool constantPool, Digest digest) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.readInt();
            if ("Code".equals(constantPool.getStringConstant(n2))) {
                digest.update(dataInputStream.readShort());
                dataInputStream.readShort();
                int n4 = dataInputStream.readInt();
                ByteCodeProcessor byteCodeProcessor = new ByteCodeProcessor(constantPool);
                CountingInputStream countingInputStream = new CountingInputStream(dataInputStream);
                while (countingInputStream.position() < n4) {
                    byteCodeProcessor.processMethodByteCode(countingInputStream, digest);
                }
                dataInputStream.skipBytes(n3 - 8 - n4);
                continue;
            }
            dataInputStream.skipBytes(n3);
        }
    }
}

