/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLPeerUnverifiedException;
import jdk.internal.event.EventHelper;
import jdk.jfr.events.TLSHandshakeEvent;
import sun.misc.HexDumpEncoder;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.ssl.Alert;
import sun.security.ssl.Authenticator;
import sun.security.ssl.ChangeCipherSpec;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.NewSessionTicket;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLBasicKeyDerivation;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLSecretDerivation;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;

final class Finished {
    static final SSLConsumer t12HandshakeConsumer = new T12FinishedConsumer();
    static final HandshakeProducer t12HandshakeProducer = new T12FinishedProducer();
    static final SSLConsumer t13HandshakeConsumer = new T13FinishedConsumer();
    static final HandshakeProducer t13HandshakeProducer = new T13FinishedProducer();

    Finished() {
    }

    private static void recordEvent(SSLSessionImpl sSLSessionImpl) {
        TLSHandshakeEvent tLSHandshakeEvent = new TLSHandshakeEvent();
        if (tLSHandshakeEvent.shouldCommit() || EventHelper.isLoggingSecurity()) {
            int n = 0;
            try {
                n = sSLSessionImpl.getCertificateChain()[0].hashCode();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
            if (tLSHandshakeEvent.shouldCommit()) {
                tLSHandshakeEvent.peerHost = sSLSessionImpl.getPeerHost();
                tLSHandshakeEvent.peerPort = sSLSessionImpl.getPeerPort();
                tLSHandshakeEvent.cipherSuite = sSLSessionImpl.getCipherSuite();
                tLSHandshakeEvent.protocolVersion = sSLSessionImpl.getProtocol();
                tLSHandshakeEvent.certificateId = n;
                tLSHandshakeEvent.commit();
            }
            if (EventHelper.isLoggingSecurity()) {
                EventHelper.logTLSHandshakeEvent(null, sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort(), sSLSessionImpl.getCipherSuite(), sSLSessionImpl.getProtocol(), n);
            }
        }
    }

    private static final class T13FinishedConsumer
    implements SSLConsumer {
        private T13FinishedConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            if (handshakeContext.sslConfig.isClientMode) {
                this.onConsumeFinished((ClientHandshakeContext)connectionContext, byteBuffer);
            } else {
                this.onConsumeFinished((ServerHandshakeContext)connectionContext, byteBuffer);
            }
        }

        private void onConsumeFinished(ClientHandshakeContext clientHandshakeContext, ByteBuffer byteBuffer) throws IOException {
            Object object;
            SSLHandshake[] sSLHandshakeArray;
            if (clientHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.ENCRYPTED_EXTENSIONS.id)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected Finished handshake message");
            }
            if (!clientHandshakeContext.isResumption && (clientHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id) || clientHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE_VERIFY.id))) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected Finished handshake message");
            }
            FinishedMessage finishedMessage = new FinishedMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming server Finished handshake message", finishedMessage);
            }
            if (clientHandshakeContext.conContext.secureRenegotiation) {
                clientHandshakeContext.conContext.serverVerifyData = finishedMessage.verifyData;
            }
            clientHandshakeContext.conContext.consumers.remove(ContentType.CHANGE_CIPHER_SPEC.id);
            clientHandshakeContext.handshakeHash.update();
            SSLKeyDerivation sSLKeyDerivation = clientHandshakeContext.handshakeKeyDerivation;
            if (sSLKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "no key derivation");
            }
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            if (!clientHandshakeContext.isResumption && clientHandshakeContext.handshakeSession.isRejoinable()) {
                sSLHandshakeArray = (SSLSessionContextImpl)clientHandshakeContext.sslContext.engineGetClientSessionContext();
                sSLHandshakeArray.put(clientHandshakeContext.handshakeSession);
            }
            try {
                sSLHandshakeArray = sSLKeyDerivation.deriveKey("TlsSaltSecret", null);
                SSLHandshake[] sSLHandshakeArray2 = clientHandshakeContext.negotiatedCipherSuite.hashAlg;
                HKDF hKDF = new HKDF(sSLHandshakeArray2.name);
                byte[] byArray = new byte[sSLHandshakeArray2.hashLength];
                SecretKeySpec object2 = new SecretKeySpec(byArray, "TlsZeroSecret");
                object = hKDF.extract((SecretKey)sSLHandshakeArray, (SecretKey)object2, "TlsMasterSecret");
                SSLSecretDerivation sSLSecretDerivation = new SSLSecretDerivation(clientHandshakeContext, (SecretKey)object);
                SecretKey secretKey = sSLSecretDerivation.deriveKey("TlsServerAppTrafficSecret", null);
                SSLKeyDerivation sSLKeyDerivation2 = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
                SecretKey secretKey2 = sSLKeyDerivation2.deriveKey("TlsKey", null);
                SecretKey secretKey3 = sSLKeyDerivation2.deriveKey("TlsIv", null);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey3.getEncoded());
                SSLCipher.SSLReadCipher sSLReadCipher = clientHandshakeContext.negotiatedCipherSuite.bulkCipher.createReadCipher(Authenticator.valueOf(clientHandshakeContext.negotiatedProtocol), clientHandshakeContext.negotiatedProtocol, secretKey2, ivParameterSpec, clientHandshakeContext.sslContext.getSecureRandom());
                if (sSLReadCipher == null) {
                    throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)clientHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)clientHandshakeContext.negotiatedProtocol) + ")");
                }
                clientHandshakeContext.baseReadSecret = secretKey;
                clientHandshakeContext.conContext.inputRecord.changeReadCiphers(sSLReadCipher);
                clientHandshakeContext.handshakeKeyDerivation = sSLSecretDerivation;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failure to derive application secrets", generalSecurityException);
            }
            clientHandshakeContext.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            for (SSLHandshake sSLHandshake : sSLHandshakeArray = new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_VERIFY, SSLHandshake.FINISHED}) {
                object = (HandshakeProducer)clientHandshakeContext.handshakeProducers.remove(sSLHandshake.id);
                if (object == null) continue;
                object.produce(clientHandshakeContext, null);
            }
        }

        private void onConsumeFinished(ServerHandshakeContext serverHandshakeContext, ByteBuffer byteBuffer) throws IOException {
            Object object;
            SSLKeyDerivation sSLKeyDerivation;
            if (!serverHandshakeContext.isResumption && (serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id) || serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE_VERIFY.id))) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected Finished handshake message");
            }
            FinishedMessage finishedMessage = new FinishedMessage(serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming client Finished handshake message", finishedMessage);
            }
            if (serverHandshakeContext.conContext.secureRenegotiation) {
                serverHandshakeContext.conContext.clientVerifyData = finishedMessage.verifyData;
            }
            if ((sSLKeyDerivation = serverHandshakeContext.handshakeKeyDerivation) == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "no key derivation");
            }
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            if (!serverHandshakeContext.isResumption && serverHandshakeContext.handshakeSession.isRejoinable()) {
                object = (SSLSessionContextImpl)serverHandshakeContext.sslContext.engineGetServerSessionContext();
                ((SSLSessionContextImpl)object).put(serverHandshakeContext.handshakeSession);
            }
            try {
                object = sSLKeyDerivation.deriveKey("TlsClientAppTrafficSecret", null);
                SSLKeyDerivation sSLKeyDerivation2 = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, (SecretKey)object);
                SecretKey secretKey = sSLKeyDerivation2.deriveKey("TlsKey", null);
                SecretKey secretKey2 = sSLKeyDerivation2.deriveKey("TlsIv", null);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey2.getEncoded());
                SSLCipher.SSLReadCipher sSLReadCipher = serverHandshakeContext.negotiatedCipherSuite.bulkCipher.createReadCipher(Authenticator.valueOf(serverHandshakeContext.negotiatedProtocol), serverHandshakeContext.negotiatedProtocol, secretKey, ivParameterSpec, serverHandshakeContext.sslContext.getSecureRandom());
                if (sSLReadCipher == null) {
                    throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)serverHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)serverHandshakeContext.negotiatedProtocol) + ")");
                }
                serverHandshakeContext.baseReadSecret = object;
                serverHandshakeContext.conContext.inputRecord.changeReadCiphers(sSLReadCipher);
                serverHandshakeContext.handshakeHash.update();
                SSLSecretDerivation sSLSecretDerivation = ((SSLSecretDerivation)sSLKeyDerivation).forContext(serverHandshakeContext);
                SecretKey secretKey3 = sSLSecretDerivation.deriveKey("TlsResumptionMasterSecret", null);
                serverHandshakeContext.handshakeSession.setResumptionMasterSecret(secretKey3);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failure to derive application secrets", generalSecurityException);
            }
            serverHandshakeContext.conContext.conSession = serverHandshakeContext.handshakeSession.finish();
            serverHandshakeContext.conContext.protocolVersion = serverHandshakeContext.negotiatedProtocol;
            serverHandshakeContext.handshakeFinished = true;
            serverHandshakeContext.conContext.finishHandshake();
            Finished.recordEvent(serverHandshakeContext.conContext.conSession);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Sending new session ticket", new Object[0]);
            }
            NewSessionTicket.kickstartProducer.produce(serverHandshakeContext);
        }
    }

    private static final class T13FinishedProducer
    implements HandshakeProducer {
        private T13FinishedProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            if (handshakeContext.sslConfig.isClientMode) {
                return this.onProduceFinished((ClientHandshakeContext)connectionContext, handshakeMessage);
            }
            return this.onProduceFinished((ServerHandshakeContext)connectionContext, handshakeMessage);
        }

        private byte[] onProduceFinished(ClientHandshakeContext clientHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            Object object2;
            SSLKeyDerivation sSLKeyDerivation;
            clientHandshakeContext.handshakeHash.update();
            FinishedMessage finishedMessage = new FinishedMessage(clientHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced client Finished handshake message", finishedMessage);
            }
            finishedMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            if (clientHandshakeContext.conContext.secureRenegotiation) {
                clientHandshakeContext.conContext.clientVerifyData = finishedMessage.verifyData;
            }
            if ((sSLKeyDerivation = clientHandshakeContext.handshakeKeyDerivation) == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "no key derivation");
            }
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            try {
                object2 = sSLKeyDerivation.deriveKey("TlsClientAppTrafficSecret", null);
                object = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, (SecretKey)object2);
                SecretKey secretKey = object.deriveKey("TlsKey", null);
                SecretKey secretKey2 = object.deriveKey("TlsIv", null);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey2.getEncoded());
                SSLCipher.SSLWriteCipher sSLWriteCipher = clientHandshakeContext.negotiatedCipherSuite.bulkCipher.createWriteCipher(Authenticator.valueOf(clientHandshakeContext.negotiatedProtocol), clientHandshakeContext.negotiatedProtocol, secretKey, ivParameterSpec, clientHandshakeContext.sslContext.getSecureRandom());
                if (sSLWriteCipher == null) {
                    throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)clientHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)clientHandshakeContext.negotiatedProtocol) + ")");
                }
                clientHandshakeContext.baseWriteSecret = object2;
                clientHandshakeContext.conContext.outputRecord.changeWriteCiphers(sSLWriteCipher, false);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failure to derive application secrets", generalSecurityException);
            }
            object2 = ((SSLSecretDerivation)sSLKeyDerivation).forContext(clientHandshakeContext);
            object = ((SSLSecretDerivation)object2).deriveKey("TlsResumptionMasterSecret", null);
            clientHandshakeContext.handshakeSession.setResumptionMasterSecret((SecretKey)object);
            clientHandshakeContext.conContext.conSession = clientHandshakeContext.handshakeSession.finish();
            clientHandshakeContext.conContext.protocolVersion = clientHandshakeContext.negotiatedProtocol;
            clientHandshakeContext.handshakeFinished = true;
            clientHandshakeContext.conContext.finishHandshake();
            Finished.recordEvent(clientHandshakeContext.conContext.conSession);
            return null;
        }

        private byte[] onProduceFinished(ServerHandshakeContext serverHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            serverHandshakeContext.handshakeHash.update();
            FinishedMessage finishedMessage = new FinishedMessage(serverHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced server Finished handshake message", finishedMessage);
            }
            finishedMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            SSLKeyDerivation sSLKeyDerivation = serverHandshakeContext.handshakeKeyDerivation;
            if (sSLKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "no key derivation");
            }
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            try {
                SecretKey secretKey = sSLKeyDerivation.deriveKey("TlsSaltSecret", null);
                CipherSuite.HashAlg hashAlg = serverHandshakeContext.negotiatedCipherSuite.hashAlg;
                HKDF hKDF = new HKDF(hashAlg.name);
                byte[] byArray = new byte[hashAlg.hashLength];
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "TlsZeroSecret");
                SecretKey secretKey2 = hKDF.extract(secretKey, (SecretKey)secretKeySpec, "TlsMasterSecret");
                SSLSecretDerivation sSLSecretDerivation = new SSLSecretDerivation(serverHandshakeContext, secretKey2);
                SecretKey secretKey3 = sSLSecretDerivation.deriveKey("TlsServerAppTrafficSecret", null);
                SSLKeyDerivation sSLKeyDerivation2 = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey3);
                SecretKey secretKey4 = sSLKeyDerivation2.deriveKey("TlsKey", null);
                SecretKey secretKey5 = sSLKeyDerivation2.deriveKey("TlsIv", null);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey5.getEncoded());
                SSLCipher.SSLWriteCipher sSLWriteCipher = serverHandshakeContext.negotiatedCipherSuite.bulkCipher.createWriteCipher(Authenticator.valueOf(serverHandshakeContext.negotiatedProtocol), serverHandshakeContext.negotiatedProtocol, secretKey4, ivParameterSpec, serverHandshakeContext.sslContext.getSecureRandom());
                if (sSLWriteCipher == null) {
                    throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)serverHandshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)serverHandshakeContext.negotiatedProtocol) + ")");
                }
                serverHandshakeContext.baseWriteSecret = secretKey3;
                serverHandshakeContext.conContext.outputRecord.changeWriteCiphers(sSLWriteCipher, false);
                serverHandshakeContext.handshakeKeyDerivation = sSLSecretDerivation;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failure to derive application secrets", generalSecurityException);
            }
            if (serverHandshakeContext.conContext.secureRenegotiation) {
                serverHandshakeContext.conContext.serverVerifyData = finishedMessage.verifyData;
            }
            serverHandshakeContext.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            return null;
        }
    }

    private static final class T12FinishedConsumer
    implements SSLConsumer {
        private T12FinishedConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            handshakeContext.handshakeConsumers.remove(SSLHandshake.FINISHED.id);
            if (handshakeContext.conContext.consumers.containsKey(ContentType.CHANGE_CIPHER_SPEC.id)) {
                throw handshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Missing ChangeCipherSpec message");
            }
            if (handshakeContext.sslConfig.isClientMode) {
                this.onConsumeFinished((ClientHandshakeContext)connectionContext, byteBuffer);
            } else {
                this.onConsumeFinished((ServerHandshakeContext)connectionContext, byteBuffer);
            }
        }

        private void onConsumeFinished(ClientHandshakeContext clientHandshakeContext, ByteBuffer byteBuffer) throws IOException {
            SSLHandshake[] sSLHandshakeArray;
            FinishedMessage finishedMessage = new FinishedMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming server Finished handshake message", finishedMessage);
            }
            if (clientHandshakeContext.conContext.secureRenegotiation) {
                clientHandshakeContext.conContext.serverVerifyData = finishedMessage.verifyData;
            }
            if (!clientHandshakeContext.isResumption) {
                if (clientHandshakeContext.handshakeSession.isRejoinable()) {
                    ((SSLSessionContextImpl)clientHandshakeContext.sslContext.engineGetClientSessionContext()).put(clientHandshakeContext.handshakeSession);
                }
                clientHandshakeContext.conContext.conSession = clientHandshakeContext.handshakeSession.finish();
                clientHandshakeContext.conContext.protocolVersion = clientHandshakeContext.negotiatedProtocol;
                clientHandshakeContext.handshakeFinished = true;
                Finished.recordEvent(clientHandshakeContext.conContext.conSession);
                clientHandshakeContext.conContext.finishHandshake();
            } else {
                clientHandshakeContext.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            }
            for (SSLHandshake sSLHandshake : sSLHandshakeArray = new SSLHandshake[]{SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)clientHandshakeContext.handshakeProducers.remove(sSLHandshake.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(clientHandshakeContext, finishedMessage);
            }
        }

        private void onConsumeFinished(ServerHandshakeContext serverHandshakeContext, ByteBuffer byteBuffer) throws IOException {
            SSLHandshake[] sSLHandshakeArray;
            if (!serverHandshakeContext.isResumption && serverHandshakeContext.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE_VERIFY.id)) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected Finished handshake message");
            }
            FinishedMessage finishedMessage = new FinishedMessage(serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming client Finished handshake message", finishedMessage);
            }
            if (serverHandshakeContext.conContext.secureRenegotiation) {
                serverHandshakeContext.conContext.clientVerifyData = finishedMessage.verifyData;
            }
            if (serverHandshakeContext.isResumption) {
                if (serverHandshakeContext.handshakeSession.isRejoinable()) {
                    ((SSLSessionContextImpl)serverHandshakeContext.sslContext.engineGetServerSessionContext()).put(serverHandshakeContext.handshakeSession);
                }
                serverHandshakeContext.conContext.conSession = serverHandshakeContext.handshakeSession.finish();
                serverHandshakeContext.conContext.protocolVersion = serverHandshakeContext.negotiatedProtocol;
                serverHandshakeContext.handshakeFinished = true;
                Finished.recordEvent(serverHandshakeContext.conContext.conSession);
                serverHandshakeContext.conContext.finishHandshake();
            } else {
                serverHandshakeContext.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            }
            for (SSLHandshake sSLHandshake : sSLHandshakeArray = new SSLHandshake[]{SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)serverHandshakeContext.handshakeProducers.remove(sSLHandshake.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(serverHandshakeContext, finishedMessage);
            }
        }
    }

    private static final class T12FinishedProducer
    implements HandshakeProducer {
        private T12FinishedProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            if (handshakeContext.sslConfig.isClientMode) {
                return this.onProduceFinished((ClientHandshakeContext)connectionContext, handshakeMessage);
            }
            return this.onProduceFinished((ServerHandshakeContext)connectionContext, handshakeMessage);
        }

        private byte[] onProduceFinished(ClientHandshakeContext clientHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            clientHandshakeContext.handshakeHash.update();
            FinishedMessage finishedMessage = new FinishedMessage(clientHandshakeContext);
            ChangeCipherSpec.t10Producer.produce(clientHandshakeContext, handshakeMessage);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced client Finished handshake message", finishedMessage);
            }
            finishedMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            if (clientHandshakeContext.conContext.secureRenegotiation) {
                clientHandshakeContext.conContext.clientVerifyData = finishedMessage.verifyData;
            }
            if (!clientHandshakeContext.isResumption) {
                clientHandshakeContext.conContext.consumers.put(ContentType.CHANGE_CIPHER_SPEC.id, ChangeCipherSpec.t10Consumer);
                clientHandshakeContext.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            } else {
                if (clientHandshakeContext.handshakeSession.isRejoinable()) {
                    ((SSLSessionContextImpl)clientHandshakeContext.sslContext.engineGetClientSessionContext()).put(clientHandshakeContext.handshakeSession);
                }
                clientHandshakeContext.conContext.conSession = clientHandshakeContext.handshakeSession.finish();
                clientHandshakeContext.conContext.protocolVersion = clientHandshakeContext.negotiatedProtocol;
                clientHandshakeContext.handshakeFinished = true;
                clientHandshakeContext.conContext.finishHandshake();
            }
            return null;
        }

        private byte[] onProduceFinished(ServerHandshakeContext serverHandshakeContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            serverHandshakeContext.handshakeHash.update();
            FinishedMessage finishedMessage = new FinishedMessage(serverHandshakeContext);
            ChangeCipherSpec.t10Producer.produce(serverHandshakeContext, handshakeMessage);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced server Finished handshake message", finishedMessage);
            }
            finishedMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            if (serverHandshakeContext.conContext.secureRenegotiation) {
                serverHandshakeContext.conContext.serverVerifyData = finishedMessage.verifyData;
            }
            if (serverHandshakeContext.isResumption) {
                serverHandshakeContext.conContext.consumers.put(ContentType.CHANGE_CIPHER_SPEC.id, ChangeCipherSpec.t10Consumer);
                serverHandshakeContext.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            } else {
                if (serverHandshakeContext.handshakeSession.isRejoinable()) {
                    ((SSLSessionContextImpl)serverHandshakeContext.sslContext.engineGetServerSessionContext()).put(serverHandshakeContext.handshakeSession);
                }
                serverHandshakeContext.conContext.conSession = serverHandshakeContext.handshakeSession.finish();
                serverHandshakeContext.conContext.protocolVersion = serverHandshakeContext.negotiatedProtocol;
                serverHandshakeContext.handshakeFinished = true;
                serverHandshakeContext.conContext.finishHandshake();
            }
            return null;
        }
    }

    private static final class T13VerifyDataGenerator
    implements VerifyDataGenerator {
        private static final byte[] hkdfLabel = "tls13 finished".getBytes();
        private static final byte[] hkdfContext = new byte[0];

        private T13VerifyDataGenerator() {
        }

        @Override
        public byte[] createVerifyData(HandshakeContext handshakeContext, boolean bl) throws IOException {
            CipherSuite.HashAlg hashAlg = handshakeContext.negotiatedCipherSuite.hashAlg;
            SecretKey secretKey = bl ? handshakeContext.baseReadSecret : handshakeContext.baseWriteSecret;
            SSLBasicKeyDerivation sSLBasicKeyDerivation = new SSLBasicKeyDerivation(secretKey, hashAlg.name, hkdfLabel, hkdfContext, hashAlg.hashLength);
            SSLBasicKeyDerivation.SecretSizeSpec secretSizeSpec = new SSLBasicKeyDerivation.SecretSizeSpec(hashAlg.hashLength);
            SecretKey secretKey2 = sSLBasicKeyDerivation.deriveKey("TlsFinishedSecret", secretSizeSpec);
            String string = "Hmac" + hashAlg.name.replace("-", "");
            try {
                Mac mac = JsseJce.getMac(string);
                mac.init(secretKey2);
                return mac.doFinal(handshakeContext.handshakeHash.digest());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                throw new ProviderException("Failed to generate verify_data", generalSecurityException);
            }
        }
    }

    private static final class T12VerifyDataGenerator
    implements VerifyDataGenerator {
        private T12VerifyDataGenerator() {
        }

        @Override
        public byte[] createVerifyData(HandshakeContext handshakeContext, boolean bl) throws IOException {
            CipherSuite cipherSuite = handshakeContext.negotiatedCipherSuite;
            HandshakeHash handshakeHash = handshakeContext.handshakeHash;
            SecretKey secretKey = handshakeContext.handshakeSession.getMasterSecret();
            boolean bl2 = handshakeContext.sslConfig.isClientMode && !bl || !handshakeContext.sslConfig.isClientMode && bl;
            String string = bl2 ? "client finished" : "server finished";
            try {
                byte[] byArray = handshakeHash.digest();
                String string2 = "SunTls12Prf";
                CipherSuite.HashAlg hashAlg = cipherSuite.hashAlg;
                TlsPrfParameterSpec tlsPrfParameterSpec = new TlsPrfParameterSpec(secretKey, string, byArray, 12, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
                KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string2);
                keyGenerator.init(tlsPrfParameterSpec);
                SecretKey secretKey2 = keyGenerator.generateKey();
                if (!"RAW".equals(secretKey2.getFormat())) {
                    throw new ProviderException("Invalid PRF output, format must be RAW. Format received: " + secretKey2.getFormat());
                }
                byte[] byArray2 = secretKey2.getEncoded();
                return byArray2;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("PRF failed", generalSecurityException);
            }
        }
    }

    private static final class T10VerifyDataGenerator
    implements VerifyDataGenerator {
        private T10VerifyDataGenerator() {
        }

        @Override
        public byte[] createVerifyData(HandshakeContext handshakeContext, boolean bl) throws IOException {
            HandshakeHash handshakeHash = handshakeContext.handshakeHash;
            SecretKey secretKey = handshakeContext.handshakeSession.getMasterSecret();
            boolean bl2 = handshakeContext.sslConfig.isClientMode && !bl || !handshakeContext.sslConfig.isClientMode && bl;
            String string = bl2 ? "client finished" : "server finished";
            try {
                byte[] byArray = handshakeHash.digest();
                String string2 = "SunTlsPrf";
                CipherSuite.HashAlg hashAlg = CipherSuite.HashAlg.H_NONE;
                TlsPrfParameterSpec tlsPrfParameterSpec = new TlsPrfParameterSpec(secretKey, string, byArray, 12, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
                KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string2);
                keyGenerator.init(tlsPrfParameterSpec);
                SecretKey secretKey2 = keyGenerator.generateKey();
                if (!"RAW".equals(secretKey2.getFormat())) {
                    throw new ProviderException("Invalid PRF output, format must be RAW. Format received: " + secretKey2.getFormat());
                }
                byte[] byArray2 = secretKey2.getEncoded();
                return byArray2;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("PRF failed", generalSecurityException);
            }
        }
    }

    private static final class S30VerifyDataGenerator
    implements VerifyDataGenerator {
        private S30VerifyDataGenerator() {
        }

        @Override
        public byte[] createVerifyData(HandshakeContext handshakeContext, boolean bl) throws IOException {
            HandshakeHash handshakeHash = handshakeContext.handshakeHash;
            SecretKey secretKey = handshakeContext.handshakeSession.getMasterSecret();
            boolean bl2 = handshakeContext.sslConfig.isClientMode && !bl || !handshakeContext.sslConfig.isClientMode && bl;
            return handshakeHash.digest(bl2, secretKey);
        }
    }

    static enum VerifyDataScheme {
        SSL30("kdf_ssl30", new S30VerifyDataGenerator()),
        TLS10("kdf_tls10", new T10VerifyDataGenerator()),
        TLS12("kdf_tls12", new T12VerifyDataGenerator()),
        TLS13("kdf_tls13", new T13VerifyDataGenerator());

        final String name;
        final VerifyDataGenerator generator;

        private VerifyDataScheme(String string2, VerifyDataGenerator verifyDataGenerator) {
            this.name = string2;
            this.generator = verifyDataGenerator;
        }

        static VerifyDataScheme valueOf(ProtocolVersion protocolVersion) {
            switch (protocolVersion) {
                case SSL30: {
                    return SSL30;
                }
                case TLS10: 
                case TLS11: {
                    return TLS10;
                }
                case TLS12: {
                    return TLS12;
                }
                case TLS13: {
                    return TLS13;
                }
            }
            return null;
        }

        public byte[] createVerifyData(HandshakeContext handshakeContext, boolean bl) throws IOException {
            if (this.generator != null) {
                return this.generator.createVerifyData(handshakeContext, bl);
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static interface VerifyDataGenerator {
        public byte[] createVerifyData(HandshakeContext var1, boolean var2) throws IOException;
    }

    private static final class FinishedMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] verifyData;

        FinishedMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            VerifyDataScheme verifyDataScheme = VerifyDataScheme.valueOf(handshakeContext.negotiatedProtocol);
            byte[] byArray = null;
            try {
                byArray = verifyDataScheme.createVerifyData(handshakeContext, false);
            }
            catch (IOException iOException) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Failed to generate verify_data", iOException);
            }
            this.verifyData = byArray;
        }

        FinishedMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            byte[] byArray;
            int n = 12;
            if (handshakeContext.negotiatedProtocol == ProtocolVersion.SSL30) {
                n = 36;
            } else if (handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                n = handshakeContext.negotiatedCipherSuite.hashAlg.hashLength;
            }
            if (byteBuffer.remaining() != n) {
                throw handshakeContext.conContext.fatal(Alert.DECODE_ERROR, "Inappropriate finished message: need " + n + " but remaining " + byteBuffer.remaining() + " bytes verify_data");
            }
            this.verifyData = new byte[n];
            byteBuffer.get(this.verifyData);
            VerifyDataScheme verifyDataScheme = VerifyDataScheme.valueOf(handshakeContext.negotiatedProtocol);
            try {
                byArray = verifyDataScheme.createVerifyData(handshakeContext, true);
            }
            catch (IOException iOException) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Failed to generate verify_data", iOException);
            }
            if (!MessageDigest.isEqual(byArray, this.verifyData)) {
                throw handshakeContext.conContext.fatal(Alert.DECRYPT_ERROR, "The Finished message cannot be verified.");
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.FINISHED;
        }

        @Override
        public int messageLength() {
            return this.verifyData.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.write(this.verifyData);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"Finished\": '{'\n  \"verify data\": '{'\n{0}\n  '}''}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encode(this.verifyData), "    ")};
            return messageFormat.format(objectArray);
        }
    }
}

