/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.innovarhealthcare.launcher.BundledJava;
import com.innovarhealthcare.launcher.CodeBase;
import com.innovarhealthcare.launcher.Connection;
import com.innovarhealthcare.launcher.Credential;
import com.innovarhealthcare.launcher.DownloadJNLP;
import com.innovarhealthcare.launcher.HeapMemory;
import com.innovarhealthcare.launcher.JavaConfig;
import com.innovarhealthcare.launcher.ProcessLauncher;
import com.innovarhealthcare.launcher.SSLBypass;
import com.innovarhealthcare.launcher.interfaces.Progress;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldTreeCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class BridgeLinkLauncher
extends Application
implements Progress {
    private static final boolean DEVELOP = false;
    private static final String VERSION = "1.1.0";
    private Image ICON_DEFAULT;
    private final ObservableList<Connection> connectionsList = FXCollections.observableArrayList();
    private TreeView<Connection> connectionsTreeView;
    private SelectionModel<TreeItem<Connection>> treeSelectionModel;
    private TextField filterField;
    private TextField groupTextField;
    private TextField addressTextField;
    private TextField usernameTextField;
    private PasswordField passwordField;
    private Button launchButton;
    private ComboBox<BundledJava> bundledJavaCombo;
    private ComboBox<HeapMemory> heapSizeCombo;
    private TextField jvmOptionsTextField;
    private CheckBox showConsoleCheckBox;
    private Text progressText;
    private ProgressBar progressBar;
    private ProgressIndicator progressIndicator;
    private Button cancelButton;
    private CheckBox closeWindowCheckBox;
    private Button newButton;
    private Button saveButton;
    private Button duplicateButton;
    private Button deleteButton;
    private Button importButton;
    private Button exportButton;
    private Thread launchThread;
    private volatile DownloadJNLP currentDownload;
    private volatile boolean isLaunching = false;
    private Stage primaryStage;
    private String appDir;
    private File dataFolder;
    private File cacheFolder;

    public void start(Stage stage) {
        TreeItem firstGroup;
        this.primaryStage = stage;
        this.ICON_DEFAULT = new Image("/images/logo.png");
        stage.setTitle("BridgeLink Administrator Launcher (1.1.0)");
        try {
            stage.getIcons().add((Object)this.ICON_DEFAULT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializeDirectories();
        VBox root = new VBox(15.0);
        root.setPadding(new Insets(15.0));
        VBox connectionsSection = new VBox(20.0);
        connectionsSection.setPadding(new Insets(10.0));
        connectionsSection.setAlignment(Pos.TOP_CENTER);
        HBox tableButtons = new HBox(10.0);
        this.filterField = new TextField();
        this.filterField.setPromptText("Filter connections...");
        this.filterField.setPrefWidth(200.0);
        this.filterField.setMinWidth(200.0);
        this.filterField.setMaxWidth(200.0);
        this.filterField.textProperty().addListener((obs, oldVal, newVal) -> this.updateTreeViewWithFilter((String)newVal));
        this.newButton = new Button("New");
        this.newButton.setOnAction(e -> this.createNewConnection());
        this.saveButton = new Button("Save");
        this.saveButton.setOnAction(e -> this.saveCurrentConnection());
        this.duplicateButton = new Button("Duplicate");
        this.duplicateButton.setOnAction(e -> this.duplicateConnection());
        this.deleteButton = new Button("Delete");
        this.deleteButton.setDisable(true);
        this.deleteButton.setOnAction(e -> this.deleteCurrentConnection());
        tableButtons.getChildren().addAll((Object[])new Node[]{this.filterField, this.newButton, this.saveButton, this.duplicateButton, this.deleteButton});
        tableButtons.setAlignment(Pos.CENTER_LEFT);
        this.connectionsTreeView = new TreeView();
        this.connectionsTreeView.setEditable(true);
        VBox.setVgrow(this.connectionsTreeView, (Priority)Priority.ALWAYS);
        this.connectionsTreeView.setCellFactory(treeView -> {
            TextFieldTreeCell<Connection> cell = new TextFieldTreeCell<Connection>((StringConverter)new StringConverter<Connection>(){

                public String toString(Connection conn) {
                    if (conn == null) {
                        return "";
                    }
                    if (conn.getAddress() != null) {
                        return conn.getName() != null ? conn.getName() : "";
                    }
                    return conn.getGroup() != null ? conn.getGroup() : "Ungrouped";
                }

                public Connection fromString(String string) {
                    TreeItem item = (TreeItem)BridgeLinkLauncher.this.connectionsTreeView.getSelectionModel().getSelectedItem();
                    if (item != null && item.getValue() != null && ((Connection)item.getValue()).getAddress() != null) {
                        Connection conn = (Connection)item.getValue();
                        conn.setName(string);
                        return conn;
                    }
                    return null;
                }
            }){

                public void updateItem(Connection item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item != null && item.getIcon() != null && !item.getIcon().trim().isEmpty()) {
                        File icon = new File(new File(BridgeLinkLauncher.this.dataFolder, "icons"), ((Connection)this.getItem()).getIcon());
                        if (icon.exists()) {
                            ImageView value = new ImageView(new Image(icon.toURI().toString()));
                            value.setPreserveRatio(true);
                            value.setFitHeight(15.0);
                            this.setGraphic((Node)value);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                }
            };
            cell.setOnMouseClicked(arg_0 -> BridgeLinkLauncher.lambda$null$5((TreeCell)cell, arg_0));
            return cell;
        });
        this.connectionsTreeView.setOnEditCommit(event -> {
            Connection conn = (Connection)event.getNewValue();
            if (conn != null && conn.getAddress() != null) {
                String newName = StringUtils.trim(conn.getName());
                boolean exists = this.connectionsList.stream().anyMatch(c -> !StringUtils.equals(c.getId(), conn.getId()) && StringUtils.equalsIgnoreCase(c.getName(), newName));
                if (!exists) {
                    conn.setName(newName);
                    this.saveConnections();
                }
                this.updateTreeView();
            }
        });
        this.connectionsList.addAll(this.loadConnections());
        TreeItem rootTree = new TreeItem(null);
        rootTree.setExpanded(true);
        this.connectionsTreeView.setRoot(rootTree);
        this.connectionsTreeView.setShowRoot(false);
        this.updateTreeView();
        this.treeSelectionModel = this.connectionsTreeView.getSelectionModel();
        this.treeSelectionModel.selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            boolean isConnection;
            Connection selectedConn = newVal != null ? (Connection)newVal.getValue() : null;
            boolean bl = isConnection = selectedConn != null && selectedConn.getAddress() != null;
            if (isConnection) {
                this.updateUIFromConnection(selectedConn);
            } else {
                this.groupTextField.setText("");
                this.addressTextField.setText("");
                this.usernameTextField.setText("");
                this.passwordField.setText("");
                this.showConsoleCheckBox.setSelected(false);
                this.bundledJavaCombo.getSelectionModel().select(0);
                this.heapSizeCombo.getSelectionModel().select(1);
                this.jvmOptionsTextField.setText("");
            }
            this.saveButton.setDisable(true);
            this.duplicateButton.setDisable(!isConnection);
            this.deleteButton.setDisable(!isConnection);
            this.launchButton.setDisable(!isConnection);
            this.groupTextField.setDisable(!isConnection);
            this.addressTextField.setDisable(!isConnection);
            this.usernameTextField.setDisable(!isConnection);
            this.passwordField.setDisable(!isConnection);
            this.bundledJavaCombo.setDisable(!isConnection);
            this.heapSizeCombo.setDisable(!isConnection);
            this.jvmOptionsTextField.setDisable(!isConnection);
            this.showConsoleCheckBox.setDisable(!isConnection);
            this.exportButton.setDisable(this.connectionsList.isEmpty());
        });
        VBox rightButtons = new VBox(10.0);
        this.importButton = new Button("Import");
        this.importButton.setOnAction(e -> this.importConnections());
        this.exportButton = new Button("Export");
        this.exportButton.setOnAction(e -> this.exportConnections());
        this.exportButton.setDisable(true);
        rightButtons.getChildren().addAll((Object[])new Node[]{this.importButton, this.exportButton});
        rightButtons.setAlignment(Pos.TOP_CENTER);
        HBox tableArea = new HBox(10.0);
        tableArea.getChildren().addAll((Object[])new Node[]{this.connectionsTreeView, rightButtons});
        HBox.setHgrow(this.connectionsTreeView, (Priority)Priority.ALWAYS);
        connectionsSection.getChildren().addAll((Object[])new Node[]{tableButtons, tableArea});
        VBox configBox = new VBox(10.0);
        HBox groupRow = new HBox(10.0);
        Label groupLabel = new Label("Group:");
        this.groupTextField = new TextField();
        this.groupTextField.textProperty().addListener((obs, oldVal, newVal) -> this.updateSaveButtonState());
        groupRow.getChildren().addAll((Object[])new Node[]{groupLabel, this.groupTextField});
        HBox.setHgrow((Node)this.groupTextField, (Priority)Priority.ALWAYS);
        HBox addressRow = new HBox(10.0);
        Label addressLabel = new Label("Address:");
        this.addressTextField = new TextField("https://localhost:8443");
        this.addressTextField.textProperty().addListener((obs, oldVal, newVal) -> this.updateSaveButtonState());
        addressRow.getChildren().addAll((Object[])new Node[]{addressLabel, this.addressTextField});
        HBox.setHgrow((Node)this.addressTextField, (Priority)Priority.ALWAYS);
        HBox credentialsRow = new HBox(10.0);
        Label usernameLabel = new Label("Username:");
        this.usernameTextField = new TextField();
        this.usernameTextField.textProperty().addListener((obs, oldVal, newVal) -> this.updateSaveButtonState());
        Label passwordLabel = new Label("Password:");
        this.passwordField = new PasswordField();
        this.passwordField.textProperty().addListener((obs, oldVal, newVal) -> this.updateSaveButtonState());
        credentialsRow.getChildren().addAll((Object[])new Node[]{usernameLabel, this.usernameTextField, passwordLabel, this.passwordField});
        HBox.setHgrow((Node)this.usernameTextField, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.passwordField, (Priority)Priority.ALWAYS);
        HBox javaHeapRow = new HBox(10.0);
        Label javaHomeLabel = new Label("Java Home:");
        this.bundledJavaCombo = new ComboBox(FXCollections.observableArrayList((Object[])new BundledJava[]{new BundledJava("", "Java 17"), new BundledJava("", "Java 8")}));
        this.bundledJavaCombo.getSelectionModel().select(0);
        this.bundledJavaCombo.setOnAction(e -> this.updateSaveButtonState());
        Label heapSizeLabel = new Label("Max Heap Size:");
        this.heapSizeCombo = new ComboBox(FXCollections.observableArrayList((Object[])new HeapMemory[]{new HeapMemory("256m", "256 MB"), new HeapMemory("512m", "512 MB"), new HeapMemory("1g", "1 GB"), new HeapMemory("2g", "2 GB"), new HeapMemory("4g", "4 GB")}));
        this.heapSizeCombo.getSelectionModel().select(1);
        this.heapSizeCombo.setOnAction(e -> this.updateSaveButtonState());
        javaHeapRow.getChildren().addAll((Object[])new Node[]{javaHomeLabel, this.bundledJavaCombo, heapSizeLabel, this.heapSizeCombo});
        HBox.setHgrow(this.bundledJavaCombo, (Priority)Priority.ALWAYS);
        HBox.setHgrow(this.heapSizeCombo, (Priority)Priority.ALWAYS);
        HBox jvmOptionsRow = new HBox(10.0);
        Label jvmOptionsLabel = new Label("JVM Options:");
        this.jvmOptionsTextField = new TextField("");
        this.jvmOptionsTextField.textProperty().addListener((obs, oldVal, newVal) -> this.updateSaveButtonState());
        jvmOptionsRow.getChildren().addAll((Object[])new Node[]{jvmOptionsLabel, this.jvmOptionsTextField});
        HBox.setHgrow((Node)this.jvmOptionsTextField, (Priority)Priority.ALWAYS);
        HBox consoleRow = new HBox(10.0);
        Label consoleLabel = new Label("Show Java Console:");
        this.showConsoleCheckBox = new CheckBox();
        this.showConsoleCheckBox.setSelected(false);
        this.showConsoleCheckBox.setOnAction(e -> this.updateSaveButtonState());
        consoleRow.getChildren().addAll((Object[])new Node[]{consoleLabel, this.showConsoleCheckBox});
        configBox.getChildren().addAll((Object[])new Node[]{groupRow, addressRow, credentialsRow, javaHeapRow, jvmOptionsRow, consoleRow});
        Separator separator = new Separator();
        this.progressBar = new ProgressBar(0.0);
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        this.launchButton = new Button("Launch");
        this.launchButton.setOnAction(e -> this.launch());
        this.cancelButton = new Button("Cancel");
        this.cancelButton.setOnAction(e -> this.cancelLaunch());
        this.cancelButton.setVisible(false);
        StackPane buttonStack = new StackPane(new Node[]{this.launchButton, this.cancelButton});
        buttonStack.setAlignment(Pos.CENTER);
        HBox progressBarBox = new HBox(10.0, new Node[]{this.progressBar, buttonStack});
        HBox.setHgrow((Node)this.progressBar, (Priority)Priority.ALWAYS);
        this.progressIndicator = new ProgressIndicator(-1.0);
        this.progressIndicator.setPrefHeight(20.0);
        this.progressText = new Text("Requesting main JNLP...");
        VBox progressBox = new VBox(10.0, new Node[]{separator, progressBarBox, this.progressIndicator, this.progressText});
        this.setProgressControlsVisible(false);
        HBox bottomBox = new HBox(10.0);
        this.closeWindowCheckBox = new CheckBox("Close after launch");
        bottomBox.getChildren().add((Object)this.closeWindowCheckBox);
        bottomBox.setAlignment(Pos.CENTER_LEFT);
        root.getChildren().addAll((Object[])new Node[]{connectionsSection, configBox, progressBox, bottomBox});
        if (!this.connectionsList.isEmpty() && (firstGroup = (TreeItem)this.connectionsTreeView.getRoot().getChildren().get(0)) != null && !firstGroup.getChildren().isEmpty()) {
            this.treeSelectionModel.select(firstGroup.getChildren().get(0));
        }
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        stage.setScene(scene);
        stage.show();
        this.newButton.requestFocus();
        this.checkWritePermissions(stage);
    }

    private void initializeDirectories() {
        try {
            String jarPath = BridgeLinkLauncher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            this.appDir = new File(jarPath).getParent();
            this.appDir = URLDecoder.decode(this.appDir, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            this.appDir = System.getProperty("user.dir");
            System.err.println("Failed to determine application directory: " + e.getMessage());
        }
        if (!this.getParameters().getRaw().isEmpty()) {
            this.appDir = (String)this.getParameters().getRaw().get(0);
        }
        this.dataFolder = new File(this.appDir, "data");
        this.cacheFolder = new File(this.appDir, "cache");
    }

    private void checkWritePermissions(Stage stage) {
        File tempFile;
        StringBuilder errorMessage = new StringBuilder();
        if (!this.dataFolder.exists()) {
            try {
                this.dataFolder.mkdirs();
            }
            catch (SecurityException e) {
                errorMessage.append("Cannot create 'data' folder in: ").append(this.appDir).append("\nError: ").append(e.getMessage()).append("\n");
            }
        }
        if (this.dataFolder.exists() && !this.dataFolder.isDirectory()) {
            errorMessage.append("'data' path exists but is not a directory: ").append(this.dataFolder.getAbsolutePath()).append("\n");
        } else if (this.dataFolder.exists()) {
            try {
                tempFile = File.createTempFile("test", ".tmp", this.dataFolder);
                tempFile.delete();
            }
            catch (IOException e) {
                errorMessage.append("No write permission in 'data' folder: ").append(this.dataFolder.getAbsolutePath()).append("\nError: ").append(e.getMessage()).append("\n");
            }
        }
        if (!this.cacheFolder.exists()) {
            try {
                this.cacheFolder.mkdirs();
            }
            catch (SecurityException e) {
                errorMessage.append("Cannot create 'cache' folder in: ").append(this.appDir).append("\nError: ").append(e.getMessage()).append("\n");
            }
        }
        if (this.cacheFolder.exists() && !this.cacheFolder.isDirectory()) {
            errorMessage.append("'cache' path exists but is not a directory: ").append(this.cacheFolder.getAbsolutePath()).append("\n");
        } else if (this.cacheFolder.exists()) {
            try {
                tempFile = File.createTempFile("test", ".tmp", this.cacheFolder);
                tempFile.delete();
            }
            catch (IOException e) {
                errorMessage.append("No write permission in 'cache' folder: ").append(this.cacheFolder.getAbsolutePath()).append("\nError: ").append(e.getMessage()).append("\n");
            }
        }
        if (errorMessage.length() > 0) {
            this.showWritePermissionAlert(stage, errorMessage.toString());
        }
    }

    private void showWritePermissionAlert(Stage stage, String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.initOwner((Window)stage);
        alert.setTitle("Write Permission Error");
        alert.setHeaderText("Cannot write to required folders");
        alert.setContentText(message + "\nSome features (e.g., saving connections or caching) may not work. Please ensure the 'data' and 'cache' folders are writable.");
        alert.showAndWait();
    }

    private void updateTreeView() {
        this.updateTreeViewWithFilter(this.filterField != null ? this.filterField.getText() : "");
    }

    private void updateTreeViewWithFilter(String filter) {
        TreeItem root = this.connectionsTreeView.getRoot();
        if (root == null) {
            root = new TreeItem(null);
            root.setExpanded(true);
            this.connectionsTreeView.setRoot(root);
            this.connectionsTreeView.setShowRoot(false);
        }
        root.getChildren().clear();
        HashMap<String, TreeItem> groupItems = new HashMap<String, TreeItem>();
        String filterLower = filter.toLowerCase().trim();
        for (Connection conn : this.connectionsList) {
            String name;
            String groupName = StringUtils.isBlank(conn.getGroup()) ? "Ungrouped" : conn.getGroup();
            String string = name = conn.getName() != null ? conn.getName() : "";
            if (!filterLower.isEmpty() && !name.toLowerCase().contains(filterLower) && !groupName.toLowerCase().contains(filterLower)) continue;
            TreeItem groupItem = groupItems.computeIfAbsent(groupName, k -> {
                Connection groupConn = new Connection(null, "", null, null, null, null, null, null, false, false, null, false, null, false, null, null, groupName, null, false);
                TreeItem item = new TreeItem((Object)groupConn);
                item.setExpanded(true);
                return item;
            });
            TreeItem connItem = new TreeItem((Object)conn);
            groupItem.getChildren().add((Object)connItem);
            if (root.getChildren().contains((Object)groupItem)) continue;
            root.getChildren().add((Object)groupItem);
        }
    }

    private void createNewConnection() {
        if (!this.isLaunching) {
            String newName = "New Connection";
            int counter = 1;
            while (this.nameExists(newName)) {
                newName = "New Connection " + counter++;
            }
            TextInputDialog dialog = new TextInputDialog(newName);
            dialog.setTitle("New Connection");
            dialog.setHeaderText("Enter connection name:");
            Stage dialogStage = (Stage)dialog.getDialogPane().getScene().getWindow();
            dialogStage.getIcons().add((Object)this.ICON_DEFAULT);
            dialog.showAndWait().ifPresent(name -> {
                TreeItem<Connection> newItem;
                this.addConnectionWithName((String)name);
                this.updateTreeView();
                Connection newConn = this.connectionsList.stream().filter(conn -> conn.getName().equals(name)).findFirst().orElse(null);
                if (newConn != null && (newItem = this.findTreeItem(newConn)) != null) {
                    this.treeSelectionModel.select(newItem);
                }
            });
        }
    }

    private void addConnectionWithName(String name) {
        if (StringUtils.isNotBlank(name)) {
            String finalName = name;
            int cnt = 1;
            while (this.nameExists(finalName)) {
                finalName = name + " Copy " + cnt++;
            }
            this.addConnection(finalName, "", "BUNDLED", "Java 17", "", "512m", "", false, "", false, "", false, "", "", "", "", false);
        }
    }

    private void saveCurrentConnection() {
        TreeItem selectedItem;
        if (!this.isLaunching && (selectedItem = (TreeItem)this.connectionsTreeView.getSelectionModel().getSelectedItem()) != null && ((Connection)selectedItem.getValue()).getAddress() != null) {
            Connection currentConnection = (Connection)selectedItem.getValue();
            this.updateConnectionFromUI(currentConnection);
            this.updateTreeView();
            this.connectionsTreeView.refresh();
            this.saveButton.setDisable(true);
            this.saveConnections();
            TreeItem<Connection> newSelectedItem = this.findTreeItem(currentConnection);
            if (newSelectedItem != null) {
                this.treeSelectionModel.select(newSelectedItem);
            }
        }
    }

    private void duplicateConnection() {
        if (!this.isLaunching) {
            TextInputDialog dialog = new TextInputDialog("New Connection");
            dialog.setTitle("Duplicate Connection");
            dialog.setHeaderText("Enter new connection name:");
            Stage dialogStage = (Stage)dialog.getDialogPane().getScene().getWindow();
            dialogStage.getIcons().add((Object)this.ICON_DEFAULT);
            dialog.showAndWait().ifPresent(name -> {
                if (StringUtils.isNotBlank(name)) {
                    String finalName = name;
                    int cnt = 1;
                    while (this.nameExists(finalName)) {
                        finalName = name + " Copy " + cnt++;
                    }
                    Connection newConn = new Connection(UUID.randomUUID().toString(), finalName, this.addressTextField.getText(), this.getJavaHome(), ((BundledJava)this.bundledJavaCombo.getValue()).toString(), "", ((HeapMemory)this.heapSizeCombo.getValue()).toString(), "", this.showConsoleCheckBox.isSelected(), false, "", false, "", false, this.usernameTextField.getText(), this.passwordField.getText(), this.groupTextField.getText(), this.jvmOptionsTextField.getText(), this.closeWindowCheckBox.isSelected());
                    this.connectionsList.add((Object)newConn);
                    this.updateTreeView();
                    this.saveConnections();
                    this.treeSelectionModel.select(this.findTreeItem(newConn));
                }
            });
        }
    }

    private void deleteCurrentConnection() {
        TreeItem selectedItem;
        if (!this.isLaunching && (selectedItem = (TreeItem)this.connectionsTreeView.getSelectionModel().getSelectedItem()) != null && ((Connection)selectedItem.getValue()).getAddress() != null) {
            Connection selected = (Connection)selectedItem.getValue();
            String originalGroup = StringUtils.isBlank(selected.getGroup()) ? "Ungrouped" : selected.getGroup();
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Delete Connection");
            alert.setHeaderText("Confirm deletion?");
            Stage dialogStage = (Stage)alert.getDialogPane().getScene().getWindow();
            dialogStage.getIcons().add((Object)this.ICON_DEFAULT);
            alert.showAndWait().ifPresent(response -> {
                if (response == ButtonType.OK) {
                    this.connectionsList.remove((Object)selected);
                    this.updateTreeView();
                    this.saveConnections();
                    if (!this.connectionsList.isEmpty()) {
                        TreeItem newGroupItem = null;
                        for (TreeItem groupItem : this.connectionsTreeView.getRoot().getChildren()) {
                            if (!StringUtils.equals(((Connection)groupItem.getValue()).getGroup(), originalGroup)) continue;
                            newGroupItem = groupItem;
                            break;
                        }
                        if (newGroupItem != null && !newGroupItem.getChildren().isEmpty()) {
                            this.treeSelectionModel.select(newGroupItem.getChildren().get(0));
                        } else if (!this.connectionsTreeView.getRoot().getChildren().isEmpty()) {
                            TreeItem firstGroup = (TreeItem)this.connectionsTreeView.getRoot().getChildren().get(0);
                            if (!firstGroup.getChildren().isEmpty()) {
                                this.treeSelectionModel.select(firstGroup.getChildren().get(0));
                            } else {
                                this.treeSelectionModel.clearSelection();
                            }
                        } else {
                            this.treeSelectionModel.clearSelection();
                        }
                    } else {
                        this.treeSelectionModel.clearSelection();
                    }
                }
            });
        }
    }

    private TreeItem<Connection> findTreeItem(Connection conn) {
        for (TreeItem groupItem : this.connectionsTreeView.getRoot().getChildren()) {
            for (TreeItem item : groupItem.getChildren()) {
                if (item.getValue() != conn) continue;
                return item;
            }
        }
        return null;
    }

    private void launch() {
        if (this.isLaunching || this.addressTextField.getText().isEmpty()) {
            return;
        }
        this.isLaunching = true;
        this.setUIEnabled(false);
        this.setProgressControlsVisible(true);
        this.progressText.setText("Launching " + this.addressTextField.getText());
        this.progressBar.setProgress(0.0);
        this.progressIndicator.setProgress(-1.0);
        this.cancelButton.setDisable(false);
        this.launchThread = new Thread(() -> {
            try {
                DownloadJNLP download;
                String host = this.addressTextField.getText();
                this.updateProgressText("Downloading JNLP from " + host);
                this.currentDownload = download = new DownloadJNLP(host, this.cacheFolder);
                JavaConfig javaConfig = new JavaConfig(((HeapMemory)this.heapSizeCombo.getValue()).toString(), ((BundledJava)this.bundledJavaCombo.getValue()).toString(), this.jvmOptionsTextField.getText());
                Credential credential = new Credential(StringUtils.trim(this.usernameTextField.getText()), StringUtils.trim(this.passwordField.getText()));
                CodeBase codeBase = download.handle(this);
                this.currentDownload = null;
                ProcessLauncher process = new ProcessLauncher();
                this.updateProgressText("Starting application...");
                process.launch(javaConfig, credential, codeBase, this.showConsoleCheckBox.isSelected());
                this.updateProgressText("Application launched successfully");
                Thread.sleep(1000L);
                Platform.runLater(() -> {
                    if (this.closeWindowCheckBox.isSelected()) {
                        this.primaryStage.close();
                    } else {
                        this.resetUI();
                    }
                });
            }
            catch (InterruptedException e) {
                Platform.runLater(() -> {
                    this.progressText.setText("Launch cancelled");
                    this.resetUI();
                });
            }
            catch (Exception e) {
                Platform.runLater(() -> {
                    this.showErrorDialog(e, "Launch Failed");
                    this.resetUI();
                });
            }
            finally {
                this.currentDownload = null;
            }
        }, "Launch Thread");
        this.launchThread.start();
    }

    private void cancelLaunch() {
        if (this.launchThread != null && this.launchThread.isAlive()) {
            Platform.runLater(() -> this.progressText.setText("Cancelling..."));
            this.launchThread.interrupt();
            if (this.currentDownload != null) {
                this.currentDownload.cancel();
            }
            try {
                this.launchThread.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void importConnections() {
        if (this.isLaunching) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import Connections");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("JSON Files", new String[]{"*.json"}));
        File file = fileChooser.showOpenDialog((Window)this.primaryStage);
        if (file != null) {
            try {
                String content = new String(Files.readAllBytes(file.toPath()));
                ObjectMapper objectMapper = new ObjectMapper();
                List<Connection> importedConnections = objectMapper.readValue(content, new TypeReference<List<Connection>>(){});
                for (Connection conn : importedConnections) {
                    String baseName;
                    String newName = baseName = conn.getName();
                    int counter = 1;
                    while (this.nameExists(newName)) {
                        newName = baseName + " (Imported " + counter++ + ")";
                    }
                    conn.setName(newName);
                    if (conn.getIcon() != null && !conn.getIcon().trim().isEmpty()) {
                        File sourceIcon = new File(new File(file.getParentFile(), "icons"), conn.getIcon());
                        if (sourceIcon.exists()) {
                            File iconFolder = new File(this.dataFolder, "icons");
                            iconFolder.mkdirs();
                            File targetIcon = new File(iconFolder, conn.getIcon());
                            Files.copy(sourceIcon.toPath(), targetIcon.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        } else {
                            conn.setIcon("");
                        }
                    }
                    conn.setId(UUID.randomUUID().toString());
                    this.connectionsList.add((Object)conn);
                }
                this.updateTreeView();
                this.saveConnections();
            }
            catch (IOException e) {
                this.showAlert("Failed to import connections: " + e.getMessage());
            }
        }
    }

    private void exportConnections() {
        if (this.isLaunching || this.connectionsList.isEmpty()) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export All Connections");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("JSON Files", new String[]{"*.json"}));
        fileChooser.setInitialFileName("all_connections.json");
        File file = fileChooser.showSaveDialog((Window)this.primaryStage);
        if (file != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.writeValue(file, this.connectionsList);
            }
            catch (IOException e) {
                this.showAlert("Failed to export connections: " + e.getMessage());
            }
        }
    }

    private void setUIEnabled(boolean enabled) {
        TreeItem selectedItem = (TreeItem)this.connectionsTreeView.getSelectionModel().getSelectedItem();
        boolean isConnectionSelected = selectedItem != null && selectedItem.getValue() != null && ((Connection)selectedItem.getValue()).getAddress() != null;
        boolean finalEnabled = enabled && isConnectionSelected;
        this.groupTextField.setDisable(!finalEnabled);
        this.addressTextField.setDisable(!finalEnabled);
        this.usernameTextField.setDisable(!finalEnabled);
        this.passwordField.setDisable(!finalEnabled);
        this.bundledJavaCombo.setDisable(!finalEnabled);
        this.heapSizeCombo.setDisable(!finalEnabled);
        this.jvmOptionsTextField.setDisable(!finalEnabled);
        this.showConsoleCheckBox.setDisable(!finalEnabled);
        this.saveButton.setDisable(!finalEnabled);
        this.duplicateButton.setDisable(!finalEnabled);
        this.deleteButton.setDisable(!finalEnabled);
        this.launchButton.setDisable(!finalEnabled);
        boolean launchEnabled = enabled;
        this.closeWindowCheckBox.setDisable(!launchEnabled);
        this.newButton.setDisable(!launchEnabled);
        this.importButton.setDisable(!launchEnabled);
        this.exportButton.setDisable(!launchEnabled || this.connectionsList.isEmpty());
        this.connectionsTreeView.setDisable(!launchEnabled);
    }

    private void resetUI() {
        this.progressBar.setProgress(0.0);
        this.progressIndicator.setProgress(-1.0);
        this.progressText.setText("");
        this.setUIEnabled(true);
        this.setProgressControlsVisible(false);
        this.isLaunching = false;
        this.updateSaveButtonState();
    }

    private void setProgressControlsVisible(boolean visible) {
        this.progressBar.setVisible(visible);
        this.progressIndicator.setVisible(visible);
        this.progressText.setVisible(visible);
        this.launchButton.setVisible(!visible);
        this.cancelButton.setVisible(visible);
    }

    private boolean nameExists(String name) {
        return this.connectionsList.stream().anyMatch(conn -> StringUtils.equalsIgnoreCase(name, conn.getName()));
    }

    private String getJavaHome() {
        return "BUNDLED";
    }

    private List<Connection> loadConnections() {
        List<Connection> connections = new ArrayList<Connection>();
        File connectionsFile = new File(this.dataFolder, "connections.json");
        if (connectionsFile.exists()) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                connections = objectMapper.readValue(connectionsFile, new TypeReference<List<Connection>>(){});
            }
            catch (IOException e) {
                this.showAlert("Unable to load connections from file: " + connectionsFile.getAbsolutePath() + ". Error: " + e.getMessage());
            }
        }
        return connections;
    }

    private void saveConnections() {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        File connectionsFile = new File(this.dataFolder, "connections.json");
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.writeValue(connectionsFile, this.connectionsList);
        }
        catch (IOException e) {
            this.showAlert(e.getMessage());
        }
    }

    private void addConnection(String name, String address, String javaHome, String javaHomeBundledValue, String javaFxHome, String heapSize, String icon, boolean showJavaConsole, String sslProtocols, boolean sslProtocolsCustom, String sslCipherSuites, boolean useLegacyDHSettings, String username, String password, String group, String jvmOptions, boolean closeWindow) {
        Connection conn = new Connection(UUID.randomUUID().toString(), name, address, javaHome, javaHomeBundledValue, javaFxHome, heapSize, icon, showJavaConsole, sslProtocolsCustom, sslProtocols, false, sslCipherSuites, useLegacyDHSettings, username, password, group, jvmOptions, closeWindow);
        this.connectionsList.add((Object)conn);
        this.updateTreeView();
        this.saveConnections();
        this.treeSelectionModel.select(this.findTreeItem(conn));
        this.saveButton.setDisable(true);
    }

    private void updateUIFromConnection(Connection conn) {
        this.groupTextField.setText(conn.getGroup() != null ? conn.getGroup() : "");
        this.addressTextField.setText(conn.getAddress());
        this.usernameTextField.setText(conn.getUsername());
        this.passwordField.setText(conn.getPassword());
        this.showConsoleCheckBox.setSelected(conn.isShowJavaConsole());
        String javaHomeBundledValue = conn.getJavaHomeBundledValue();
        for (BundledJava e : this.bundledJavaCombo.getItems()) {
            if (!StringUtils.equalsIgnoreCase(e.getVersion(), javaHomeBundledValue)) continue;
            this.bundledJavaCombo.getSelectionModel().select((Object)e);
            break;
        }
        String heapSize = conn.getHeapSize();
        for (HeapMemory e : this.heapSizeCombo.getItems()) {
            if (!StringUtils.equalsIgnoreCase(e.getValue(), heapSize)) continue;
            this.heapSizeCombo.getSelectionModel().select((Object)e);
            break;
        }
        this.jvmOptionsTextField.setText(conn.getJvmOptions());
        this.closeWindowCheckBox.setSelected(conn.isCloseWindow());
    }

    private void updateConnectionFromUI(Connection conn) {
        conn.setGroup(this.groupTextField.getText());
        conn.setAddress(this.addressTextField.getText());
        conn.setUsername(this.usernameTextField.getText());
        conn.setPassword(this.passwordField.getText());
        conn.setJavaHome(this.getJavaHome());
        conn.setJavaHomeBundledValue(((BundledJava)this.bundledJavaCombo.getValue()).toString());
        conn.setJavaFxHome("");
        conn.setHeapSize(((HeapMemory)this.heapSizeCombo.getValue()).toString());
        conn.setJvmOptions(this.jvmOptionsTextField.getText());
        if (conn.getIcon() == null) {
            conn.setIcon("");
        }
        conn.setShowJavaConsole(this.showConsoleCheckBox.isSelected());
        conn.setSslProtocolsCustom(false);
        conn.setSslProtocols("");
        conn.setSslCipherSuitesCustom(false);
        conn.setSslCipherSuites("");
        conn.setUseLegacyDHSettings(false);
        conn.setCloseWindow(this.closeWindowCheckBox.isSelected());
    }

    private void updateSaveButtonState() {
        if (this.isLaunching) {
            this.saveButton.setDisable(true);
            return;
        }
        TreeItem selectedItem = (TreeItem)this.connectionsTreeView.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            this.saveButton.setDisable(true);
            return;
        }
        Connection selected = (Connection)selectedItem.getValue();
        if (selected == null) {
            this.saveButton.setDisable(true);
            return;
        }
        boolean unchanged = StringUtils.equals(selected.getGroup(), this.groupTextField.getText()) && StringUtils.equals(selected.getAddress(), this.addressTextField.getText()) && StringUtils.equals(selected.getUsername(), this.usernameTextField.getText()) && StringUtils.equals(selected.getPassword(), this.passwordField.getText()) && StringUtils.equals(selected.getJavaHome(), this.getJavaHome()) && StringUtils.equals(selected.getJavaHomeBundledValue(), ((BundledJava)this.bundledJavaCombo.getValue()).toString()) && StringUtils.equals(selected.getHeapSize(), ((HeapMemory)this.heapSizeCombo.getValue()).toString()) && StringUtils.equals(selected.getJvmOptions(), this.jvmOptionsTextField.getText()) && selected.isShowJavaConsole() == this.showConsoleCheckBox.isSelected() && selected.isCloseWindow() == this.closeWindowCheckBox.isSelected();
        this.saveButton.setDisable(unchanged);
    }

    public void showAlert(String err) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText(err);
        alert.initOwner((Window)this.primaryStage);
        alert.showAndWait();
    }

    private void showErrorDialog(Throwable t, String header) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText(header);
        alert.setResizable(true);
        alert.setHeight(550.0);
        alert.setWidth(550.0);
        TextArea textArea = new TextArea(ExceptionUtils.getStackTrace(t));
        textArea.setEditable(false);
        alert.getDialogPane().setContent((Node)textArea);
        alert.initOwner((Window)this.primaryStage);
        alert.show();
    }

    @Override
    public void updateProgressBar(double progress) {
        Platform.runLater(() -> this.progressBar.setProgress(progress));
    }

    @Override
    public void updateProgressText(String message) {
        Platform.runLater(() -> this.progressText.setText(message));
    }

    public static void main(String[] args) {
        SSLBypass.disableSSLVerification();
        BridgeLinkLauncher.launch((String[])args);
    }

    private static /* synthetic */ void lambda$null$5(TreeCell cell, MouseEvent event) {
        Connection conn;
        if (event.getClickCount() == 2 && !cell.isEmpty() && (conn = (Connection)cell.getItem()) != null && conn.getAddress() != null) {
            cell.startEdit();
        }
    }
}

