/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import com.innovarhealthcare.launcher.CodeBase;
import com.innovarhealthcare.launcher.ExtensionInfo;
import com.innovarhealthcare.launcher.interfaces.Progress;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DownloadJNLP {
    private static final String LOG_FILE = "launcher-debug.log";
    private static final boolean DEBUG = false;
    private final File cacheFolder;
    private String host = "";
    private volatile boolean cancelled = false;

    public DownloadJNLP(String host, File cacheFolder) {
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        this.host = host;
        this.cacheFolder = cacheFolder;
    }

    public CodeBase handle(Progress progress) throws Exception {
        progress.updateProgressText("Requesting main JNLP...");
        this.checkCancelled("handle start");
        String jnlpUrl = this.host + "/webstart.jnlp";
        this.log("\ud83d\udd0d Fetching main JNLP from: " + jnlpUrl);
        List<Object> localJars = new ArrayList();
        String bridgeVersion = "unknown";
        try {
            URL url = new URL(jnlpUrl);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document doc = documentBuilder.parse(url.openStream());
            ArrayList<String> coreJars = new ArrayList<String>();
            NodeList jarList = doc.getElementsByTagName("jar");
            for (int i = 0; i < jarList.getLength(); ++i) {
                this.checkCancelled("core JAR extraction");
                Element jarElement = (Element)jarList.item(i);
                coreJars.add(jarElement.getAttribute("href"));
            }
            NodeList versionNodes = doc.getElementsByTagName("title");
            if (versionNodes.getLength() > 0) {
                bridgeVersion = versionNodes.item(0).getTextContent().replaceAll("[^0-9.]", "");
            }
            bridgeVersion = doc.getDocumentElement().getAttribute("version");
            this.log("\u2705 Detected BridgeLink Version: " + bridgeVersion);
            progress.updateProgressText("Requesting JNLP for extensions...");
            this.checkCancelled("extension JNLP extraction");
            NodeList extensionNodes = doc.getElementsByTagName("extension");
            ArrayList<String> extensionJnlpUrls = new ArrayList<String>();
            String baseUrl = jnlpUrl.replace("webstart.jnlp", "");
            for (int i = 0; i < extensionNodes.getLength(); ++i) {
                Element extElement = (Element)extensionNodes.item(i);
                String extJnlpPath = extElement.getAttribute("href");
                String extJnlpUrl = baseUrl + extJnlpPath;
                extensionJnlpUrls.add(extJnlpUrl);
            }
            this.log("\u2705 Found extension JNLPs: " + extensionJnlpUrls);
            ArrayList<ExtensionInfo> listExtensions = new ArrayList<ExtensionInfo>();
            for (String extJnlpUrl : extensionJnlpUrls) {
                this.checkCancelled("parseExtensionJnlp");
                listExtensions.add(this.parseExtensionJnlp(extJnlpUrl));
            }
            localJars = this.download(jnlpUrl, coreJars, bridgeVersion, listExtensions, progress);
        }
        catch (Exception e) {
            this.log("\u274c ERROR in handle(): " + e.getMessage());
            throw e;
        }
        ArrayList<String> classpath = new ArrayList<String>();
        for (File file : localJars) {
            classpath.add(file.getAbsolutePath());
        }
        return new CodeBase(classpath, "com.mirth.connect.client.ui.Mirth", this.host, bridgeVersion);
    }

    private ExtensionInfo parseExtensionJnlp(String extJnlpUrl) {
        this.log("\ud83d\udd0d Fetching Extension JNLP: " + extJnlpUrl);
        try {
            URL url = new URL(extJnlpUrl);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(url.openStream());
            String extensionName = new File(new URL(extJnlpUrl).getPath()).getName().replace(".jnlp", "");
            HashMap<String, String> mapJars = new HashMap<String, String>();
            NodeList jarList = doc.getElementsByTagName("jar");
            for (int i = 0; i < jarList.getLength(); ++i) {
                Element jarElement = (Element)jarList.item(i);
                String jarPath = jarElement.getAttribute("href");
                String jarUrl = this.host + "/webstart/extensions/" + jarPath;
                mapJars.put(jarUrl, new File(jarPath).getName());
            }
            this.log("\u2705 Extension JARs for " + extensionName + ": " + ((Object)mapJars).toString());
            return new ExtensionInfo(extensionName, mapJars);
        }
        catch (Exception e) {
            this.log("\u274c ERROR fetching extension JNLP: " + e.getMessage());
            return new ExtensionInfo();
        }
    }

    private List<File> download(String jnlpUrl, List<String> coreJars, String bridgeVersion, List<ExtensionInfo> listExtensions, Progress progress) throws Exception {
        this.log("\ud83d\ude80 Starting download process for BridgeLink version: " + bridgeVersion);
        this.checkCancelled("download start");
        String baseUrl = jnlpUrl.substring(0, jnlpUrl.indexOf("/webstart") + 9);
        String path = bridgeVersion + "/core";
        File coreFolder = new File(this.cacheFolder, path);
        if (!coreFolder.exists()) {
            coreFolder.mkdirs();
        }
        ArrayList<File> localJars = new ArrayList<File>();
        int numOfJars = coreJars.size() + listExtensions.size();
        int cntNum = 0;
        for (String string : coreJars) {
            this.checkCancelled("core JAR download");
            String correctedJarUrl = baseUrl + "/client-lib/" + new File(string).getName();
            File localFile = new File(coreFolder, new File(string).getName());
            progress.updateProgressText("Downloading Core JAR " + string + "...");
            this.log("\u2b07\ufe0f Downloading Core JAR: " + correctedJarUrl);
            ++cntNum;
            if (!this.downloadFile(correctedJarUrl, localFile, null)) {
                this.log("\u274c WARNING: Failed to download core JAR: " + correctedJarUrl);
                continue;
            }
            localJars.add(localFile);
            progress.updateProgressBar((double)cntNum / (double)numOfJars);
        }
        for (ExtensionInfo extensionInfo : listExtensions) {
            this.checkCancelled("extension JAR download");
            String extensionName = extensionInfo.getName();
            String extPath = bridgeVersion + "/extensions/" + extensionName;
            File extensionFolder = new File(this.cacheFolder, extPath);
            if (!extensionFolder.exists()) {
                extensionFolder.mkdirs();
            }
            Map<String, String> mapJars = extensionInfo.getMapJars();
            ++cntNum;
            if (mapJars == null) {
                this.log("\u274c WARNING: Failed to download Extension JAR: mapJars is null - extensionName: " + extensionName);
                continue;
            }
            for (Map.Entry<String, String> entry : mapJars.entrySet()) {
                this.checkCancelled("extension JAR download loop");
                String jarUrl = entry.getKey();
                String jarName = entry.getValue();
                File localFile = new File(extensionFolder, jarName);
                progress.updateProgressText("Downloading JARs for extension " + jarName + "...");
                this.log("\u2b07\ufe0f Downloading Extension JAR: " + jarUrl + " -> " + localFile.getAbsolutePath());
                if (!this.downloadFile(jarUrl, localFile, null)) {
                    this.log("\u274c WARNING: Missing extension JAR: " + jarUrl);
                    continue;
                }
                localJars.add(localFile);
            }
            progress.updateProgressBar((double)cntNum / (double)numOfJars);
        }
        return localJars;
    }

    private boolean downloadFile(String urlStr, File destination, String expectedSha256) throws InterruptedException {
        if (Thread.interrupted() || this.cancelled) {
            throw new InterruptedException("Download cancelled");
        }
        try {
            String actualSha256;
            String actualSha2562;
            if (destination.exists() && expectedSha256 != null && expectedSha256.equalsIgnoreCase(actualSha2562 = this.calculateSha256(destination))) {
                this.log("\u2705 Skipping already downloaded file: " + destination.getName());
                return true;
            }
            this.log("\u2b07\ufe0f Downloading: " + urlStr);
            URL url = new URL(urlStr);
            try (InputStream in = url.openStream();
                 FileOutputStream out = new FileOutputStream(destination);){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            if (expectedSha256 != null && !expectedSha256.equalsIgnoreCase(actualSha256 = this.calculateSha256(destination))) {
                this.log("\u274c ERROR: SHA-256 mismatch for " + destination.getName());
                destination.delete();
                return false;
            }
            this.log("\u2705 Saved: " + destination.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            this.log("\u274c ERROR downloading file: " + urlStr + " - " + e.getMessage());
            return false;
        }
    }

    private String calculateSha256(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);
             DigestInputStream dis = new DigestInputStream(fis, digest);){
            byte[] buffer = new byte[4096];
            while (dis.read(buffer) != -1) {
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hashBytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    private void log(String message) {
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void checkCancelled(String context) throws InterruptedException {
        if (Thread.interrupted() || this.cancelled) {
            this.log("\ud83d\udeab Cancelled at: " + context);
            throw new InterruptedException("Download cancelled");
        }
    }
}

