/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.JDKAccessor;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;

public class JDKAccessFactory {
    private static JDKAccessor jdkAccessor;

    public static synchronized JDKAccessor getAccessor(Instrumentation instrumentation, Supplier<String> supplier) throws IOException, UnsupportedOperationException {
        if (jdkAccessor != null) {
            return jdkAccessor;
        }
        if (System.getProperty("java.version").startsWith("1.")) {
            return JDKAccessFactory.getAccessor();
        }
        try {
            Method method = Class.class.getDeclaredMethod("getModule", new Class[0]);
            Object object = method.invoke(Object.class, new Object[0]);
            Class<?> clazz = Class.forName("java.lang.Module");
            boolean bl = (Boolean)Instrumentation.class.getDeclaredMethod("isModifiableModule", clazz).invoke((Object)instrumentation, object);
            if (!bl) {
                throw new UnsupportedOperationException("java.base is not modifiable");
            }
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(supplier.get()));
            JDKAccessor jDKAccessor = new JDKAccessor();
            if (jDKAccessor.getClass().getClassLoader() != null) {
                throw new UnsupportedOperationException("no access to bootstrap class loader");
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(method.invoke(JDKAccessor.class, new Object[0]));
            HashMap<String, HashSet<Object>> hashMap = new HashMap<String, HashSet<Object>>();
            for (String string : new String[]{"java.lang", "java.net", "java.nio", "java.util", "java.util.zip", "jdk.internal.loader", "jdk.internal.access", "jdk.internal.misc", "sun.net.dns", "sun.net.www.http", "sun.net.www.protocol.http", "sun.net.www.protocol.https"}) {
                if (Package.getPackage(string) == null) continue;
                hashMap.put(string, hashSet);
            }
            Instrumentation.class.getDeclaredMethod("redefineModule", clazz, Set.class, Map.class, Map.class, Set.class, Map.class).invoke((Object)instrumentation, object, new HashSet(), new HashMap(), hashMap, new HashSet(), new HashMap());
            jdkAccessor = jDKAccessor;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        return jdkAccessor;
    }

    public static synchronized JDKAccessor getAccessor() {
        if (jdkAccessor != null) {
            return jdkAccessor;
        }
        jdkAccessor = new JDKAccessor();
        return jdkAccessor;
    }
}

