/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.eventconsumer;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Utils;
import com.azul.crs.client.Version;
import com.azul.crs.client.eventconsumer.VmEventConsumer;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.models.VMInstance;
import com.azul.crs.client.service.DataWriter;
import com.azul.crs.client.service.EventService;
import com.azul.crs.client.service.UploadService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PostVmData
implements VmEventConsumer {
    private final String revision;
    private final String version;
    private final String owner;
    private final EventService eventService;
    private final UploadService uploadService;
    private final AtomicInteger nextArtifactId = new AtomicInteger();

    public PostVmData(Client client) {
        Version version = new Version();
        this.revision = version.clientRevision();
        this.version = version.clientVersion();
        this.owner = client.getConnectionManager().getMailbox();
        this.eventService = client.getEventService();
        this.uploadService = client.getUploadService();
    }

    @Override
    public void consumeVMStart(Map<String, Object> map, long l) {
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_CREATE).eventPayload(new VMInstance().agentVersion(this.version).agentRevision(this.revision).owner(this.owner).inventory(map).startTime(l)));
        this.eventService.sync();
    }

    @Override
    public void patchInventory(Map<String, Object> map) {
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_PATCH).eventPayload(new VMInstance().inventory(map)));
    }

    @Override
    public void consumeVMEvent(VMEvent vMEvent) {
        this.eventService.add(vMEvent.randomEventId());
    }

    @Override
    public void consumeVMShutdown(Collection<VMEvent> collection) {
        this.eventService.addAll(collection);
        this.eventService.add(new VMEvent().randomEventId().eventType(VMEvent.Type.VM_SHUTDOWN).eventTime(Utils.currentTimeMillis()));
    }

    @Override
    public int createArtifactId() {
        return this.nextArtifactId.incrementAndGet();
    }

    @Override
    public void consumeVMArtifactCreate(VMArtifact.Type type, int n, Map<String, Object> map) {
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_CREATE).eventPayload(new VMArtifact().artifactType(type).artifactId(this.artifactIdToString(n)).metadata(map)));
    }

    @Override
    public void consumeVMArtifactData(Integer n, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("artifactId", this.artifactIdToString(n));
        hashMap.put("data", string);
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_DATA).eventPayload(hashMap));
        PerformanceMetrics.logArtifactBytes(string.length());
    }

    @Override
    public void consumeVMArtifact(VMArtifact.Type type, int n, Map<String, Object> map, DataWriter dataWriter) {
        this.consumeVMArtifactCreate(type, n, map);
        this.consumeVMArtifactChunk(type, Collections.singleton(n), Collections.emptyMap(), dataWriter);
    }

    @Override
    public String artifactIdToString(int n) {
        return Integer.toString(n, 36);
    }

    @Override
    public void consumeVMArtifactChunk(VMArtifact.Type type, Set<Integer> set, Map<String, Object> map, DataWriter dataWriter) {
        HashSet<String> hashSet = new HashSet<String>();
        set.forEach(n -> hashSet.add(this.artifactIdToString((int)n)));
        this.uploadService.post(new VMArtifactChunk().artifactIds(hashSet).metadata(map).artifactType(type), dataWriter);
    }

    @Override
    public void finishVmArtifactChunk() {
        this.uploadService.sync();
    }

    @Override
    public void consumeVMArtifactPatch(VMArtifact.Type type, int n, Map<String, Object> map) {
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_PATCH).eventPayload(new VMArtifact().artifactType(type).artifactId(this.artifactIdToString(n)).metadata(map)));
    }
}

