/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.client.Inventory;
import com.azul.crs.client.Options;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.eventconsumer.VmEventConsumer;
import com.azul.crs.client.jars.JarAccess;
import com.azul.crs.client.jars.VmJarInfoRequestSupport;
import com.azul.crs.client.jars.classmethods.ClassMethodsDetector;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.util.ThrowingBiConsumer;
import com.azul.crs.digest.Digest;
import com.azul.crs.digest.ShadedClassHashCalculator;
import com.azul.crs.runtime.utils.ClassMethodsMap;
import com.azul.crs.runtime.utils.DataEntriesMap;
import com.azul.crs.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class VMEventHelper {
    private static final int VM_JAR_LOADED_EVENT_INLINE_PAYLOAD_THRESHOLD = 524288;

    static Logger logger() {
        return Logger.getLogger(VMEventHelper.class);
    }

    public static VMEvent jarLoadEventWithError(VMEvent vMEvent, JarAccess jarAccess, JarLoadProcessingError jarLoadProcessingError, Exception exception) {
        if (vMEvent == null) {
            vMEvent = VMEventHelper.prepareMinimalEvent(jarAccess);
        }
        Map map = (Map)vMEvent.getEventPayload();
        map.remove("entries");
        map.put("entries", new HashSet());
        map.remove("requestCookie");
        map.put("error", jarLoadProcessingError);
        map.put("cause", com.azul.crs.client.util.Utils.toStringWithCause(exception));
        return vMEvent;
    }

    private static InputStream wrapStream(InputStream inputStream, Digest digest) {
        return new DigestInputStream(inputStream, digest.getMessageDigest()){

            @Override
            public long skip(long l) throws IOException {
                int n;
                long l2;
                if (l <= 0L) {
                    return 0L;
                }
                int n2 = (int)Math.min(2048L, l2);
                byte[] byArray = new byte[n2];
                for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
                }
                return l - l2;
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
    }

    private static VMEvent updateJarLoadedEvent(VMEvent vMEvent, String string, JarAccess.InitiatedBy initiatedBy, Integer n, String string2, Long l, String string3, String string4, String string5, Long l2, List<String> list, Set<MavenComponent> set, Map<String, Long> map, String string6, Long l3, ClassMethodsMap classMethodsMap) {
        Map<String, String> map2;
        Map map3 = map2 = vMEvent == null ? new HashMap() : (Map)vMEvent.getEventPayload();
        if (string != null) {
            map2.put("url", string);
        }
        if (string2 != null) {
            map2.put("jarName", string2);
        }
        if (string3 != null) {
            map2.put("centralDirectoryHash", string3);
        }
        if (string4 != null) {
            map2.put("manifestHash", string4);
        }
        if (string5 != null) {
            map2.put("centralDirectoryExtractionMethod", string5);
        }
        if (l2 != null) {
            map2.put("centralDirectoryLength", l2 != null ? Long.toString(l2) : null);
        }
        if (list != null) {
            map2.put("entries", (String)((Object)list));
        }
        if (classMethodsMap != null && !classMethodsMap.getMap().isEmpty()) {
            map2.put("methods", (String)((Object)classMethodsMap.getMap()));
        }
        if (initiatedBy != null) {
            map2.put("initiatedBy", (String)((Object)initiatedBy));
        }
        if (n != null) {
            map2.put("recursionDepth", (String)((Object)n));
        }
        if (set != null) {
            map2.put("mavenComponents", (String)((Object)set));
        }
        if (map != null) {
            map2.put("stats", (String)((Object)map));
        }
        if (string6 != null) {
            map2.put("parentCentralDirectoryHash", string6);
        }
        if (l3 != null) {
            map2.put("parentCentralDirectoryLength", l3 != null ? Long.toString(l3) : null);
        }
        if (vMEvent == null) {
            vMEvent = new VMEvent();
        }
        vMEvent.eventType(VMEvent.Type.VM_JAR_LOADED);
        if (l != null) {
            vMEvent.eventTime(l);
        }
        vMEvent.eventPayload(map2);
        return vMEvent;
    }

    public static VMEvent prepareMinimalEvent(JarAccess jarAccess) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        HashSet<MavenComponent> hashSet = new HashSet<MavenComponent>();
        String string = null;
        String string2 = null;
        String string3 = null;
        Long l = null;
        String string4 = null;
        Long l2 = null;
        if (Tweaks.sendCentralDirectoryHash) {
            string = jarAccess.getHash();
            string2 = jarAccess.getManifesthash();
            if (jarAccess.getJarShortDigest() != null) {
                string3 = jarAccess.getJarShortDigest().getProvider();
                l = jarAccess.getJarShortDigest().getCentralDirectoryLength();
            } else {
                new RuntimeException("(no central directory hash in minimal event) debug me: " + jarAccess).printStackTrace();
            }
            if (jarAccess.getParentJarAccess() != null) {
                string4 = jarAccess.getParentJarAccess().getHash();
                l2 = jarAccess.getParentJarAccess().getJarShortDigest().getCentralDirectoryLength();
                DataEntriesMap.DataEntry dataEntry = jarAccess.getParentJarAccess().getCache().entriesMap.getEntry(jarAccess.entryAccess().getName());
                dataEntry.put(Hashes.ENTRY_CD, jarAccess.getHash());
                dataEntry.put(Hashes.ENTRY_CD_LENGTH, String.valueOf(jarAccess.getJarShortDigest().getCentralDirectoryLength()));
            }
        }
        long l3 = Utils.currentTimeMillis();
        DataEntriesMap<Hashes> dataEntriesMap = new DataEntriesMap<Hashes>(Hashes.class);
        VMEvent vMEvent = VMEventHelper.updateJarLoadedEvent(null, jarAccess.getUrlOrSourceOrNull(), jarAccess.getInitiatedBy(), jarAccess.getNestingLevel(), jarAccess.getJarName(), l3, string, string2, string3, l, dataEntriesMap.pack().toExternalForm(), hashSet, hashMap, string4, l2, null);
        VmJarInfoRequestSupport.VmJarInfoRequestCookie vmJarInfoRequestCookie = new VmJarInfoRequestSupport.VmJarInfoRequestCookie(jarAccess.getJarName(), jarAccess.getPath(), string);
        ((Map)vMEvent.getEventPayload()).put("requestCookie", vmJarInfoRequestCookie.encode());
        jarAccess.getCache().entriesMap = dataEntriesMap;
        jarAccess.getCache().vmEvent = vMEvent;
        return vMEvent;
    }

    private static void prepareVMJarLoadedEventDetails(DataEntriesMap<Hashes> dataEntriesMap, Set<MavenComponent> set, Map<String, Long> map, ClassMethodsMap classMethodsMap, JarAccess jarAccess) {
        ArrayList<Consumer<JarAccess.EntryAccess>> arrayList = new ArrayList<Consumer<JarAccess.EntryAccess>>();
        AtomicLong atomicLong = new AtomicLong();
        boolean bl = Options.sendPOMData.isYes();
        AtomicLong atomicLong2 = new AtomicLong(1L);
        if (Tweaks.sendJarEntriesHashes) {
            arrayList.add(entryAccess -> {
                atomicLong.addAndGet(-System.nanoTime());
                try {
                    DataEntriesMap.DataEntry dataEntry = dataEntriesMap.getEntry(entryAccess.getName());
                    dataEntry.put(Hashes.ENTRY_CRC32, String.format("%08x", entryAccess.getCrc()));
                    dataEntry.put(Hashes.ENTRY_SIZE, Long.toString(entryAccess.getSize()));
                }
                finally {
                    atomicLong.addAndGet(System.nanoTime());
                }
            });
        }
        AtomicLong atomicLong3 = new AtomicLong();
        if (Tweaks.sendJarEntriesShadedHashes) {
            arrayList.add(entryAccess -> {
                atomicLong3.addAndGet(-System.nanoTime());
                try {
                    String string = entryAccess.getName();
                    if (string.endsWith(".class")) {
                        try {
                            Digest digest = Digest.get();
                            Digest digest2 = Digest.get();
                            entryAccess.withInputStream(inputStream -> {
                                InputStream inputStream2 = new BufferedInputStream((InputStream)inputStream);
                                inputStream2 = VMEventHelper.wrapStream(inputStream2, digest);
                                ShadedClassHashCalculator.updateHash(inputStream2, digest2);
                                dataEntriesMap.put(string, Hashes.CLASS_SHADED_HASH, digest2.asHexString());
                                inputStream2.skip(Long.MAX_VALUE);
                                dataEntriesMap.put(string, Hashes.SHA256, digest.asHexString());
                            });
                        }
                        catch (Exception exception) {
                            VMEventHelper.logger().error("Calculating shaded hash of class %s failed with exception: %s", string, exception);
                            dataEntriesMap.put(string, Hashes.SHA256, "0000000000000000000000000000000000000000000000000000000000000000");
                        }
                    }
                }
                finally {
                    atomicLong3.addAndGet(System.nanoTime());
                }
            });
        }
        AtomicLong atomicLong4 = new AtomicLong();
        if (Tweaks.sendClassMethods || Options.sendClassMethods.isYes()) {
            arrayList.add(entryAccess -> {
                atomicLong4.addAndGet(-System.nanoTime());
                try {
                    String string = entryAccess.getName();
                    if (string.endsWith(".class")) {
                        try {
                            entryAccess.withInputStream(inputStream -> {
                                long l = atomicLong2.getAndIncrement();
                                List<String> list = ClassMethodsDetector.detect(string, inputStream);
                                if (!list.isEmpty()) {
                                    classMethodsMap.add(l, list);
                                }
                                dataEntriesMap.put(string, Hashes.CLASS_ID, String.valueOf(l));
                            });
                        }
                        catch (Exception exception) {
                            VMEventHelper.logger().error("Method detection for class %s failed with exception: %s", string, exception);
                        }
                    }
                }
                finally {
                    atomicLong4.addAndGet(System.nanoTime());
                }
            });
        }
        AtomicLong atomicLong5 = new AtomicLong();
        if (bl) {
            arrayList.add(entryAccess -> {
                atomicLong5.addAndGet(-System.nanoTime());
                try {
                    if (entryAccess.getName().endsWith("/pom.properties")) {
                        MavenComponent mavenComponent = new MavenComponent();
                        try {
                            entryAccess.withInputStream(inputStream -> {
                                mavenComponent.load((InputStream)inputStream);
                                set.add(mavenComponent);
                            });
                        }
                        catch (Exception exception) {
                            VMEventHelper.logger().warning("Failed to read %s: %s", entryAccess.getName(), exception.toString());
                        }
                    }
                }
                finally {
                    atomicLong5.addAndGet(System.nanoTime());
                }
            });
        }
        long l = System.nanoTime();
        jarAccess.forEachEntry(entryAccess -> {
            for (Consumer consumer : arrayList) {
                consumer.accept(entryAccess);
            }
        });
        map.put("visitJarEntries", System.nanoTime() - l);
        map.put("jarEntriesShaded", atomicLong3.get());
        map.put("jarEntriesHashes", atomicLong.get());
        if (Tweaks.sendClassMethods || Options.sendClassMethods.isYes()) {
            map.put("jarMethods", atomicLong4.get());
        }
        if (bl) {
            map.put("pomProperties", atomicLong5.get());
        }
    }

    public static void prepareDetailed(VMEvent vMEvent, JarAccess jarAccess) {
        if (vMEvent == null) {
            vMEvent = VMEventHelper.prepareMinimalEvent(jarAccess);
        }
        vMEvent.onSuccess(null).onError(null);
        Map map = (Map)vMEvent.getEventPayload();
        map.remove("requestCookie");
        HashSet<MavenComponent> hashSet = new HashSet<MavenComponent>();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        VMEventHelper.prepareVMJarLoadedEventDetails(jarAccess.getCache().entriesMap, hashSet, hashMap, jarAccess.getCache().classMethodsMap, jarAccess);
        VMEventHelper.updateJarLoadedEvent(vMEvent, null, jarAccess.getInitiatedBy(), null, null, null, null, null, null, null, jarAccess.getCache().entriesMap.pack().toExternalForm(), hashSet, hashMap, null, null, jarAccess.getCache().classMethodsMap);
    }

    private static void syncUpload(VmEventConsumer vmEventConsumer, String string, VMArtifact.Type type, Map<String, Object> map, ThrowingBiConsumer<Integer, OutputStream, IOException> throwingBiConsumer) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        int n = vmEventConsumer.createArtifactId();
        vmEventConsumer.consumeVMArtifact(type, n, map, outputStream -> {
            try {
                throwingBiConsumer.accept(n, outputStream);
                atomicBoolean.set(true);
            }
            catch (IOException iOException) {
                VMEventHelper.logger().error("syncUpload for %s failed: %s", string, iOException);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            VMEventHelper.logger().warning("syncUpload for %s interrupted", string);
        }
    }

    public static void postVMJarLoadedEvent(VmEventConsumer vmEventConsumer, VMEvent vMEvent) {
        int n2;
        boolean bl;
        if (Tweaks.DEBUG_JARLOAD) {
            VMEventHelper.logger().trace("postVMJarLoadedEvent: %s", vMEvent);
        }
        boolean bl2 = bl = (n2 = vMEvent.toJson().length()) > 524288;
        if (!bl) {
            vmEventConsumer.consumeVMEvent(vMEvent);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("eventId", vMEvent.getEventId());
        hashMap.put("tags", Inventory.instanceTags());
        VMEventHelper.syncUpload(vmEventConsumer, "VM_JAR_LOADED event" + vMEvent.getEventId(), VMArtifact.Type.LARGE_VM_EVENT, hashMap, (n, outputStream) -> {
            PrintStream printStream = new PrintStream((OutputStream)outputStream);
            Utils.serializer.serialize(printStream, (Object)vMEvent);
            Map map = (Map)vMEvent.getEventPayload();
            map.remove("entries");
            map.remove("methods");
            map.put("STORED_VM_JAR_LOADED_EVENT", vmEventConsumer.artifactIdToString((int)n));
            vmEventConsumer.consumeVMEvent(vMEvent);
        });
    }

    private static final class MavenComponent
    extends Properties {
        private MavenComponent() {
        }
    }

    static enum Hashes {
        ENTRY_CRC32,
        ENTRY_SIZE,
        SHA256,
        CLASS_SHADED_HASH,
        ENTRY_CD,
        ENTRY_CD_LENGTH,
        CLASS_ID;

    }

    public static enum JarLoadProcessingError {
        TEMPFS_LIMIT,
        EXCEPTION,
        NESTED_JAR,
        SEND_FAILED,
        OTHER;

    }
}

