/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.security.sasl.SaslException;

public class TlsChannelBinding {
    public static final String CHANNEL_BINDING_TYPE = "com.sun.jndi.ldap.tls.cbtype";
    public static final String CHANNEL_BINDING = "jdk.internal.sasl.tlschannelbinding";
    private final TlsChannelBindingType cbType;
    private final byte[] cbData;

    public static TlsChannelBindingType parseType(String string) throws NamingException {
        if (string != null) {
            if (string.equals(TlsChannelBindingType.TLS_UNIQUE.getName())) {
                throw new NamingException("Channel binding type " + TlsChannelBindingType.TLS_UNIQUE.getName() + " is not supported");
            }
            if (string.equals(TlsChannelBindingType.TLS_SERVER_END_POINT.getName())) {
                return TlsChannelBindingType.TLS_SERVER_END_POINT;
            }
            throw new NamingException("Illegal value for com.sun.jndi.ldap.tls.cbtype property.");
        }
        return null;
    }

    public static TlsChannelBinding create(byte[] byArray) throws SaslException {
        throw new UnsupportedOperationException("tls-unique channel binding is not supported");
    }

    public static TlsChannelBinding create(X509Certificate x509Certificate) throws SaslException {
        try {
            byte[] byArray = "tls-server-end-point:".getBytes();
            String string = x509Certificate.getSigAlgName().replace("SHA", "SHA-").toUpperCase();
            int n = string.indexOf("WITH");
            if (n > 0) {
                if ((string = string.substring(0, n)).equals("MD5") || string.equals("SHA-1")) {
                    string = "SHA-256";
                }
            } else {
                string = "SHA-256";
            }
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = messageDigest.digest(x509Certificate.getEncoded());
            byte[] byArray3 = Arrays.copyOf(byArray, byArray.length + byArray2.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return new TlsChannelBinding(TlsChannelBindingType.TLS_SERVER_END_POINT, byArray3);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            throw new SaslException("Cannot create TLS channel binding data", generalSecurityException);
        }
    }

    private TlsChannelBinding(TlsChannelBindingType tlsChannelBindingType, byte[] byArray) {
        this.cbType = tlsChannelBindingType;
        this.cbData = byArray;
    }

    public TlsChannelBindingType getType() {
        return this.cbType;
    }

    public byte[] getData() {
        return this.cbData;
    }

    public static enum TlsChannelBindingType {
        TLS_UNIQUE("tls-unique"),
        TLS_SERVER_END_POINT("tls-server-end-point");

        private final String name;

        public String getName() {
            return this.name;
        }

        private TlsChannelBindingType(String string2) {
            this.name = string2;
        }
    }
}

