/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.C;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeCursors;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.SysFS;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

class MX6Cursor
extends NativeCursor {
    private int hotspotX;
    private int hotspotY;
    private int offsetX;
    private int offsetY;
    private int cursorX;
    private int cursorY;
    private static final int SHORT_KEY = 43947;
    private static final int CURSOR_WIDTH = 16;
    private static final int CURSOR_HEIGHT = 16;
    private Buffer cursorBuffer;
    private Buffer offsetCursorBuffer;
    private ByteBuffer offsetCursorByteBuffer;
    private int screenWidth;
    private int screenHeight;
    private LinuxSystem system;
    private MXCFBPos pos = new MXCFBPos();
    private MXCFBGblAlpha alpha = new MXCFBGblAlpha();
    private long fd = -1L;

    MX6Cursor() {
        Object object;
        try {
            SysFS.write("/sys/class/graphics/fb1/blank", "0");
            this.system = LinuxSystem.getLinuxSystem();
            object = new LinuxSystem.FbVarScreenInfo();
            this.fd = this.system.open("/dev/fb1", 2);
            if (this.fd == -1L) {
                throw new IOException(this.system.getErrorMessage());
            }
            this.system.ioctl(this.fd, 17920, ((LinuxSystem.FbVarScreenInfo)object).p);
            ((LinuxSystem.FbVarScreenInfo)object).setRes(((LinuxSystem.FbVarScreenInfo)object).p, 16, 16);
            ((LinuxSystem.FbVarScreenInfo)object).setVirtualRes(((LinuxSystem.FbVarScreenInfo)object).p, 16, 16);
            ((LinuxSystem.FbVarScreenInfo)object).setOffset(((LinuxSystem.FbVarScreenInfo)object).p, 0, 0);
            ((LinuxSystem.FbVarScreenInfo)object).setActivate(((LinuxSystem.FbVarScreenInfo)object).p, 0);
            ((LinuxSystem.FbVarScreenInfo)object).setBitsPerPixel(((LinuxSystem.FbVarScreenInfo)object).p, 16);
            ((LinuxSystem.FbVarScreenInfo)object).setRed(((LinuxSystem.FbVarScreenInfo)object).p, 5, 11);
            ((LinuxSystem.FbVarScreenInfo)object).setGreen(((LinuxSystem.FbVarScreenInfo)object).p, 6, 5);
            ((LinuxSystem.FbVarScreenInfo)object).setBlue(((LinuxSystem.FbVarScreenInfo)object).p, 5, 0);
            ((LinuxSystem.FbVarScreenInfo)object).setTransp(((LinuxSystem.FbVarScreenInfo)object).p, 0, 0);
            this.system.ioctl(this.fd, 17921, ((LinuxSystem.FbVarScreenInfo)object).p);
            this.system.ioctl(this.fd, 17937, 0L);
            MXCFBColorKey mXCFBColorKey = new MXCFBColorKey();
            mXCFBColorKey.setEnable(1);
            mXCFBColorKey.setColorKey(11367770);
            int n = this.system.IOW(70, 34, mXCFBColorKey.sizeof());
            if (this.system.ioctl(this.fd, n, mXCFBColorKey.p) < 0) {
                throw new IOException(this.system.strerror(this.system.errno()));
            }
        }
        catch (IOException iOException) {
            if (this.fd != -1L) {
                LinuxSystem.getLinuxSystem().close(this.fd);
                this.fd = -1L;
            }
            iOException.printStackTrace();
            System.err.println("Failed to initialize i.MX6 cursor");
        }
        object = NativePlatformFactory.getNativePlatform().getScreen();
        this.screenWidth = object.getWidth();
        this.screenHeight = object.getHeight();
    }

    @Override
    Size getBestSize() {
        return new Size(16, 16);
    }

    @Override
    void setVisibility(boolean bl) {
        this.alpha.setEnable(1);
        this.alpha.setAlpha(bl ? 255 : 0);
        int n = this.system.IOW(70, 33, this.alpha.sizeof());
        this.system.ioctl(this.fd, n, this.alpha.p);
        this.isVisible = bl;
        this.updateImage(true);
    }

    private void updateImage(boolean bl) {
        if (this.isVisible && this.cursorBuffer != null) {
            int n = Math.max(0, 16 + this.cursorX - this.screenWidth);
            int n2 = Math.max(0, 16 + this.cursorY - this.screenHeight);
            if (n != this.offsetX || n2 != this.offsetY || bl) {
                NativeCursors.offsetCursor(this.cursorBuffer, this.offsetCursorBuffer, n, n2, 16, 16, 16, 43947);
                this.offsetX = n;
                this.offsetY = n2;
                this.system.lseek(this.fd, 0L, 0);
                if (this.system.write(this.fd, this.offsetCursorByteBuffer, 0, this.offsetCursorByteBuffer.capacity()) < 0L) {
                    System.err.println("Failed to write to i.MX6 cursor: " + this.system.getErrorMessage());
                }
            }
        }
    }

    @Override
    void setImage(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        this.cursorBuffer = byteBuffer.asShortBuffer();
        NativeCursors.colorKeyCursor(byArray, this.cursorBuffer, 16, 43947);
        this.offsetCursorByteBuffer = ByteBuffer.allocateDirect(byArray.length);
        this.offsetCursorByteBuffer.order(ByteOrder.nativeOrder());
        this.offsetCursorBuffer = this.offsetCursorByteBuffer.asShortBuffer();
        this.updateImage(true);
    }

    @Override
    void setLocation(int n, int n2) {
        this.cursorX = n;
        this.cursorY = n2;
        this.updateImage(false);
        this.pos.set(n, n2);
        int n3 = this.system.IOWR(70, 36, this.pos.sizeof());
        this.system.ioctl(this.fd, n3, this.pos.p);
    }

    @Override
    void setHotSpot(int n, int n2) {
        this.hotspotX = n;
        this.hotspotY = n2;
    }

    @Override
    void shutdown() {
        this.setVisibility(false);
    }

    private static class MXCFBPos
    extends C.Structure {
        private final ShortBuffer data;

        MXCFBPos() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asShortBuffer();
        }

        @Override
        int sizeof() {
            return 4;
        }

        void set(int n, int n2) {
            this.data.put(0, (short)n);
            this.data.put(1, (short)n2);
        }
    }

    private static class MXCFBGblAlpha
    extends C.Structure {
        private final IntBuffer data;

        MXCFBGblAlpha() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asIntBuffer();
        }

        @Override
        int sizeof() {
            return 8;
        }

        void setEnable(int n) {
            this.data.put(0, n);
        }

        void setAlpha(int n) {
            this.data.put(1, n);
        }
    }

    private static class MXCFBColorKey
    extends C.Structure {
        private final IntBuffer data;

        MXCFBColorKey() {
            this.b.order(ByteOrder.nativeOrder());
            this.data = this.b.asIntBuffer();
        }

        @Override
        int sizeof() {
            return 8;
        }

        void setEnable(int n) {
            this.data.put(0, n);
        }

        void setColorKey(int n) {
            this.data.put(1, n);
        }
    }
}

