/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import com.innovarhealthcare.launcher.CodeBase;
import com.innovarhealthcare.launcher.ExtensionInfo;
import com.innovarhealthcare.launcher.JarInfo;
import com.innovarhealthcare.launcher.interfaces.Progress;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DownloadJNLP {
    private static final String LOG_FILE = "launcher-debug.log";
    private static final boolean DEBUG = false;
    private final File cacheFolder;
    private String host = "";
    private volatile boolean cancelled = false;
    private boolean clearCacheJars = false;

    public DownloadJNLP(String host, File cacheFolder, boolean clearCacheJars) {
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        this.host = host;
        this.cacheFolder = cacheFolder;
        this.clearCacheJars = clearCacheJars;
    }

    public CodeBase handle(Progress progress) throws Exception {
        progress.updateProgressText("Requesting main JNLP...");
        this.checkCancelled("handle start");
        String jnlpUrl = this.host + "/webstart.jnlp";
        this.log("\ud83d\udd0d Fetching main JNLP from: " + jnlpUrl);
        List<Object> localJars = new ArrayList();
        ArrayList<String> arguments = new ArrayList<String>();
        String bridgeVersion = "unknown";
        String mainClass = "com.mirth.connect.client.ui.Mirth";
        try {
            URL url = new URL(jnlpUrl);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document doc = documentBuilder.parse(url.openStream());
            ArrayList<JarInfo> coreJarInfos = new ArrayList<JarInfo>();
            NodeList jarList = doc.getElementsByTagName("jar");
            for (int i = 0; i < jarList.getLength(); ++i) {
                this.checkCancelled("core JAR extraction");
                Element jarElement = (Element)jarList.item(i);
                String href = jarElement.getAttribute("href");
                String jarElementSha256 = jarElement.getAttribute("sha256");
                coreJarInfos.add(new JarInfo(href, jarElementSha256));
            }
            NodeList versionNodes = doc.getElementsByTagName("title");
            if (versionNodes.getLength() > 0) {
                bridgeVersion = versionNodes.item(0).getTextContent().replaceAll("[^0-9.]", "");
            }
            bridgeVersion = doc.getDocumentElement().getAttribute("version");
            this.log("\u2705 Detected BridgeLink Version: " + bridgeVersion);
            progress.updateProgressText("Requesting JNLP for extensions...");
            this.checkCancelled("extension JNLP extraction");
            NodeList extensionNodes = doc.getElementsByTagName("extension");
            ArrayList<String> extensionJnlpUrls = new ArrayList<String>();
            String baseUrl = jnlpUrl.replace("webstart.jnlp", "");
            for (int i = 0; i < extensionNodes.getLength(); ++i) {
                Element extElement = (Element)extensionNodes.item(i);
                String extJnlpPath = extElement.getAttribute("href");
                String extJnlpUrl = baseUrl + extJnlpPath;
                extensionJnlpUrls.add(extJnlpUrl);
            }
            this.log("\u2705 Found extension JNLPs: " + extensionJnlpUrls);
            ArrayList<ExtensionInfo> listExtensions = new ArrayList<ExtensionInfo>();
            for (String extJnlpUrl : extensionJnlpUrls) {
                this.checkCancelled("parseExtensionJnlp");
                listExtensions.add(this.parseExtensionJnlp(extJnlpUrl));
            }
            localJars = this.download(jnlpUrl, coreJarInfos, bridgeVersion, listExtensions, progress, this.clearCacheJars);
            NodeList appDescNodes = doc.getElementsByTagName("application-desc");
            if (appDescNodes.getLength() > 0) {
                Element appDescElement = (Element)appDescNodes.item(0);
                NodeList argNodes = appDescElement.getElementsByTagName("argument");
                for (int i = 0; i < argNodes.getLength(); ++i) {
                    arguments.add(argNodes.item(i).getTextContent());
                }
                String mainClassAttr = appDescElement.getAttribute("main-class");
                if (mainClassAttr != null && !mainClassAttr.isEmpty()) {
                    mainClass = mainClassAttr;
                }
            }
        }
        catch (Exception e) {
            this.log("\u274c ERROR in handle(): " + e.getMessage());
            throw e;
        }
        ArrayList<String> classpath = new ArrayList<String>();
        for (File file : localJars) {
            classpath.add(file.getAbsolutePath());
        }
        return new CodeBase(classpath, mainClass, this.host, bridgeVersion, arguments);
    }

    private ExtensionInfo parseExtensionJnlp(String extJnlpUrl) {
        this.log("\ud83d\udd0d Fetching Extension JNLP: " + extJnlpUrl);
        try {
            URL url = new URL(extJnlpUrl);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(url.openStream());
            String extensionName = new File(new URL(extJnlpUrl).getPath()).getName().replace(".jnlp", "");
            HashMap<String, String> mapJars = new HashMap<String, String>();
            NodeList jarList = doc.getElementsByTagName("jar");
            for (int i = 0; i < jarList.getLength(); ++i) {
                Element jarElement = (Element)jarList.item(i);
                String jarPath = jarElement.getAttribute("href");
                String jarElementSha256 = jarElement.getAttribute("sha256");
                String jarUrl = this.host + "/webstart/extensions/" + jarPath;
                mapJars.put(jarUrl, new File(jarPath).getName() + "|" + jarElementSha256);
            }
            this.log("\u2705 Extension JARs for " + extensionName + ": " + ((Object)mapJars).toString());
            return new ExtensionInfo(extensionName, mapJars);
        }
        catch (Exception e) {
            this.log("\u274c ERROR fetching extension JNLP: " + e.getMessage());
            return new ExtensionInfo();
        }
    }

    private List<File> download(String jnlpUrl, List<JarInfo> coreJarInfos, String bridgeVersion, List<ExtensionInfo> listExtensions, Progress progress, boolean clearCacheJars) throws Exception {
        this.log("\ud83d\ude80 Starting download process for BridgeLink version: " + bridgeVersion);
        this.checkCancelled("download start");
        String baseUrl = jnlpUrl.substring(0, jnlpUrl.indexOf("/webstart") + 9);
        String path = bridgeVersion + "/core";
        File coreFolder = new File(this.cacheFolder, path);
        if (!coreFolder.exists()) {
            coreFolder.mkdirs();
        }
        ArrayList<File> localJars = new ArrayList<File>();
        int numOfJars = coreJarInfos.size() + listExtensions.size();
        int cntNum = 0;
        for (JarInfo jarInfo : coreJarInfos) {
            this.checkCancelled("core JAR download");
            String correctedJarUrl = baseUrl + "/client-lib/" + new File(jarInfo.getHref()).getName();
            File localFile = new File(coreFolder, new File(jarInfo.getHref()).getName());
            progress.updateProgressText("Downloading Core JAR " + jarInfo.getHref() + "...");
            this.log("\u2b07\ufe0f Checking Core JAR: " + correctedJarUrl);
            ++cntNum;
            if (clearCacheJars) {
                this.log("\ud83d\udd04 Clear cache enabled - downloading core JAR: " + localFile.getName());
            } else if (localFile.exists() && jarInfo.getSha256() != null && !jarInfo.getSha256().trim().isEmpty()) {
                try {
                    String localHash = this.calculateSha256(localFile);
                    this.log("\ud83d\udd0d Local file SHA-256:    '" + localHash + "'");
                    this.log("\ud83d\udd0d Expected SHA-256:      '" + jarInfo.getSha256() + "'");
                    if (jarInfo.getSha256().trim().equals(localHash)) {
                        this.log("\u2705 Skipping core JAR (hash matches): " + localFile.getName());
                        localJars.add(localFile);
                        progress.updateProgressBar((double)cntNum / (double)numOfJars);
                        continue;
                    }
                    this.log("\ud83d\udd04 Hash differs, re-downloading core JAR: " + localFile.getName());
                    this.log("\ud83d\udd04 Local:    " + localHash);
                    this.log("\ud83d\udd04 Expected: " + jarInfo.getSha256());
                }
                catch (Exception e) {
                    this.log("\u274c ERROR calculating local hash for " + localFile.getName() + ": " + e.getMessage());
                }
            } else {
                this.log("\ud83d\udd0d Core JAR info - exists: " + localFile.exists() + ", getSha256: '" + jarInfo.getSha256() + "'");
            }
            if (!this.downloadFile(correctedJarUrl, localFile, jarInfo.getSha256())) {
                this.log("\u274c WARNING: Failed to download core JAR: " + correctedJarUrl);
                continue;
            }
            localJars.add(localFile);
            progress.updateProgressBar((double)cntNum / (double)numOfJars);
        }
        for (ExtensionInfo jar : listExtensions) {
            this.checkCancelled("extension JAR download");
            String extensionName = jar.getName();
            String extPath = bridgeVersion + "/extensions/" + extensionName;
            File extensionFolder = new File(this.cacheFolder, extPath);
            if (!extensionFolder.exists()) {
                extensionFolder.mkdirs();
            }
            Map<String, String> mapJars = jar.getMapJars();
            ++cntNum;
            if (mapJars == null) {
                this.log("\u274c WARNING: Failed to download Extension JAR: mapJars is null - extensionName: " + extensionName);
                continue;
            }
            for (Map.Entry<String, String> entry : mapJars.entrySet()) {
                this.checkCancelled("extension JAR download loop");
                String jarUrl = entry.getKey();
                String jarInfo = entry.getValue();
                String[] parts = jarInfo.split("\\|", 2);
                String jarName = parts[0];
                String expectedSha256 = parts.length > 1 ? parts[1] : null;
                File localFile = new File(extensionFolder, jarName);
                progress.updateProgressText("Downloading JARs for extension " + jarName + "...");
                this.log("\u2b07\ufe0f Checking Extension JAR: " + jarUrl + " -> " + localFile.getAbsolutePath());
                if (clearCacheJars) {
                    this.log("\ud83d\udd04 Clear cache enabled - downloading extension JAR: " + localFile.getName());
                } else if (localFile.exists() && expectedSha256 != null && !expectedSha256.trim().isEmpty()) {
                    try {
                        String localHash = this.calculateSha256(localFile);
                        this.log("\ud83d\udd0d Extension Local SHA-256:    '" + localHash + "'");
                        this.log("\ud83d\udd0d Extension Expected SHA-256:  '" + expectedSha256 + "'");
                        if (expectedSha256.trim().equals(localHash)) {
                            this.log("\u2705 Skipping extension JAR (hash matches): " + localFile.getName());
                            localJars.add(localFile);
                            continue;
                        }
                        this.log("\ud83d\udd04 Hash differs, re-downloading extension JAR: " + localFile.getName());
                    }
                    catch (Exception e) {
                        this.log("\u274c ERROR calculating local hash for " + localFile.getName() + ": " + e.getMessage());
                    }
                }
                if (!this.downloadFile(jarUrl, localFile, expectedSha256)) {
                    this.log("\u274c WARNING: Missing extension JAR: " + jarUrl);
                    continue;
                }
                localJars.add(localFile);
            }
            progress.updateProgressBar((double)cntNum / (double)numOfJars);
        }
        return localJars;
    }

    private boolean downloadFile(String urlStr, File destination, String expectedSha256) throws InterruptedException {
        if (Thread.interrupted() || this.cancelled) {
            throw new InterruptedException("Download cancelled");
        }
        try {
            if (!this.clearCacheJars && destination.exists() && expectedSha256 != null) {
                String actualSha256 = this.calculateSha256(destination);
                if (expectedSha256.trim().equalsIgnoreCase(actualSha256)) {
                    this.log("\u2705 Skipping already downloaded file: " + destination.getName());
                    return true;
                }
            }
            this.log("\u2b07\ufe0f Downloading: " + urlStr);
            URL url = new URL(urlStr);
            try (InputStream in = url.openStream();
                 FileOutputStream out = new FileOutputStream(destination);){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            if (expectedSha256 != null && !expectedSha256.trim().isEmpty()) {
                String actualSha256 = this.calculateSha256(destination);
                this.log("\ud83d\udd0d Expected SHA-256: '" + expectedSha256.trim() + "'");
                this.log("\ud83d\udd0d Actual SHA-256:   '" + actualSha256 + "'");
                this.log("\ud83d\udd0d Hash lengths - Expected: " + expectedSha256.length() + ", Actual: " + actualSha256.length());
                if (!expectedSha256.trim().equals(actualSha256)) {
                    this.log("\u274c ERROR: SHA-256 mismatch for " + destination.getName());
                    this.log("\u274c Expected: " + expectedSha256.trim());
                    this.log("\u274c Actual:   " + actualSha256);
                    destination.delete();
                    return false;
                }
                this.log("\u2705 SHA-256 verification passed for " + destination.getName());
            }
            this.log("\u2705 Saved: " + destination.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            this.log("\u274c ERROR downloading file: " + urlStr + " - " + e.getMessage());
            return false;
        }
    }

    private String calculateSha256(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);
             DigestInputStream dis = new DigestInputStream(fis, digest);){
            byte[] buffer = new byte[4096];
            while (dis.read(buffer) != -1) {
            }
        }
        byte[] hashBytes = digest.digest();
        return Base64.getEncoder().encodeToString(hashBytes);
    }

    private void log(String message) {
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void checkCancelled(String context) throws InterruptedException {
        if (Thread.interrupted() || this.cancelled) {
            this.log("\ud83d\udeab Cancelled at: " + context);
            throw new InterruptedException("Download cancelled");
        }
    }
}

