/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public class IconSelectionDialog {
    private final Stage parentStage;
    private final File dataFolder;
    private final Image defaultIcon;
    private final Consumer<String> onIconSelected;

    public IconSelectionDialog(Stage parentStage, File dataFolder, Image defaultIcon, Consumer<String> onIconSelected) {
        this.parentStage = parentStage;
        this.dataFolder = dataFolder;
        this.defaultIcon = defaultIcon;
        this.onIconSelected = onIconSelected;
    }

    public void show() {
        File[] files;
        Stage iconStage = new Stage();
        iconStage.setTitle("Select Icon");
        iconStage.initOwner((Window)this.parentStage);
        iconStage.initModality(Modality.APPLICATION_MODAL);
        iconStage.getIcons().add((Object)this.defaultIcon);
        VBox root = new VBox(15.0);
        root.setPadding(new Insets(15.0));
        Label titleLabel = new Label("Choose an icon:");
        titleLabel.setStyle("-fx-font-size: 14px; -fx-font-weight: bold;");
        GridPane iconGrid = new GridPane();
        iconGrid.setHgap(10.0);
        iconGrid.setVgap(10.0);
        iconGrid.setPadding(new Insets(10.0));
        File iconsFolder = new File(this.dataFolder, "icons");
        ArrayList<File> iconFiles = new ArrayList<File>();
        if (iconsFolder.exists() && (files = iconsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".png"))) != null) {
            for (File file : files) {
                iconFiles.add(file);
            }
        }
        int col = 0;
        int row = 0;
        int maxCols = 6;
        Button bridgeLinkButton = new Button();
        bridgeLinkButton.setPrefSize(48.0, 48.0);
        bridgeLinkButton.setMinSize(48.0, 48.0);
        bridgeLinkButton.setMaxSize(48.0, 48.0);
        bridgeLinkButton.setStyle("-fx-background-color: transparent; -fx-border-color: #cccccc; -fx-border-radius: 4;");
        try {
            Image bridgeLinkImage = new Image(this.getClass().getResourceAsStream("/images/BridgeLink.png"));
            ImageView bridgeLinkView = new ImageView(bridgeLinkImage);
            bridgeLinkView.setFitWidth(36.0);
            bridgeLinkView.setFitHeight(36.0);
            bridgeLinkView.setPreserveRatio(true);
            bridgeLinkButton.setGraphic((Node)bridgeLinkView);
            bridgeLinkButton.setUserData((Object)"BridgeLink.png");
            bridgeLinkButton.setOnAction(e -> {
                this.onIconSelected.accept("BridgeLink.png");
                iconStage.close();
            });
            iconGrid.add((Node)bridgeLinkButton, col, row);
            if (++col >= maxCols) {
                col = 0;
                ++row;
            }
        }
        catch (Exception bridgeLinkImage) {
            // empty catch block
        }
        for (File iconFile : iconFiles) {
            ImageView iconView;
            Button iconChoiceButton = new Button();
            iconChoiceButton.setPrefSize(48.0, 48.0);
            iconChoiceButton.setMinSize(48.0, 48.0);
            iconChoiceButton.setMaxSize(48.0, 48.0);
            iconChoiceButton.setStyle("-fx-background-color: transparent; -fx-border-color: #cccccc; -fx-border-radius: 4;");
            try {
                Image iconImage = new Image(iconFile.toURI().toString());
                iconView = new ImageView(iconImage);
                iconChoiceButton.setUserData((Object)iconFile.getName());
            }
            catch (Exception e2) {
                continue;
            }
            iconView.setFitWidth(36.0);
            iconView.setFitHeight(36.0);
            iconView.setPreserveRatio(true);
            iconChoiceButton.setGraphic((Node)iconView);
            iconChoiceButton.setOnAction(e -> {
                String selectedIcon = (String)iconChoiceButton.getUserData();
                this.onIconSelected.accept(selectedIcon);
                iconStage.close();
            });
            iconGrid.add((Node)iconChoiceButton, col, row);
            if (++col < maxCols) continue;
            col = 0;
            ++row;
        }
        Button uploadButton = new Button("Upload New Icon");
        uploadButton.setOnAction(e -> {
            if (this.uploadNewIcon()) {
                iconStage.close();
            }
        });
        Button cancelButton = new Button("Cancel");
        cancelButton.setOnAction(e -> iconStage.close());
        HBox buttonBox = new HBox(10.0);
        buttonBox.setAlignment(Pos.CENTER_RIGHT);
        buttonBox.getChildren().addAll((Object[])new Node[]{uploadButton, cancelButton});
        ScrollPane scrollPane = new ScrollPane((Node)iconGrid);
        scrollPane.setFitToWidth(true);
        scrollPane.setPrefHeight(200.0);
        root.getChildren().addAll((Object[])new Node[]{titleLabel, scrollPane, buttonBox});
        Scene scene = new Scene((Parent)root, 450.0, 300.0);
        iconStage.setScene(scene);
        iconStage.showAndWait();
    }

    private boolean uploadNewIcon() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Choose Icon");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG Images", new String[]{"*.png"}));
        File file = fileChooser.showOpenDialog((Window)this.parentStage);
        if (file != null) {
            try {
                long fileSizeInBytes = file.length();
                long maxSizeInBytes = 0x100000L;
                if (fileSizeInBytes > maxSizeInBytes) {
                    this.showAlert("File size too large. Please select an image smaller than 1MB.\nSelected file size: " + String.format("%.2f", (double)fileSizeInBytes / 1024.0 / 1024.0) + " MB");
                    return false;
                }
                File iconsFolder = new File(this.dataFolder, "icons");
                if (!iconsFolder.exists()) {
                    iconsFolder.mkdirs();
                }
                String fileName = System.currentTimeMillis() + "_icon.png";
                File targetFile = new File(iconsFolder, fileName);
                BufferedImage originalImage = ImageIO.read(file);
                BufferedImage resizedImage = this.resizeImage(originalImage, 192, 192);
                ImageIO.write((RenderedImage)resizedImage, "PNG", targetFile);
                this.onIconSelected.accept(fileName);
                return true;
            }
            catch (IOException e) {
                this.showAlert("Failed to process icon: " + e.getMessage());
            }
            catch (Exception e) {
                this.showAlert("Error processing image: " + e.getMessage());
            }
        }
        return false;
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        BufferedImage resizedImage = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawImage(originalImage, 0, 0, targetWidth, targetHeight, null);
        g2d.dispose();
        return resizedImage;
    }

    private void showAlert(String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText(message);
        alert.initOwner((Window)this.parentStage);
        alert.showAndWait();
    }
}

