/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;

public class JavaConfig {
    private String maxHeapSize;
    private String javaHome;
    private String jvmOptions;

    public JavaConfig(String maxHeapSize, String javaHome, String jvmOptions) {
        this.maxHeapSize = maxHeapSize;
        this.javaHome = javaHome;
        this.jvmOptions = jvmOptions;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public List<String> getJvmOptionsList() {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\"([^\"]*)\"|(\\S+)").matcher(this.getJvmOptions());
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                result.add(matcher.group(1));
                continue;
            }
            result.add(matcher.group(2));
        }
        return result;
    }

    public String getMaxHeapSizeBuilder() {
        return "-Xmx" + this.maxHeapSize;
    }

    public String getJavaHomeBuilder() {
        Path alt2;
        String exe;
        boolean win = SystemUtils.IS_OS_WINDOWS;
        boolean mac = SystemUtils.IS_OS_MAC;
        String string = exe = win ? "java.exe" : "java";
        Path candidate = "Java 17".equals(this.javaHome) ? (mac ? Paths.get("..", "jre.bundle", "Contents", "Home", "bin", exe) : Paths.get("jre", "bin", exe)) : Paths.get("jre8", "bin", exe);
        if (Files.isExecutable(candidate)) {
            return candidate.toString();
        }
        Path alt1 = Paths.get("jre", "bin", exe);
        if (Files.isExecutable(alt1)) {
            return alt1.toString();
        }
        String javaHomeEnv = System.getenv("JAVA_HOME");
        if (javaHomeEnv != null && !javaHomeEnv.isEmpty() && Files.isExecutable(alt2 = Paths.get(javaHomeEnv, "bin", exe))) {
            return alt2.toString();
        }
        return exe;
    }
}

