/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import com.innovarhealthcare.launcher.CodeBase;
import com.innovarhealthcare.launcher.Credential;
import com.innovarhealthcare.launcher.JavaConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ProcessLauncher {
    private static final String LOG_FILE = "process-launcher-debug.log";
    private static final boolean DEBUG = false;

    public void launch(JavaConfig javaConfig, Credential credential, CodeBase codeBase, boolean isShowConsole) throws Exception {
        this.launch(javaConfig, credential, codeBase, isShowConsole, null, null);
    }

    public void launch(JavaConfig javaConfig, Credential credential, CodeBase codeBase, boolean isShowConsole, String iconPath) throws Exception {
        this.launch(javaConfig, credential, codeBase, isShowConsole, iconPath, null);
    }

    public void launch(JavaConfig javaConfig, Credential credential, CodeBase codeBase, boolean isShowConsole, String iconPath, String connectionName) throws Exception {
        Process targetProcess;
        this.log("\ud83d\ude80 ProcessLauncher.launch() started");
        this.log("\ud83d\udccb Parameters - iconPath: '" + iconPath + "', connectionName: '" + connectionName + "', isShowConsole: " + isShowConsole);
        this.log("\ud83d\udda5\ufe0f Operating System Detection:");
        this.log("   - IS_OS_MAC: " + SystemUtils.IS_OS_MAC);
        this.log("   - IS_OS_WINDOWS: " + SystemUtils.IS_OS_WINDOWS);
        this.log("   - IS_OS_LINUX: " + SystemUtils.IS_OS_LINUX);
        this.log("   - OS Name: " + System.getProperty("os.name"));
        this.log("   - OS Version: " + System.getProperty("os.version"));
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaConfig.getJavaHomeBuilder());
        command.add(javaConfig.getMaxHeapSizeBuilder());
        if (StringUtils.isNotBlank(javaConfig.getJvmOptions())) {
            command.addAll(javaConfig.getJvmOptionsList());
        }
        this.log("\ud83d\udd27 Building platform-specific commands...");
        if (SystemUtils.IS_OS_MAC) {
            this.log("\ud83c\udf4e Configuring macOS dock settings...");
            String dockIcon = iconPath != null && !iconPath.trim().isEmpty() ? iconPath : "icon.png";
            this.log("   - Dock icon path: '" + dockIcon + "'");
            command.add("-Xdock:icon=" + dockIcon);
            String dockName = connectionName != null && !connectionName.trim().isEmpty() ? connectionName + " - BridgeLink Administrator" : "BridgeLink Administrator";
            this.log("   - Setting dock name to: '" + dockName + "'");
            command.add("-Xdock:name=" + dockName);
            this.log("   - macOS dock configuration completed");
            if ("Java 17".equals(javaConfig.getJavaHome())) {
                this.log("   - Adding Java 17 specific options for macOS");
                command.add("--add-opens=java.desktop/com.apple.eawt=ALL-UNNAMED");
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            this.log("Configuring Windows taskbar settings...");
            if (iconPath != null && !iconPath.trim().isEmpty()) {
                this.log("   - Using custom icon: '" + iconPath + "'");
                String windowsIconPath = iconPath.replace('/', '\\');
                command.add("-Dbridgelink.icon.path=" + windowsIconPath);
            } else {
                this.log("   - No custom icon specified");
                command.add("-Dbridgelink.icon.path=");
            }
            this.log("   - Windows configuration completed");
        }
        if ("Java 17".equals(javaConfig.getJavaHome())) {
            command.add("--add-modules=java.sql.rowset");
            command.add("--add-exports=java.base/com.sun.crypto.provider=ALL-UNNAMED");
            command.add("--add-exports=java.base/sun.security.provider=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.lang.reflect=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.math=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.net=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.security=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.security.cert=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.text=ALL-UNNAMED");
            command.add("--add-opens=java.base/java.util=ALL-UNNAMED");
            command.add("--add-opens=java.base/sun.security.pkcs=ALL-UNNAMED");
            command.add("--add-opens=java.base/sun.security.rsa=ALL-UNNAMED");
            command.add("--add-opens=java.base/sun.security.x509=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/java.awt=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/java.awt.color=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/java.awt.font=ALL-UNNAMED");
            command.add("--add-opens=java.desktop/javax.swing=ALL-UNNAMED");
            command.add("--add-opens=java.xml/com.sun.org.apache.xalan.internal.xsltc.trax=ALL-UNNAMED");
        } else {
            this.log("   - Java version is not Java 17, skipping module options");
        }
        this.log("\ud83d\udce6 Adding application classpath and main class...");
        this.log("\ud83d\udcdd Classpath contains " + codeBase.getClasspath().size() + " JAR files:");
        for (int i = 0; i < codeBase.getClasspath().size(); ++i) {
            String jarPath = codeBase.getClasspath().get(i);
            File jarFile = new File(jarPath);
            this.log("   [" + (i + 1) + "] " + (String)jarPath + " (exists: " + jarFile.exists() + ", size: " + jarFile.length() + " bytes)");
        }
        command.add("-cp");
        String fullClasspath = String.join((CharSequence)File.pathSeparator, codeBase.getClasspath());
        this.log("\ud83d\udcdd Full classpath: " + fullClasspath);
        command.add(fullClasspath);
        command.add(codeBase.getMainClass());
        for (String arg : codeBase.getArguments()) {
            command.add(arg);
        }
        if (StringUtils.isNotBlank(credential.getUsername())) {
            command.add(credential.getUsername());
        }
        if (StringUtils.isNotBlank(credential.getPassword())) {
            command.add(credential.getPassword());
        }
        this.log("\ud83d\udd0d FINAL COMMAND ANALYSIS:");
        this.log("\ud83d\udccf Total command parts: " + command.size());
        for (int i = 0; i < command.size(); ++i) {
            String part = (String)command.get(i);
            if (part.startsWith("-Xdock:") || part.startsWith("-Dapp.") || part.startsWith("-Dapple.awt.") || part.startsWith("-Dcom.apple.")) {
                this.log("   [" + i + "] \ud83c\udfaf " + part + " \u2190 IMPORTANT FOR DOCK/TASKBAR");
                continue;
            }
            this.log("   [" + i + "] " + part);
        }
        ProcessBuilder targetPb = new ProcessBuilder(command);
        targetPb.redirectErrorStream(true);
        this.log("\ud83d\ude80 Starting process...");
        System.out.println("DEBUG: Executing command: " + String.join((CharSequence)" ", command));
        if (isShowConsole) {
            this.log("\ud83d\udda5\ufe0f Starting with console enabled...");
            ArrayList<String> consoleCommand = new ArrayList<String>();
            consoleCommand.add(javaConfig.getJavaHomeBuilder());
            consoleCommand.add("-Xmx256m");
            if (SystemUtils.IS_OS_MAC && iconPath != null && !iconPath.trim().isEmpty()) {
                this.log("   - Adding macOS dock icon for console: '" + iconPath + "'");
                consoleCommand.add("-Xdock:icon=" + iconPath);
                String consoleDockName = connectionName != null && !connectionName.trim().isEmpty() ? connectionName + " - Console" : "BridgeLink Console";
                consoleCommand.add("-Xdock:name=" + consoleDockName);
                consoleCommand.add("-Dcom.apple.mrj.application.apple.menu.about.name=" + consoleDockName);
                consoleCommand.add("-Dapple.awt.application.name=" + consoleDockName);
                consoleCommand.add("-Djava.awt.headless=false");
            } else if (SystemUtils.IS_OS_WINDOWS && iconPath != null && !iconPath.trim().isEmpty()) {
                this.log("   - Adding Windows taskbar icon for console: '" + iconPath + "'");
                String windowsIconPath = iconPath.replace('/', '\\');
                consoleCommand.add("-Dbridgelink.icon.path=" + windowsIconPath);
            } else if (SystemUtils.IS_OS_LINUX && iconPath != null && !iconPath.trim().isEmpty()) {
                this.log("   - Adding Linux taskbar icon for console: '" + iconPath + "'");
                consoleCommand.add("-Dapp.icon.path=" + iconPath);
                String consoleAppName = connectionName != null && !connectionName.trim().isEmpty() ? connectionName + " - Console" : "BridgeLink Console";
                consoleCommand.add("-Dapp.name=" + consoleAppName);
                consoleCommand.add("-Dapp.tooltip=" + consoleAppName);
                consoleCommand.add("-Djava.awt.headless=false");
            }
            consoleCommand.add("-cp");
            consoleCommand.add("lib/java-console.jar");
            consoleCommand.add("com.innovarhealthcare.launcher.JavaConsoleDialog");
            ProcessBuilder consolePb = new ProcessBuilder(consoleCommand);
            Process consoleProcess = consolePb.start();
            if (!consoleProcess.isAlive()) {
                this.log("\u274c Console process failed to start");
                throw new IOException("Console process failed to start");
            }
            this.log("\u2705 Console process started successfully");
            targetProcess = targetPb.start();
            if (!targetProcess.isAlive()) {
                this.log("\u274c Target process failed to start");
                throw new IOException("Target process failed to start");
            }
            this.log("\u2705 Target process started successfully with PID: " + this.getProcessId(targetProcess));
            Thread pipeThread = new Thread(() -> {
                try (OutputStream consoleInput = consoleProcess.getOutputStream();
                     InputStream targetOutput = targetProcess.getInputStream();){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = targetOutput.read(buffer)) != -1) {
                        consoleInput.write(buffer, 0, bytesRead);
                        consoleInput.flush();
                    }
                    consoleInput.flush();
                }
                catch (IOException e) {
                    this.log("\u274c Error in pipe thread: " + e.getMessage());
                }
            });
            pipeThread.start();
        } else {
            this.log("\ud83d\udda5\ufe0f Starting without console...");
            targetProcess = targetPb.start();
            if (!targetProcess.isAlive()) {
                this.log("\u274c Target process failed to start");
                throw new IOException("Target process failed to start");
            }
            this.log("\u2705 Target process started successfully with PID: " + this.getProcessId(targetProcess));
        }
        this.log("\ud83c\udf89 ProcessLauncher.launch() completed successfully!");
        this.log("\u23f0 Check the dock/taskbar now to see if the tooltip shows 'BridgeLink Administrator'");
    }

    private String getProcessId(Process process) {
        try {
            Method pidMethod = process.getClass().getMethod("pid", new Class[0]);
            return String.valueOf(pidMethod.invoke((Object)process, new Object[0]));
        }
        catch (Exception e) {
            String processString = process.toString();
            if (processString.contains("pid=")) {
                return processString.replaceAll(".*pid=(\\d+).*", "$1");
            }
            return "unknown";
        }
    }

    private void log(String message) {
    }
}

