/*
 * Decompiled with CFR 0.152.
 */
package com.innovarhealthcare.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class JavaConsoleDialog
extends JDialog {
    private JTextArea consoleTextArea;
    private JButton clearButton;
    private JButton copyButton;
    private JButton closeButton;

    public JavaConsoleDialog(Frame owner) {
        super(owner, "Java Console", false);
        this.initializeUI();
        this.setupActions();
        this.dumpJavaRuntimeConfig();
        this.setSize(400, 300);
        this.setLocation(10, 10);
    }

    private void initializeUI() {
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.consoleTextArea = new JTextArea();
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setFont(new Font("Monospaced", 0, 12));
        DefaultCaret caret = (DefaultCaret)this.consoleTextArea.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane scrollPane = new JScrollPane(this.consoleTextArea);
        mainPanel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.clearButton = new JButton("Clear");
        this.copyButton = new JButton("Copy");
        this.closeButton = new JButton("Close");
        buttonPanel.add(this.clearButton);
        buttonPanel.add(this.copyButton);
        buttonPanel.add(this.closeButton);
        mainPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(mainPanel);
    }

    private void setupActions() {
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsoleDialog.this.dumpJavaRuntimeConfig();
            }
        });
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsoleDialog.this.consoleTextArea.selectAll();
                JavaConsoleDialog.this.consoleTextArea.copy();
                JavaConsoleDialog.this.consoleTextArea.setSelectionStart(JavaConsoleDialog.this.consoleTextArea.getText().length());
                JavaConsoleDialog.this.consoleTextArea.setSelectionEnd(JavaConsoleDialog.this.consoleTextArea.getText().length());
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaConsoleDialog.this.dispose();
            }
        });
        this.consoleTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '1') {
                    JavaConsoleDialog.this.dumpJavaRuntimeConfig();
                } else if (e.getKeyChar() == 's') {
                    JavaConsoleDialog.this.dumpSystemProperties();
                }
            }
        });
    }

    private static void setupPrintLog(JTextArea textArea) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream input = System.in;){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = input.read(buffer)) != -1) {
                    String text = new String(buffer, 0, bytesRead);
                    SwingUtilities.invokeLater(() -> {
                        textArea.append(text);
                        textArea.setCaretPosition(textArea.getDocument().getLength());
                    });
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> textArea.append("Error: " + e.getMessage() + "\n"));
        }
    }

    private void dumpSystemProperties() {
        Properties props = System.getProperties();
        StringBuilder sb = new StringBuilder();
        for (Object key : new TreeSet<Object>(props.keySet())) {
            sb.append(key).append(" = ").append(props.getProperty((String)key)).append("\n");
        }
        this.consoleTextArea.append("\nSystem Properties:\n" + sb.toString());
    }

    public void appendToConsole(String text) {
        this.consoleTextArea.append(String.valueOf(text) + "\n");
    }

    private void dumpJavaRuntimeConfig() {
        String jre = "Using JRE version " + System.getProperty("java.version") + " " + System.getProperty("java.vm.name") + "\n";
        String javaHome = "Java home directory = " + System.getProperty("java.home") + "\n";
        String userHome = "User home directory = " + System.getProperty("user.home") + "\n";
        this.consoleTextArea.setText(jre);
        this.consoleTextArea.append(javaHome);
        this.consoleTextArea.append(userHome);
        this.consoleTextArea.append("----------------------------------------------------\n");
        this.consoleTextArea.append("1: Clear console window\ns: Dump system properties\n");
        this.consoleTextArea.append("----------------------------------------------------\n");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JavaConsoleDialog dialog = new JavaConsoleDialog(null);
            dialog.setVisible(true);
            new Thread(() -> JavaConsoleDialog.setupPrintLog(javaConsoleDialog.consoleTextArea)).start();
        });
    }
}

