/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json;

import com.oracle.javafx.jmx.json.ImmutableJSONDocument;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class JSONDocument
implements Iterable<JSONDocument> {
    public static final String JSON_XPATH_URI = "http://javafx.com/json/xpath";
    public static final JSONDocument EMPTY_ARRAY = new ImmutableJSONDocument(Type.ARRAY);
    public static final JSONDocument EMPTY_OBJECT = new ImmutableJSONDocument(Type.OBJECT);
    private final Type type;
    private final List<Object> array;
    private final Map<String, Object> object;

    public static JSONDocument createObject() {
        return new JSONDocument(Type.OBJECT, 0);
    }

    public static JSONDocument createArray() {
        return JSONDocument.createArray(0);
    }

    public static JSONDocument createArray(int n) {
        return new JSONDocument(Type.ARRAY, n);
    }

    public JSONDocument(Type type) {
        this(type, 0);
    }

    private JSONDocument(Type type, int n) {
        this.type = type;
        if (type == Type.ARRAY) {
            Vector<Object> vector = new Vector<Object>(n);
            vector.setSize(n);
            this.array = vector;
            this.object = null;
        } else if (type == Type.OBJECT) {
            this.array = null;
            this.object = new LinkedHashMap<String, Object>();
        } else {
            this.array = null;
            this.object = null;
            throw new IllegalArgumentException();
        }
    }

    public Type type() {
        return this.type;
    }

    public List<Object> array() {
        if (this.type != Type.ARRAY) {
            return EMPTY_ARRAY.array();
        }
        return this.array;
    }

    public Map<String, Object> object() {
        if (this.type != Type.OBJECT) {
            return EMPTY_OBJECT.object();
        }
        return this.object;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY && this.array != null;
    }

    public boolean isObject() {
        return this.type == Type.OBJECT && this.object != null;
    }

    public void toJSON(Writer writer) throws IOException {
        this.printJSON(writer, this.isArray() ? this.array() : this.object(), 0, false);
    }

    public String toJSON() {
        StringWriter stringWriter = new StringWriter(4096);
        try {
            this.printJSON(stringWriter, this.isArray() ? this.array() : this.object(), 0, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.getBuffer().toString();
    }

    private void printJSON(Writer writer, Object object, int n, boolean bl) throws IOException {
        if (object instanceof JSONDocument) {
            JSONDocument jSONDocument = (JSONDocument)object;
            if (jSONDocument.isArray()) {
                this.printArray(writer, jSONDocument.array(), n, bl);
            } else if (jSONDocument.isObject()) {
                this.printObject(writer, jSONDocument.object(), n, bl);
            } else assert (false);
        } else if (object instanceof List) {
            this.printArray(writer, (List)object, n, bl);
        } else if (object instanceof Map) {
            this.printObject(writer, (Map)object, n, bl);
        } else if (object instanceof String) {
            writer.append("\"");
            JSONDocument.printEscapedString(writer, (String)object);
            writer.append("\"");
        } else if (object != null) {
            writer.append(object.toString());
        } else {
            writer.append("null");
        }
    }

    private void printArray(Writer writer, List<Object> list, int n, boolean bl) throws IOException {
        Iterator<Object> iterator = list.iterator();
        int n2 = list.size();
        int n3 = 0;
        writer.append("[");
        if (n2 > 1) {
            this.prettyPrint(writer, ++n, bl);
        }
        while (iterator.hasNext()) {
            this.printJSON(writer, iterator.next(), n, bl);
            if (n3 < n2 - 1) {
                writer.append(",");
                this.prettyPrint(writer, n, bl);
            }
            ++n3;
        }
        if (n2 > 1) {
            this.prettyPrint(writer, --n, bl);
        }
        writer.append("]");
    }

    private void printObject(Writer writer, Map<String, Object> map, int n, boolean bl) throws IOException {
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        int n2 = map.size();
        int n3 = 0;
        writer.append("{");
        if (n2 > 1) {
            this.prettyPrint(writer, ++n, bl);
        }
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            writer.append("\"");
            writer.append(entry.getKey());
            writer.append("\":");
            Object object = entry.getValue();
            if (bl && n2 > 1) {
                int n4 = 0;
                if (object instanceof JSONDocument) {
                    JSONDocument jSONDocument = (JSONDocument)object;
                    if (jSONDocument.isArray()) {
                        n4 = jSONDocument.array().size();
                    } else if (jSONDocument.isObject()) {
                        n4 = jSONDocument.object().size();
                    } else assert (false);
                }
                if (n4 > 0) {
                    this.prettyPrint(writer, n, bl);
                }
            }
            this.printJSON(writer, object, n, bl);
            if (n3 < n2 - 1) {
                writer.append(",");
                this.prettyPrint(writer, n, bl);
            }
            ++n3;
        }
        if (n2 > 1) {
            this.prettyPrint(writer, --n, bl);
        }
        writer.append("}");
    }

    static void printEscapedString(Writer writer, String string) throws IOException {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                writer.append("\\\"");
                continue;
            }
            if (cArray[i] == '\'') {
                writer.append("'");
                continue;
            }
            if (cArray[i] == '\\') {
                writer.append("\\\\");
                continue;
            }
            if (cArray[i] == '/') {
                writer.append("\\/");
                continue;
            }
            if (cArray[i] == '\u0007') {
                writer.append("\\a");
                continue;
            }
            if (cArray[i] == '\b') {
                writer.append("\\b");
                continue;
            }
            if (cArray[i] == '\t') {
                writer.append("\\t");
                continue;
            }
            if (cArray[i] == '\n') {
                writer.append("\\n");
                continue;
            }
            if (cArray[i] == '\u000b') {
                writer.append("\\v");
                continue;
            }
            if (cArray[i] == '\f') {
                writer.append("\\f");
                continue;
            }
            if (cArray[i] == '\r') {
                writer.append("\\r");
                continue;
            }
            if (cArray[i] == '\u0000') {
                writer.append("\\0");
                continue;
            }
            if (cArray[i] > '\u007f' && cArray[i] < '\uffff') {
                writer.append("\\u");
                writer.append(String.format("%04X", cArray[i]));
                continue;
            }
            writer.append(cArray[i]);
        }
    }

    private void prettyPrint(Writer writer, int n, boolean bl) throws IOException {
        if (bl) {
            writer.append("\n");
            for (int i = 0; i < n; ++i) {
                writer.append(" ");
            }
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter(4096);
        try {
            this.printJSON(stringWriter, this.isArray() ? this.array() : this.object(), 0, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.getBuffer().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof JSONDocument) {
            JSONDocument jSONDocument = (JSONDocument)object;
            return this.isArray() ? this.array().equals(jSONDocument.array()) : (this.isObject() ? this.object().equals(jSONDocument.object()) : false);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 89 * n + (this.isArray() ? this.array().hashCode() : (this.isObject() ? this.object().hashCode() : 0));
        return n;
    }

    public JSONDocument get(String string) {
        Object object;
        if (this.object != null && (object = this.object().get(string)) instanceof JSONDocument) {
            return (JSONDocument)object;
        }
        return EMPTY_OBJECT;
    }

    public JSONDocument get(int n) {
        Object object;
        if (this.array != null && (object = this.array().get(n)) instanceof JSONDocument) {
            return (JSONDocument)object;
        }
        return EMPTY_ARRAY;
    }

    public Map<String, Object> getMap(String string) {
        Object object = this.get(string, JSONDocument.class);
        if (object instanceof JSONDocument) {
            return this.getMap((JSONDocument)object);
        }
        return EMPTY_OBJECT.object();
    }

    public Map<String, Object> getMap(int n) {
        Object object = this.get(n, JSONDocument.class);
        if (object instanceof JSONDocument) {
            return this.getMap((JSONDocument)object);
        }
        return EMPTY_OBJECT.object();
    }

    public List<Object> getList(String string) {
        Object object = this.get(string, JSONDocument.class);
        if (object instanceof JSONDocument) {
            return this.getList((JSONDocument)object);
        }
        return EMPTY_ARRAY.array();
    }

    public List<Object> getList(int n) {
        Object object = this.get(n, JSONDocument.class);
        if (object instanceof JSONDocument) {
            return this.getList((JSONDocument)object);
        }
        return EMPTY_ARRAY.array();
    }

    public String getString(String string) {
        return (String)this.get(string, String.class);
    }

    public String getString(int n) {
        return (String)this.get(n, String.class);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)this.get(string, Boolean.class);
    }

    public Boolean getBoolean(int n) {
        return (Boolean)this.get(n, Boolean.class);
    }

    public Number getNumber(String string) {
        return (Number)this.get(string, Number.class);
    }

    public Number getNumber(int n) {
        return (Number)this.get(n, Number.class);
    }

    public boolean isNull(String string) {
        if (this.object != null) {
            return null == this.object().get(string);
        }
        return false;
    }

    public boolean isNull(int n) {
        if (this.array != null) {
            return null == this.array().get(n);
        }
        return false;
    }

    private Map<String, Object> getMap(JSONDocument jSONDocument) {
        if (jSONDocument != null) {
            return jSONDocument.object();
        }
        return EMPTY_OBJECT.object();
    }

    private List<Object> getList(JSONDocument jSONDocument) {
        if (jSONDocument != null) {
            return jSONDocument.array();
        }
        return EMPTY_ARRAY.array();
    }

    private Object get(String string, Class<?> clazz) {
        Object object;
        if (this.object != null && clazz.isInstance(object = this.object().get(string))) {
            return clazz.cast(object);
        }
        return null;
    }

    private Object get(int n, Class<?> clazz) {
        Object object;
        if (this.array != null && clazz.isInstance(object = this.array().get(n))) {
            return clazz.cast(object);
        }
        return null;
    }

    public JSONDocument set(String string, JSONDocument jSONDocument) {
        return (JSONDocument)this.set(string, (Object)jSONDocument, JSONDocument.class);
    }

    public JSONDocument set(int n, JSONDocument jSONDocument) {
        return (JSONDocument)this.set(n, (Object)jSONDocument, JSONDocument.class);
    }

    public String setString(String string, String string2) {
        return (String)this.set(string, (Object)string2, String.class);
    }

    public String setString(int n, String string) {
        return (String)this.set(n, (Object)string, String.class);
    }

    public Boolean setBoolean(String string, Boolean bl) {
        return (Boolean)this.set(string, (Object)bl, Boolean.class);
    }

    public Boolean setBoolean(int n, Boolean bl) {
        return (Boolean)this.set(n, (Object)bl, Boolean.class);
    }

    public Number setNumber(String string, Number number) {
        return (Number)this.set(string, (Object)number, Number.class);
    }

    public Number setNumber(int n, Number number) {
        return (Number)this.set(n, (Object)number, Number.class);
    }

    public Object setNull(String string) {
        if (this.object != null) {
            return this.object.put(string, null);
        }
        return null;
    }

    public Object setNull(int n) {
        if (this.array != null) {
            return this.array.set(n, null);
        }
        return null;
    }

    private Object set(String string, Object object, Class<?> clazz) {
        if (this.object != null && clazz.isInstance(object)) {
            return clazz.cast(this.object().put(string, object));
        }
        return null;
    }

    private Object set(int n, Object object, Class<?> clazz) {
        if (this.array != null && clazz.isInstance(object)) {
            return clazz.cast(this.array().set(n, object));
        }
        return null;
    }

    public IteratorWrapper iterator() {
        return new IteratorWrapper(this.isObject() ? this.object().values().iterator() : this.array().iterator());
    }

    static class IteratorWrapper
    implements Iterator<JSONDocument> {
        final Iterator<Object> iterator;

        IteratorWrapper(Iterator<Object> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public JSONDocument next() {
            Object object = this.iterator.next();
            if (object instanceof JSONDocument) {
                return (JSONDocument)object;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    public static enum Type {
        ARRAY,
        OBJECT;

    }
}

