/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorCompletionService;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.RunnableFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractExecutorService
implements ExecutorService {
    protected RunnableFuture newTaskFor(Runnable runnable, Object value) {
        return new FutureTask(runnable, value);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new FutureTask(callable);
    }

    public Future submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, null);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, result);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    /*
     * Unable to fully structure code
     */
    private Object doInvokeAny(Collection tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        block18: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future>(ntasks);
            ecs = new ExecutorCompletionService(this);
            ee = null;
            lastTime = timed != false ? System.nanoTime() : 0L;
            it = tasks.iterator();
            futures.add(ecs.submit((Callable)it.next()));
            --ntasks;
            active = 1;
            while (true) lbl-1000:
            // 4 sources

            {
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit((Callable)it.next()));
                        ++active;
                    } else {
                        if (active == 0) ** break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            now = System.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now = f.get();
                    return now;
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            if (ee != null) break block18;
            ee = new ExecutionException();
        }
        throw ee;
        finally {
            f = futures.iterator();
            while (f.hasNext()) {
                ((Future)f.next()).cancel(true);
            }
        }
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<RunnableFuture> futures = new ArrayList<RunnableFuture>(tasks.size());
        boolean done = false;
        try {
            Iterator t = tasks.iterator();
            while (t.hasNext()) {
                RunnableFuture runnableFuture = this.newTaskFor((Callable)t.next());
                futures.add(runnableFuture);
                this.execute(runnableFuture);
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            done = true;
            ArrayList<RunnableFuture> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || unit == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ArrayList<RunnableFuture> futures = new ArrayList<RunnableFuture>(tasks.size());
        boolean done = false;
        try {
            Iterator t = tasks.iterator();
            while (t.hasNext()) {
                futures.add(this.newTaskFor((Callable)t.next()));
            }
            long lastTime = System.nanoTime();
            Iterator it = futures.iterator();
            while (it.hasNext()) {
                this.execute((Runnable)it.next());
                long now = System.nanoTime();
                lastTime = now;
                if ((nanos -= now - lastTime) > 0L) continue;
                ArrayList<RunnableFuture> arrayList = futures;
                return arrayList;
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                if (nanos <= 0L) {
                    ArrayList<RunnableFuture> arrayList = futures;
                    return arrayList;
                }
                try {
                    future.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {
                }
                catch (TimeoutException toe) {
                    ArrayList<RunnableFuture> arrayList = futures;
                    if (!done) {
                        for (Future future2 : futures) {
                            future2.cancel(true);
                        }
                    }
                    return arrayList;
                }
                long now = System.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
            done = true;
            ArrayList<RunnableFuture> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }
}

