/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;

public class FC
extends AbstractComposite {
    private Type[] data;

    public FC(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new DTM(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getFinancialClassCode() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public CWE getFc1_FinancialClassCode() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public DTM getEffectiveDate() {
        return (DTM)this.getTyped(1, DTM.class);
    }

    public DTM getFc2_EffectiveDate() {
        return (DTM)this.getTyped(1, DTM.class);
    }
}

