/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.BTS_O31_PRODUCT_STATUS;
import ca.uhn.hl7v2.model.v28.group.BTS_O31_TIMING;
import ca.uhn.hl7v2.model.v28.segment.BPO;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class BTS_O31_ORDER
extends AbstractGroup {
    public BTS_O31_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(BTS_O31_TIMING.class, false, true, false);
            this.add(BPO.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(BTS_O31_PRODUCT_STATUS.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BTS_O31_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public BTS_O31_TIMING getTIMING() {
        BTS_O31_TIMING retVal = (BTS_O31_TIMING)this.getTyped("TIMING", BTS_O31_TIMING.class);
        return retVal;
    }

    public BTS_O31_TIMING getTIMING(int rep) {
        BTS_O31_TIMING retVal = (BTS_O31_TIMING)this.getTyped("TIMING", rep, BTS_O31_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<BTS_O31_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", BTS_O31_TIMING.class);
    }

    public void insertTIMING(BTS_O31_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public BTS_O31_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BTS_O31_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BTS_O31_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BTS_O31_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO retVal = (BPO)this.getTyped("BPO", BPO.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public BTS_O31_PRODUCT_STATUS getPRODUCT_STATUS() {
        BTS_O31_PRODUCT_STATUS retVal = (BTS_O31_PRODUCT_STATUS)this.getTyped("PRODUCT_STATUS", BTS_O31_PRODUCT_STATUS.class);
        return retVal;
    }

    public BTS_O31_PRODUCT_STATUS getPRODUCT_STATUS(int rep) {
        BTS_O31_PRODUCT_STATUS retVal = (BTS_O31_PRODUCT_STATUS)this.getTyped("PRODUCT_STATUS", rep, BTS_O31_PRODUCT_STATUS.class);
        return retVal;
    }

    public int getPRODUCT_STATUSReps() {
        return this.getReps("PRODUCT_STATUS");
    }

    public List<BTS_O31_PRODUCT_STATUS> getPRODUCT_STATUSAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT_STATUS", BTS_O31_PRODUCT_STATUS.class);
    }

    public void insertPRODUCT_STATUS(BTS_O31_PRODUCT_STATUS structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_STATUS", (Structure)structure, rep);
    }

    public BTS_O31_PRODUCT_STATUS insertPRODUCT_STATUS(int rep) throws HL7Exception {
        return (BTS_O31_PRODUCT_STATUS)super.insertRepetition("PRODUCT_STATUS", rep);
    }

    public BTS_O31_PRODUCT_STATUS removePRODUCT_STATUS(int rep) throws HL7Exception {
        return (BTS_O31_PRODUCT_STATUS)super.removeRepetition("PRODUCT_STATUS", rep);
    }
}

