/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_ROLE_GOAL;
import ca.uhn.hl7v2.model.v28.segment.GOL;
import ca.uhn.hl7v2.model.v28.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCI_I22_GOAL
extends AbstractGroup {
    public CCI_I22_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CCI_I22_ROLE_GOAL.class, false, true, false);
            this.add(CCI_I22_GOAL_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCI_I22_GOAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public GOL getGOL() {
        GOL retVal = (GOL)this.getTyped("GOL", GOL.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CCI_I22_ROLE_GOAL getROLE_GOAL() {
        CCI_I22_ROLE_GOAL retVal = (CCI_I22_ROLE_GOAL)this.getTyped("ROLE_GOAL", CCI_I22_ROLE_GOAL.class);
        return retVal;
    }

    public CCI_I22_ROLE_GOAL getROLE_GOAL(int rep) {
        CCI_I22_ROLE_GOAL retVal = (CCI_I22_ROLE_GOAL)this.getTyped("ROLE_GOAL", rep, CCI_I22_ROLE_GOAL.class);
        return retVal;
    }

    public int getROLE_GOALReps() {
        return this.getReps("ROLE_GOAL");
    }

    public List<CCI_I22_ROLE_GOAL> getROLE_GOALAll() throws HL7Exception {
        return this.getAllAsList("ROLE_GOAL", CCI_I22_ROLE_GOAL.class);
    }

    public void insertROLE_GOAL(CCI_I22_ROLE_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_GOAL", (Structure)structure, rep);
    }

    public CCI_I22_ROLE_GOAL insertROLE_GOAL(int rep) throws HL7Exception {
        return (CCI_I22_ROLE_GOAL)super.insertRepetition("ROLE_GOAL", rep);
    }

    public CCI_I22_ROLE_GOAL removeROLE_GOAL(int rep) throws HL7Exception {
        return (CCI_I22_ROLE_GOAL)super.removeRepetition("ROLE_GOAL", rep);
    }

    public CCI_I22_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        CCI_I22_GOAL_OBSERVATION retVal = (CCI_I22_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", CCI_I22_GOAL_OBSERVATION.class);
        return retVal;
    }

    public CCI_I22_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        CCI_I22_GOAL_OBSERVATION retVal = (CCI_I22_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", rep, CCI_I22_GOAL_OBSERVATION.class);
        return retVal;
    }

    public int getGOAL_OBSERVATIONReps() {
        return this.getReps("GOAL_OBSERVATION");
    }

    public List<CCI_I22_GOAL_OBSERVATION> getGOAL_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("GOAL_OBSERVATION", CCI_I22_GOAL_OBSERVATION.class);
    }

    public void insertGOAL_OBSERVATION(CCI_I22_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", (Structure)structure, rep);
    }

    public CCI_I22_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (CCI_I22_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public CCI_I22_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (CCI_I22_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }
}

