/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_APPOINTMENT_HISTORY;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_CLINICAL_HISTORY;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_GOAL;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_INSURANCE;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_MEDICATION_HISTORY;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_PATHWAY;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_PATIENT_VISITS;
import ca.uhn.hl7v2.model.v28.group.CCI_I22_PROBLEM;
import ca.uhn.hl7v2.model.v28.segment.ERR;
import ca.uhn.hl7v2.model.v28.segment.MSA;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.NK1;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.REL;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCI_I22
extends AbstractMessage {
    public CCI_I22() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public CCI_I22(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(CCI_I22_INSURANCE.class, false, true);
            this.add(CCI_I22_APPOINTMENT_HISTORY.class, false, true);
            this.add(CCI_I22_CLINICAL_HISTORY.class, false, true);
            this.add(CCI_I22_PATIENT_VISITS.class, true, true);
            this.add(CCI_I22_MEDICATION_HISTORY.class, false, true);
            this.add(CCI_I22_PROBLEM.class, false, true);
            this.add(CCI_I22_GOAL.class, false, true);
            this.add(CCI_I22_PATHWAY.class, false, true);
            this.add(REL.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCI_I22 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public CCI_I22_INSURANCE getINSURANCE() {
        return (CCI_I22_INSURANCE)this.getTyped("INSURANCE", CCI_I22_INSURANCE.class);
    }

    public CCI_I22_INSURANCE getINSURANCE(int rep) {
        return (CCI_I22_INSURANCE)this.getTyped("INSURANCE", rep, CCI_I22_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<CCI_I22_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", CCI_I22_INSURANCE.class);
    }

    public void insertINSURANCE(CCI_I22_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public CCI_I22_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (CCI_I22_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public CCI_I22_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (CCI_I22_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public CCI_I22_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY() {
        return (CCI_I22_APPOINTMENT_HISTORY)this.getTyped("APPOINTMENT_HISTORY", CCI_I22_APPOINTMENT_HISTORY.class);
    }

    public CCI_I22_APPOINTMENT_HISTORY getAPPOINTMENT_HISTORY(int rep) {
        return (CCI_I22_APPOINTMENT_HISTORY)this.getTyped("APPOINTMENT_HISTORY", rep, CCI_I22_APPOINTMENT_HISTORY.class);
    }

    public int getAPPOINTMENT_HISTORYReps() {
        return this.getReps("APPOINTMENT_HISTORY");
    }

    public List<CCI_I22_APPOINTMENT_HISTORY> getAPPOINTMENT_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("APPOINTMENT_HISTORY", CCI_I22_APPOINTMENT_HISTORY.class);
    }

    public void insertAPPOINTMENT_HISTORY(CCI_I22_APPOINTMENT_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("APPOINTMENT_HISTORY", (Structure)structure, rep);
    }

    public CCI_I22_APPOINTMENT_HISTORY insertAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CCI_I22_APPOINTMENT_HISTORY)super.insertRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CCI_I22_APPOINTMENT_HISTORY removeAPPOINTMENT_HISTORY(int rep) throws HL7Exception {
        return (CCI_I22_APPOINTMENT_HISTORY)super.removeRepetition("APPOINTMENT_HISTORY", rep);
    }

    public CCI_I22_CLINICAL_HISTORY getCLINICAL_HISTORY() {
        return (CCI_I22_CLINICAL_HISTORY)this.getTyped("CLINICAL_HISTORY", CCI_I22_CLINICAL_HISTORY.class);
    }

    public CCI_I22_CLINICAL_HISTORY getCLINICAL_HISTORY(int rep) {
        return (CCI_I22_CLINICAL_HISTORY)this.getTyped("CLINICAL_HISTORY", rep, CCI_I22_CLINICAL_HISTORY.class);
    }

    public int getCLINICAL_HISTORYReps() {
        return this.getReps("CLINICAL_HISTORY");
    }

    public List<CCI_I22_CLINICAL_HISTORY> getCLINICAL_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("CLINICAL_HISTORY", CCI_I22_CLINICAL_HISTORY.class);
    }

    public void insertCLINICAL_HISTORY(CCI_I22_CLINICAL_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("CLINICAL_HISTORY", (Structure)structure, rep);
    }

    public CCI_I22_CLINICAL_HISTORY insertCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CCI_I22_CLINICAL_HISTORY)super.insertRepetition("CLINICAL_HISTORY", rep);
    }

    public CCI_I22_CLINICAL_HISTORY removeCLINICAL_HISTORY(int rep) throws HL7Exception {
        return (CCI_I22_CLINICAL_HISTORY)super.removeRepetition("CLINICAL_HISTORY", rep);
    }

    public CCI_I22_PATIENT_VISITS getPATIENT_VISITS() {
        return (CCI_I22_PATIENT_VISITS)this.getTyped("PATIENT_VISITS", CCI_I22_PATIENT_VISITS.class);
    }

    public CCI_I22_PATIENT_VISITS getPATIENT_VISITS(int rep) {
        return (CCI_I22_PATIENT_VISITS)this.getTyped("PATIENT_VISITS", rep, CCI_I22_PATIENT_VISITS.class);
    }

    public int getPATIENT_VISITSReps() {
        return this.getReps("PATIENT_VISITS");
    }

    public List<CCI_I22_PATIENT_VISITS> getPATIENT_VISITSAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_VISITS", CCI_I22_PATIENT_VISITS.class);
    }

    public void insertPATIENT_VISITS(CCI_I22_PATIENT_VISITS structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_VISITS", (Structure)structure, rep);
    }

    public CCI_I22_PATIENT_VISITS insertPATIENT_VISITS(int rep) throws HL7Exception {
        return (CCI_I22_PATIENT_VISITS)super.insertRepetition("PATIENT_VISITS", rep);
    }

    public CCI_I22_PATIENT_VISITS removePATIENT_VISITS(int rep) throws HL7Exception {
        return (CCI_I22_PATIENT_VISITS)super.removeRepetition("PATIENT_VISITS", rep);
    }

    public CCI_I22_MEDICATION_HISTORY getMEDICATION_HISTORY() {
        return (CCI_I22_MEDICATION_HISTORY)this.getTyped("MEDICATION_HISTORY", CCI_I22_MEDICATION_HISTORY.class);
    }

    public CCI_I22_MEDICATION_HISTORY getMEDICATION_HISTORY(int rep) {
        return (CCI_I22_MEDICATION_HISTORY)this.getTyped("MEDICATION_HISTORY", rep, CCI_I22_MEDICATION_HISTORY.class);
    }

    public int getMEDICATION_HISTORYReps() {
        return this.getReps("MEDICATION_HISTORY");
    }

    public List<CCI_I22_MEDICATION_HISTORY> getMEDICATION_HISTORYAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_HISTORY", CCI_I22_MEDICATION_HISTORY.class);
    }

    public void insertMEDICATION_HISTORY(CCI_I22_MEDICATION_HISTORY structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_HISTORY", (Structure)structure, rep);
    }

    public CCI_I22_MEDICATION_HISTORY insertMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CCI_I22_MEDICATION_HISTORY)super.insertRepetition("MEDICATION_HISTORY", rep);
    }

    public CCI_I22_MEDICATION_HISTORY removeMEDICATION_HISTORY(int rep) throws HL7Exception {
        return (CCI_I22_MEDICATION_HISTORY)super.removeRepetition("MEDICATION_HISTORY", rep);
    }

    public CCI_I22_PROBLEM getPROBLEM() {
        return (CCI_I22_PROBLEM)this.getTyped("PROBLEM", CCI_I22_PROBLEM.class);
    }

    public CCI_I22_PROBLEM getPROBLEM(int rep) {
        return (CCI_I22_PROBLEM)this.getTyped("PROBLEM", rep, CCI_I22_PROBLEM.class);
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<CCI_I22_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", CCI_I22_PROBLEM.class);
    }

    public void insertPROBLEM(CCI_I22_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public CCI_I22_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (CCI_I22_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public CCI_I22_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (CCI_I22_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public CCI_I22_GOAL getGOAL() {
        return (CCI_I22_GOAL)this.getTyped("GOAL", CCI_I22_GOAL.class);
    }

    public CCI_I22_GOAL getGOAL(int rep) {
        return (CCI_I22_GOAL)this.getTyped("GOAL", rep, CCI_I22_GOAL.class);
    }

    public int getGOALReps() {
        return this.getReps("GOAL");
    }

    public List<CCI_I22_GOAL> getGOALAll() throws HL7Exception {
        return this.getAllAsList("GOAL", CCI_I22_GOAL.class);
    }

    public void insertGOAL(CCI_I22_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", (Structure)structure, rep);
    }

    public CCI_I22_GOAL insertGOAL(int rep) throws HL7Exception {
        return (CCI_I22_GOAL)super.insertRepetition("GOAL", rep);
    }

    public CCI_I22_GOAL removeGOAL(int rep) throws HL7Exception {
        return (CCI_I22_GOAL)super.removeRepetition("GOAL", rep);
    }

    public CCI_I22_PATHWAY getPATHWAY() {
        return (CCI_I22_PATHWAY)this.getTyped("PATHWAY", CCI_I22_PATHWAY.class);
    }

    public CCI_I22_PATHWAY getPATHWAY(int rep) {
        return (CCI_I22_PATHWAY)this.getTyped("PATHWAY", rep, CCI_I22_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<CCI_I22_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", CCI_I22_PATHWAY.class);
    }

    public void insertPATHWAY(CCI_I22_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public CCI_I22_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (CCI_I22_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public CCI_I22_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (CCI_I22_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }

    public REL getREL() {
        return (REL)this.getTyped("REL", REL.class);
    }

    public REL getREL(int rep) {
        return (REL)this.getTyped("REL", rep, REL.class);
    }

    public int getRELReps() {
        return this.getReps("REL");
    }

    public List<REL> getRELAll() throws HL7Exception {
        return this.getAllAsList("REL", REL.class);
    }

    public void insertREL(REL structure, int rep) throws HL7Exception {
        super.insertRepetition("REL", (Structure)structure, rep);
    }

    public REL insertREL(int rep) throws HL7Exception {
        return (REL)super.insertRepetition("REL", rep);
    }

    public REL removeREL(int rep) throws HL7Exception {
        return (REL)super.removeRepetition("REL", rep);
    }
}

