/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CQ;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM4
extends AbstractSegment {
    public OM4(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(170)}, "Derived Specimen");
            this.add(TX.class, false, 0, 60, new Object[]{this.getMessage()}, "Container Description");
            this.add(NM.class, false, 0, 0, new Object[]{this.getMessage()}, "Container Volume");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Container Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Additive");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Preparation");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Special Handling Requirements");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Normal Collection Volume");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Minimum Collection Volume");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Requirements");
            this.add(ID.class, false, 0, 1, new Object[]{this.getMessage(), new Integer(27)}, "Specimen Priorities");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Specimen Retention Time");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specimen Handling Code");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(920)}, "Specimen Preference");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Preferred Specimen/Attribture Sequence ID");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Taxonomic Classification Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM4 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm41_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getDerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getOm42_DerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public TX[] getContainerDescription() {
        TX[] retVal = (TX[])this.getTypedField(3, (Type[])new TX[0]);
        return retVal;
    }

    public TX[] getOm43_ContainerDescription() {
        TX[] retVal = (TX[])this.getTypedField(3, (Type[])new TX[0]);
        return retVal;
    }

    public int getContainerDescriptionReps() {
        return this.getReps(3);
    }

    public TX getContainerDescription(int rep) {
        TX retVal = (TX)this.getTypedField(3, rep);
        return retVal;
    }

    public TX getOm43_ContainerDescription(int rep) {
        TX retVal = (TX)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm43_ContainerDescriptionReps() {
        return this.getReps(3);
    }

    public TX insertContainerDescription(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(3, rep);
    }

    public TX insertOm43_ContainerDescription(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(3, rep);
    }

    public TX removeContainerDescription(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(3, rep);
    }

    public TX removeOm43_ContainerDescription(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(3, rep);
    }

    public NM[] getContainerVolume() {
        NM[] retVal = (NM[])this.getTypedField(4, (Type[])new NM[0]);
        return retVal;
    }

    public NM[] getOm44_ContainerVolume() {
        NM[] retVal = (NM[])this.getTypedField(4, (Type[])new NM[0]);
        return retVal;
    }

    public int getContainerVolumeReps() {
        return this.getReps(4);
    }

    public NM getContainerVolume(int rep) {
        NM retVal = (NM)this.getTypedField(4, rep);
        return retVal;
    }

    public NM getOm44_ContainerVolume(int rep) {
        NM retVal = (NM)this.getTypedField(4, rep);
        return retVal;
    }

    public int getOm44_ContainerVolumeReps() {
        return this.getReps(4);
    }

    public NM insertContainerVolume(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(4, rep);
    }

    public NM insertOm44_ContainerVolume(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(4, rep);
    }

    public NM removeContainerVolume(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(4, rep);
    }

    public NM removeOm44_ContainerVolume(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(4, rep);
    }

    public CWE[] getContainerUnits() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getOm45_ContainerUnits() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public int getContainerUnitsReps() {
        return this.getReps(5);
    }

    public CWE getContainerUnits(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public CWE getOm45_ContainerUnits(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getOm45_ContainerUnitsReps() {
        return this.getReps(5);
    }

    public CWE insertContainerUnits(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE insertOm45_ContainerUnits(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE removeContainerUnits(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE removeOm45_ContainerUnits(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE getSpecimen() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getOm46_Specimen() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getAdditive() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getOm47_Additive() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public TX getPreparation() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getOm48_Preparation() {
        TX retVal = (TX)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getSpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public TX getOm49_SpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public CQ getNormalCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ getOm410_NormalCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ getMinimumCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getOm411_MinimumCollectionVolume() {
        CQ retVal = (CQ)this.getTypedField(11, 0);
        return retVal;
    }

    public TX getSpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(12, 0);
        return retVal;
    }

    public TX getOm412_SpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(12, 0);
        return retVal;
    }

    public ID[] getSpecimenPriorities() {
        ID[] retVal = (ID[])this.getTypedField(13, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getOm413_SpecimenPriorities() {
        ID[] retVal = (ID[])this.getTypedField(13, (Type[])new ID[0]);
        return retVal;
    }

    public int getSpecimenPrioritiesReps() {
        return this.getReps(13);
    }

    public ID getSpecimenPriorities(int rep) {
        ID retVal = (ID)this.getTypedField(13, rep);
        return retVal;
    }

    public ID getOm413_SpecimenPriorities(int rep) {
        ID retVal = (ID)this.getTypedField(13, rep);
        return retVal;
    }

    public int getOm413_SpecimenPrioritiesReps() {
        return this.getReps(13);
    }

    public ID insertSpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(13, rep);
    }

    public ID insertOm413_SpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(13, rep);
    }

    public ID removeSpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(13, rep);
    }

    public ID removeOm413_SpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(13, rep);
    }

    public CQ getSpecimenRetentionTime() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    public CQ getOm414_SpecimenRetentionTime() {
        CQ retVal = (CQ)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE[] getSpecimenHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getOm415_SpecimenHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecimenHandlingCodeReps() {
        return this.getReps(15);
    }

    public CWE getSpecimenHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public CWE getOm415_SpecimenHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getOm415_SpecimenHandlingCodeReps() {
        return this.getReps(15);
    }

    public CWE insertSpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertOm415_SpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeSpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removeOm415_SpecimenHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public ID getSpecimenPreference() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getOm416_SpecimenPreference() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getPreferredSpecimenAttribtureSequenceID() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getOm417_PreferredSpecimenAttribtureSequenceID() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE[] getTaxonomicClassificationCode() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getOm418_TaxonomicClassificationCode() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public int getTaxonomicClassificationCodeReps() {
        return this.getReps(18);
    }

    public CWE getTaxonomicClassificationCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getOm418_TaxonomicClassificationCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getOm418_TaxonomicClassificationCodeReps() {
        return this.getReps(18);
    }

    public CWE insertTaxonomicClassificationCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertOm418_TaxonomicClassificationCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeTaxonomicClassificationCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removeOm418_TaxonomicClassificationCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(170));
            }
            case 2: {
                return new TX(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new TX(this.getMessage());
            }
            case 8: {
                return new TX(this.getMessage());
            }
            case 9: {
                return new CQ(this.getMessage());
            }
            case 10: {
                return new CQ(this.getMessage());
            }
            case 11: {
                return new TX(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(27));
            }
            case 13: {
                return new CQ(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(920));
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

