/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CQ;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DTM;
import ca.uhn.hl7v2.model.v28.datatype.ID;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.NULLDT;
import ca.uhn.hl7v2.model.v28.datatype.PL;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.XAD;
import ca.uhn.hl7v2.model.v28.datatype.XCN;
import ca.uhn.hl7v2.model.v28.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXE
extends AbstractSegment {
    public RXE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Quantity/Timing");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Give Code");
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Give Amount - Minimum");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Amount - Maximum");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Give Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Dosage Form");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Provider's Administration Instructions");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Deliver-To Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Units");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number Of Refills");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Ordering Provider's DEA Number");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Pharmacist/Treatment Supplier's Verifier ID");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Prescription Number");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Refills Remaining");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Refills/Doses Dispensed");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "D/T of Most Recent Refill or Dose Dispensed");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Daily Dose");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Special Dispensing Instructions");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Per (Time Unit)");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Rate Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Rate Units");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Strength");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Strength Units");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Give Indication");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Package Size");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Package Size Unit");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(321)}, "Dispense Package Method");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Supplementary Code");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Original Order Date/Time");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Drug Strength Volume");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Give Drug Strength Volume Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Controlled Substance Schedule");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(478)}, "Formulary Status");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Pharmaceutical Substance Alternative");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Pharmacy of Most Recent Fill");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Initial Dispense Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispensing Pharmacy");
            this.add(XAD.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispensing Pharmacy Address");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Deliver-to Patient Location");
            this.add(XAD.class, false, 1, 0, new Object[]{this.getMessage()}, "Deliver-to Address");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(480)}, "Pharmacy Order Type");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Pharmacy Phone Number");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NULLDT getQuantityTiming() {
        NULLDT retVal = (NULLDT)this.getTypedField(1, 0);
        return retVal;
    }

    public NULLDT getRxe1_QuantityTiming() {
        NULLDT retVal = (NULLDT)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getGiveCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRxe2_GiveCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getRxe3_GiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRxe4_GiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getGiveUnits() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRxe5_GiveUnits() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getGiveDosageForm() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getRxe6_GiveDosageForm() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE[] getProviderSAdministrationInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxe7_ProviderSAdministrationInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public int getProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CWE getProviderSAdministrationInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public CWE getRxe7_ProviderSAdministrationInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getRxe7_ProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CWE insertProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE insertRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE removeProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE removeRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public NULLDT getDeliverToLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(8, 0);
        return retVal;
    }

    public NULLDT getRxe8_DeliverToLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getRxe9_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getDispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getRxe10_DispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getDispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getRxe11_DispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getNumberOfRefills() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getRxe12_NumberOfRefills() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public XCN[] getOrderingProviderSDEANumber() {
        XCN[] retVal = (XCN[])this.getTypedField(13, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getRxe13_OrderingProviderSDEANumber() {
        XCN[] retVal = (XCN[])this.getTypedField(13, (Type[])new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderSDEANumberReps() {
        return this.getReps(13);
    }

    public XCN getOrderingProviderSDEANumber(int rep) {
        XCN retVal = (XCN)this.getTypedField(13, rep);
        return retVal;
    }

    public XCN getRxe13_OrderingProviderSDEANumber(int rep) {
        XCN retVal = (XCN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getRxe13_OrderingProviderSDEANumberReps() {
        return this.getReps(13);
    }

    public XCN insertOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN insertRxe13_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN removeOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public XCN removeRxe13_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public XCN[] getPharmacistTreatmentSupplierSVerifierID() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getRxe14_PharmacistTreatmentSupplierSVerifierID() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public int getPharmacistTreatmentSupplierSVerifierIDReps() {
        return this.getReps(14);
    }

    public XCN getPharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public XCN getRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getRxe14_PharmacistTreatmentSupplierSVerifierIDReps() {
        return this.getReps(14);
    }

    public XCN insertPharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN insertRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN removePharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public XCN removeRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public ST getPrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getRxe15_PrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getNumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getRxe16_NumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getNumberOfRefillsDosesDispensed() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getRxe17_NumberOfRefillsDosesDispensed() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public DTM getDTOfMostRecentRefillOrDoseDispensed() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getRxe18_DTOfMostRecentRefillOrDoseDispensed() {
        DTM retVal = (DTM)this.getTypedField(18, 0);
        return retVal;
    }

    public CQ getTotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public CQ getRxe19_TotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getRxe20_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE[] getSpecialDispensingInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(21, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxe21_SpecialDispensingInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(21, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecialDispensingInstructionsReps() {
        return this.getReps(21);
    }

    public CWE getSpecialDispensingInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public CWE getRxe21_SpecialDispensingInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public int getRxe21_SpecialDispensingInstructionsReps() {
        return this.getReps(21);
    }

    public CWE insertSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE insertRxe21_SpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE removeSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public CWE removeRxe21_SpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public ST getGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getRxe22_GivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getRxe23_GiveRateAmount() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getGiveRateUnits() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE getRxe24_GiveRateUnits() {
        CWE retVal = (CWE)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getGiveStrength() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getRxe25_GiveStrength() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getGiveStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getRxe26_GiveStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE[] getGiveIndication() {
        CWE[] retVal = (CWE[])this.getTypedField(27, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxe27_GiveIndication() {
        CWE[] retVal = (CWE[])this.getTypedField(27, (Type[])new CWE[0]);
        return retVal;
    }

    public int getGiveIndicationReps() {
        return this.getReps(27);
    }

    public CWE getGiveIndication(int rep) {
        CWE retVal = (CWE)this.getTypedField(27, rep);
        return retVal;
    }

    public CWE getRxe27_GiveIndication(int rep) {
        CWE retVal = (CWE)this.getTypedField(27, rep);
        return retVal;
    }

    public int getRxe27_GiveIndicationReps() {
        return this.getReps(27);
    }

    public CWE insertGiveIndication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(27, rep);
    }

    public CWE insertRxe27_GiveIndication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(27, rep);
    }

    public CWE removeGiveIndication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(27, rep);
    }

    public CWE removeRxe27_GiveIndication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(27, rep);
    }

    public NM getDispensePackageSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public NM getRxe28_DispensePackageSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getDispensePackageSizeUnit() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getRxe29_DispensePackageSizeUnit() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public ID getDispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getRxe30_DispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE[] getSupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(31, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxe31_SupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(31, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSupplementaryCodeReps() {
        return this.getReps(31);
    }

    public CWE getSupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(31, rep);
        return retVal;
    }

    public CWE getRxe31_SupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(31, rep);
        return retVal;
    }

    public int getRxe31_SupplementaryCodeReps() {
        return this.getReps(31);
    }

    public CWE insertSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(31, rep);
    }

    public CWE insertRxe31_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(31, rep);
    }

    public CWE removeSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(31, rep);
    }

    public CWE removeRxe31_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(31, rep);
    }

    public DTM getOriginalOrderDateTime() {
        DTM retVal = (DTM)this.getTypedField(32, 0);
        return retVal;
    }

    public DTM getRxe32_OriginalOrderDateTime() {
        DTM retVal = (DTM)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getGiveDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getRxe33_GiveDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE getGiveDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(34, 0);
        return retVal;
    }

    public CWE getRxe34_GiveDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(34, 0);
        return retVal;
    }

    public CWE getControlledSubstanceSchedule() {
        CWE retVal = (CWE)this.getTypedField(35, 0);
        return retVal;
    }

    public CWE getRxe35_ControlledSubstanceSchedule() {
        CWE retVal = (CWE)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getFormularyStatus() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public ID getRxe36_FormularyStatus() {
        ID retVal = (ID)this.getTypedField(36, 0);
        return retVal;
    }

    public CWE[] getPharmaceuticalSubstanceAlternative() {
        CWE[] retVal = (CWE[])this.getTypedField(37, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxe37_PharmaceuticalSubstanceAlternative() {
        CWE[] retVal = (CWE[])this.getTypedField(37, (Type[])new CWE[0]);
        return retVal;
    }

    public int getPharmaceuticalSubstanceAlternativeReps() {
        return this.getReps(37);
    }

    public CWE getPharmaceuticalSubstanceAlternative(int rep) {
        CWE retVal = (CWE)this.getTypedField(37, rep);
        return retVal;
    }

    public CWE getRxe37_PharmaceuticalSubstanceAlternative(int rep) {
        CWE retVal = (CWE)this.getTypedField(37, rep);
        return retVal;
    }

    public int getRxe37_PharmaceuticalSubstanceAlternativeReps() {
        return this.getReps(37);
    }

    public CWE insertPharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(37, rep);
    }

    public CWE insertRxe37_PharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(37, rep);
    }

    public CWE removePharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(37, rep);
    }

    public CWE removeRxe37_PharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(37, rep);
    }

    public CWE getPharmacyOfMostRecentFill() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public CWE getRxe38_PharmacyOfMostRecentFill() {
        CWE retVal = (CWE)this.getTypedField(38, 0);
        return retVal;
    }

    public NM getInitialDispenseAmount() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public NM getRxe39_InitialDispenseAmount() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public CWE getDispensingPharmacy() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public CWE getRxe40_DispensingPharmacy() {
        CWE retVal = (CWE)this.getTypedField(40, 0);
        return retVal;
    }

    public XAD getDispensingPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(41, 0);
        return retVal;
    }

    public XAD getRxe41_DispensingPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(41, 0);
        return retVal;
    }

    public PL getDeliverToPatientLocation() {
        PL retVal = (PL)this.getTypedField(42, 0);
        return retVal;
    }

    public PL getRxe42_DeliverToPatientLocation() {
        PL retVal = (PL)this.getTypedField(42, 0);
        return retVal;
    }

    public XAD getDeliverToAddress() {
        XAD retVal = (XAD)this.getTypedField(43, 0);
        return retVal;
    }

    public XAD getRxe43_DeliverToAddress() {
        XAD retVal = (XAD)this.getTypedField(43, 0);
        return retVal;
    }

    public ID getPharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(44, 0);
        return retVal;
    }

    public ID getRxe44_PharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(44, 0);
        return retVal;
    }

    public XTN[] getPharmacyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(45, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getRxe45_PharmacyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(45, (Type[])new XTN[0]);
        return retVal;
    }

    public int getPharmacyPhoneNumberReps() {
        return this.getReps(45);
    }

    public XTN getPharmacyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(45, rep);
        return retVal;
    }

    public XTN getRxe45_PharmacyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(45, rep);
        return retVal;
    }

    public int getRxe45_PharmacyPhoneNumberReps() {
        return this.getReps(45);
    }

    public XTN insertPharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(45, rep);
    }

    public XTN insertRxe45_PharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(45, rep);
    }

    public XTN removePharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(45, rep);
    }

    public XTN removeRxe45_PharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(45, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NULLDT(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new NULLDT(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new XCN(this.getMessage());
            }
            case 13: {
                return new XCN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new NM(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new DTM(this.getMessage());
            }
            case 18: {
                return new CQ(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(321));
            }
            case 30: {
                return new CWE(this.getMessage());
            }
            case 31: {
                return new DTM(this.getMessage());
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new CWE(this.getMessage());
            }
            case 34: {
                return new CWE(this.getMessage());
            }
            case 35: {
                return new ID(this.getMessage(), new Integer(478));
            }
            case 36: {
                return new CWE(this.getMessage());
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new NM(this.getMessage());
            }
            case 39: {
                return new CWE(this.getMessage());
            }
            case 40: {
                return new XAD(this.getMessage());
            }
            case 41: {
                return new PL(this.getMessage());
            }
            case 42: {
                return new XAD(this.getMessage());
            }
            case 43: {
                return new ID(this.getMessage(), new Integer(480));
            }
            case 44: {
                return new XTN(this.getMessage());
            }
        }
        return null;
    }
}

