/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.mllpmode;

import com.mirth.connect.donkey.server.message.batch.BatchStreamReader;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameStreamHandler;
import com.mirth.connect.plugins.mllpmode.MLLPModeProperties;
import com.mirth.connect.plugins.mllpmode.MLLPv2StreamHandlerException;
import com.mirth.connect.util.TcpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;

public class MLLPv2StreamHandler
extends FrameStreamHandler {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private byte[] ackBytes;
    private byte[] nackBytes;
    private int maxRetries;
    private boolean committed;

    public MLLPv2StreamHandler(InputStream inputStream, OutputStream outputStream, BatchStreamReader batchStreamReader, TransmissionModeProperties transmissionModeProperties) {
        super(inputStream, outputStream, batchStreamReader, transmissionModeProperties);
        MLLPModeProperties props = (MLLPModeProperties)transmissionModeProperties;
        this.ackBytes = TcpUtil.stringToByteArray((String)props.getAckBytes());
        this.nackBytes = TcpUtil.stringToByteArray((String)props.getNackBytes());
        this.maxRetries = NumberUtils.toInt((String)props.getMaxRetries());
        this.committed = false;
    }

    public void commit(boolean success) throws IOException {
        if (!this.committed) {
            super.write(success ? this.ackBytes : this.nackBytes);
            this.committed = true;
        }
    }

    public void write(byte[] data) throws IOException {
        boolean done = false;
        IOException firstCause = null;
        int retryCount = 0;
        while (!done) {
            super.write(data);
            try {
                byte[] response = super.read();
                this.reset();
                if (response == null) {
                    response = super.read();
                }
                if (Arrays.areEqual((byte[])response, (byte[])this.ackBytes)) {
                    done = true;
                    continue;
                }
                if (Arrays.areEqual((byte[])response, (byte[])this.nackBytes)) {
                    throw new MLLPv2StreamHandlerException("Negative commit acknowledgement received.");
                }
                throw new MLLPv2StreamHandlerException("Invalid acknowledgement block received.");
            }
            catch (IOException e) {
                if (firstCause == null) {
                    firstCause = e;
                }
                if (this.maxRetries <= 0 || retryCount++ != this.maxRetries) continue;
                throw new MLLPv2StreamHandlerException("Maximum retry count reached. First cause: " + firstCause.getMessage(), firstCause);
            }
        }
    }
}

