/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.util.Raw;
import net.lingala.zip4j.util.Zip4jUtil;

public class SplitOutputStream
extends OutputStream {
    private RandomAccessFile raf;
    private long splitLength;
    private File zipFile;
    private File outFile;
    private int currSplitFileCounter;
    private long bytesWrittenForThisPart;

    public SplitOutputStream(String string) throws FileNotFoundException, ZipException {
        this(Zip4jUtil.isStringNotNullAndNotEmpty(string) ? new File(string) : null);
    }

    public SplitOutputStream(File file) throws FileNotFoundException, ZipException {
        this(file, -1L);
    }

    public SplitOutputStream(String string, long l) throws FileNotFoundException, ZipException {
        this(!Zip4jUtil.isStringNotNullAndNotEmpty(string) ? new File(string) : null, l);
    }

    public SplitOutputStream(File file, long l) throws FileNotFoundException, ZipException {
        if (l >= 0L && l < 65536L) {
            throw new ZipException("split length less than minimum allowed split length of 65536 Bytes");
        }
        this.raf = new RandomAccessFile(file, "rw");
        this.splitLength = l;
        this.outFile = file;
        this.zipFile = file;
        this.currSplitFileCounter = 0;
        this.bytesWrittenForThisPart = 0L;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.splitLength != -1L) {
            if (this.splitLength < 65536L) {
                throw new IOException("split length less than minimum allowed split length of 65536 Bytes");
            }
            if (this.bytesWrittenForThisPart >= this.splitLength) {
                this.startNextSplitFile();
                this.raf.write(byArray, n, n2);
                this.bytesWrittenForThisPart = n2;
            } else if (this.bytesWrittenForThisPart + (long)n2 > this.splitLength) {
                if (this.isHeaderData(byArray)) {
                    this.startNextSplitFile();
                    this.raf.write(byArray, n, n2);
                    this.bytesWrittenForThisPart = n2;
                } else {
                    this.raf.write(byArray, n, (int)(this.splitLength - this.bytesWrittenForThisPart));
                    this.startNextSplitFile();
                    this.raf.write(byArray, n + (int)(this.splitLength - this.bytesWrittenForThisPart), (int)((long)n2 - (this.splitLength - this.bytesWrittenForThisPart)));
                    this.bytesWrittenForThisPart = (long)n2 - (this.splitLength - this.bytesWrittenForThisPart);
                }
            } else {
                this.raf.write(byArray, n, n2);
                this.bytesWrittenForThisPart += (long)n2;
            }
        } else {
            this.raf.write(byArray, n, n2);
            this.bytesWrittenForThisPart += (long)n2;
        }
    }

    private void startNextSplitFile() throws IOException {
        try {
            String string = Zip4jUtil.getZipFileNameWithoutExt(this.outFile.getName());
            File file = null;
            String string2 = this.zipFile.getAbsolutePath();
            String string3 = this.outFile.getParent() == null ? "" : this.outFile.getParent() + System.getProperty("file.separator");
            file = this.currSplitFileCounter < 9 ? new File(string3 + string + ".z0" + (this.currSplitFileCounter + 1)) : new File(string3 + string + ".z" + (this.currSplitFileCounter + 1));
            this.raf.close();
            if (file.exists()) {
                throw new IOException("split file: " + file.getName() + " already exists in the current directory, cannot rename this file");
            }
            if (!this.zipFile.renameTo(file)) {
                throw new IOException("cannot rename newly created split file");
            }
            this.zipFile = new File(string2);
            this.raf = new RandomAccessFile(this.zipFile, "rw");
            ++this.currSplitFileCounter;
        }
        catch (ZipException zipException) {
            throw new IOException(zipException.getMessage());
        }
    }

    private boolean isHeaderData(byte[] byArray) {
        if (byArray == null || byArray.length < 4) {
            return false;
        }
        int n = Raw.readIntLittleEndian(byArray, 0);
        long[] lArray = Zip4jUtil.getAllHeaderSignatures();
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == 134695760L || lArray[i] != (long)n) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkBuffSizeAndStartNextSplitFile(int n) throws ZipException {
        if (n < 0) {
            throw new ZipException("negative buffersize for checkBuffSizeAndStartNextSplitFile");
        }
        if (!this.isBuffSizeFitForCurrSplitFile(n)) {
            try {
                this.startNextSplitFile();
                this.bytesWrittenForThisPart = 0L;
                return true;
            }
            catch (IOException iOException) {
                throw new ZipException(iOException);
            }
        }
        return false;
    }

    public boolean isBuffSizeFitForCurrSplitFile(int n) throws ZipException {
        if (n < 0) {
            throw new ZipException("negative buffersize for isBuffSizeFitForCurrSplitFile");
        }
        if (this.splitLength >= 65536L) {
            return this.bytesWrittenForThisPart + (long)n <= this.splitLength;
        }
        return true;
    }

    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public boolean isSplitZipFile() {
        return this.splitLength != -1L;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    public int getCurrSplitFileCounter() {
        return this.currSplitFileCounter;
    }
}

