/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.model;

import java.util.TimeZone;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipParameters
implements Cloneable {
    private int compressionMethod = 8;
    private int compressionLevel;
    private boolean encryptFiles = false;
    private int encryptionMethod = -1;
    private boolean readHiddenFiles = true;
    private char[] password;
    private int aesKeyStrength = -1;
    private boolean includeRootFolder = true;
    private String rootFolderInZip;
    private TimeZone timeZone = TimeZone.getDefault();
    private int sourceFileCRC;
    private String defaultFolderPath;
    private String fileNameInZip;
    private boolean isSourceExternalStream;

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(int n) {
        this.compressionMethod = n;
    }

    public boolean isEncryptFiles() {
        return this.encryptFiles;
    }

    public void setEncryptFiles(boolean bl) {
        this.encryptFiles = bl;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(int n) {
        this.encryptionMethod = n;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = n;
    }

    public boolean isReadHiddenFiles() {
        return this.readHiddenFiles;
    }

    public void setReadHiddenFiles(boolean bl) {
        this.readHiddenFiles = bl;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        if (string == null) {
            return;
        }
        this.setPassword(string.toCharArray());
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public int getAesKeyStrength() {
        return this.aesKeyStrength;
    }

    public void setAesKeyStrength(int n) {
        this.aesKeyStrength = n;
    }

    public boolean isIncludeRootFolder() {
        return this.includeRootFolder;
    }

    public void setIncludeRootFolder(boolean bl) {
        this.includeRootFolder = bl;
    }

    public String getRootFolderInZip() {
        return this.rootFolderInZip;
    }

    public void setRootFolderInZip(String string) {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            if (!string.endsWith("\\") && !string.endsWith("/")) {
                string = string + InternalZipConstants.FILE_SEPARATOR;
            }
            string = string.replaceAll("\\\\", "/");
        }
        this.rootFolderInZip = string;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public int getSourceFileCRC() {
        return this.sourceFileCRC;
    }

    public void setSourceFileCRC(int n) {
        this.sourceFileCRC = n;
    }

    public String getDefaultFolderPath() {
        return this.defaultFolderPath;
    }

    public void setDefaultFolderPath(String string) {
        this.defaultFolderPath = string;
    }

    public String getFileNameInZip() {
        return this.fileNameInZip;
    }

    public void setFileNameInZip(String string) {
        this.fileNameInZip = string;
    }

    public boolean isSourceExternalStream() {
        return this.isSourceExternalStream;
    }

    public void setSourceExternalStream(boolean bl) {
        this.isSourceExternalStream = bl;
    }
}

