/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChannelExportData
implements Serializable,
Purgable {
    private ChannelMetadata metadata;
    private List<CodeTemplateLibrary> codeTemplateLibraries;
    private Set<String> dependentIds;
    private Set<String> dependencyIds;
    private List<ChannelTag> channelTags;

    public ChannelMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new ChannelMetadata();
        }
        return this.metadata;
    }

    public void setMetadata(ChannelMetadata metadata) {
        this.metadata = metadata;
    }

    public void clearMetadata() {
        this.metadata = null;
    }

    public List<CodeTemplateLibrary> getCodeTemplateLibraries() {
        if (this.codeTemplateLibraries == null) {
            this.codeTemplateLibraries = new ArrayList<CodeTemplateLibrary>();
        }
        return this.codeTemplateLibraries;
    }

    public void setCodeTemplateLibraries(List<CodeTemplateLibrary> codeTemplateLibraries) {
        this.codeTemplateLibraries = codeTemplateLibraries;
    }

    public void clearCodeTemplateLibraries() {
        this.codeTemplateLibraries = null;
    }

    public Set<String> getDependentIds() {
        if (this.dependentIds == null) {
            this.dependentIds = new HashSet<String>();
        }
        return this.dependentIds;
    }

    public void setDependentIds(Set<String> dependentIds) {
        this.dependentIds = dependentIds;
    }

    public Set<String> getDependencyIds() {
        if (this.dependencyIds == null) {
            this.dependencyIds = new HashSet<String>();
        }
        return this.dependencyIds;
    }

    public void setDependencyIds(Set<String> dependencyIds) {
        this.dependencyIds = dependencyIds;
    }

    public void clearDependencies() {
        this.dependentIds = null;
        this.dependencyIds = null;
    }

    public List<ChannelTag> getChannelTags() {
        if (this.channelTags == null) {
            this.channelTags = new ArrayList<ChannelTag>();
        }
        return this.channelTags;
    }

    public void setChannelTags(List<ChannelTag> channelTags) {
        this.channelTags = channelTags;
    }

    public void clearTags() {
        this.channelTags = null;
    }

    public void clearAllExceptMetadata() {
        this.clearCodeTemplateLibraries();
        this.clearDependencies();
        this.clearTags();
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        if (this.metadata != null) {
            purgedProperties.put("metadata", this.metadata.getPurgedProperties());
        }
        if (this.codeTemplateLibraries != null) {
            ArrayList<Map<String, Object>> purgedCodeTemplateLibraries = new ArrayList<Map<String, Object>>();
            for (CodeTemplateLibrary codeTemplateLibrary : this.codeTemplateLibraries) {
                purgedCodeTemplateLibraries.add(codeTemplateLibrary.getPurgedProperties());
            }
            purgedProperties.put("codeTemplateLibraries", purgedCodeTemplateLibraries);
        }
        if (this.dependentIds != null) {
            purgedProperties.put("dependentIdsCount", this.dependentIds.size());
        }
        if (this.dependencyIds != null) {
            purgedProperties.put("dependencyIdsCount", this.dependencyIds.size());
        }
        return purgedProperties;
    }
}

