/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.model.FilterTransformerIterable;
import com.mirth.connect.model.IteratorProperties;
import com.mirth.connect.model.Rule;
import com.mirth.connect.util.ScriptBuilderException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IteratorRuleProperties
extends IteratorProperties<Rule> {
    private boolean intersectIterations;
    private boolean breakEarly;

    public IteratorRuleProperties() {
        this.intersectIterations = false;
        this.breakEarly = true;
    }

    public IteratorRuleProperties(IteratorRuleProperties props) {
        super(props);
        this.intersectIterations = props.isIntersectIterations();
        this.breakEarly = props.isBreakEarly();
    }

    public boolean isIntersectIterations() {
        return this.intersectIterations;
    }

    public void setIntersectIterations(boolean intersectIterations) {
        this.intersectIterations = intersectIterations;
    }

    public boolean isBreakEarly() {
        return this.breakEarly;
    }

    public void setBreakEarly(boolean breakEarly) {
        this.breakEarly = breakEarly;
    }

    @Override
    public String getIterationScript(boolean loadFiles, LinkedList<IteratorProperties<Rule>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        int depth = ancestors.size();
        ancestors.push(this);
        List enabledChildren = this.getEnabledElements();
        script.append("var _iterator_flag_").append(depth).append(" = ").append(this.intersectIterations).append(";\n");
        script.append("for (var ").append(this.getIndexVariable()).append(" = 0; ").append(this.getIndexVariable()).append(" < getArrayOrXmlLength(").append(this.getTarget()).append("); ").append(this.getIndexVariable()).append("++) {\n");
        if (CollectionUtils.isNotEmpty(enabledChildren)) {
            script.append("if (");
            if (this.intersectIterations) {
                script.append("!(");
            }
            boolean first = true;
            for (Rule child : enabledChildren) {
                if (first) {
                    first = false;
                } else {
                    script.append(Objects.equals((Object)child.getOperator(), (Object)Rule.Operator.AND) ? "&&" : "||");
                }
                script.append("\n(function() {\n");
                if (child instanceof FilterTransformerIterable) {
                    script.append(StringUtils.defaultString((String)((FilterTransformerIterable)((Object)child)).getIterationScript(loadFiles, ancestors)));
                } else {
                    script.append(StringUtils.defaultString((String)child.getScript(loadFiles)));
                }
                script.append("\n}() == true)\n");
            }
            if (this.intersectIterations) {
                script.append(')');
            }
            script.append(") { _iterator_flag_").append(depth).append(" = ").append(!this.intersectIterations).append("; ");
            if (this.breakEarly) {
                script.append("break; ");
            }
            script.append("}\n");
        }
        script.append("\n}\nreturn _iterator_flag_").append(depth).append(";\n");
        ancestors.pop();
        return script.toString();
    }

    @Override
    public IteratorRuleProperties clone() {
        return new IteratorRuleProperties(this);
    }

    @Override
    public Map<String, Object> getPurgedProperties() {
        Map<String, Object> purgedProperties = super.getPurgedProperties();
        purgedProperties.put("intersectIterations", this.intersectIterations);
        purgedProperties.put("breakEarly", this.breakEarly);
        return purgedProperties;
    }
}

