/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.client.core.Version;
import com.mirth.connect.model.ApiProvider;
import com.mirth.connect.model.CalendarToStringStyle;
import com.mirth.connect.model.ExtensionLibrary;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class MetaData {
    @XStreamAsAttribute
    private String path;
    private String name;
    private String author;
    private String mirthVersion;
    private String pluginVersion;
    private String url;
    private String description;
    @XStreamAlias(value="apiProviders")
    @XStreamImplicit(itemFieldName="apiProvider")
    private List<ApiProvider> apiProviders;
    @XStreamAlias(value="libraries")
    @XStreamImplicit(itemFieldName="library")
    private List<ExtensionLibrary> libraries;
    private String templateClassName;
    private List<String> userutilPackages;
    private Boolean notify;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMirthVersion() {
        return this.mirthVersion;
    }

    public void setMirthVersion(String mirthVersion) {
        this.mirthVersion = mirthVersion;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ApiProvider> getApiProviders() {
        return this.apiProviders;
    }

    public List<ApiProvider> getApiProviders(Version version) {
        ArrayList<ApiProvider> list = new ArrayList<ApiProvider>();
        if (CollectionUtils.isNotEmpty(this.apiProviders)) {
            for (ApiProvider provider : this.apiProviders) {
                boolean valid = true;
                Version minVersion = Version.fromString((String)provider.getMinVersion());
                Version maxVersion = Version.fromString((String)provider.getMaxVersion());
                if (minVersion != null && minVersion.ordinal() > version.ordinal()) {
                    valid = false;
                }
                if (maxVersion != null && maxVersion.ordinal() < version.ordinal()) {
                    valid = false;
                }
                if (!valid) continue;
                list.add(provider);
            }
        }
        return list;
    }

    public void setApiProviders(List<ApiProvider> apiProviders) {
        this.apiProviders = apiProviders;
    }

    public List<ExtensionLibrary> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<ExtensionLibrary> libraries) {
        this.libraries = libraries;
    }

    public String getTemplateClassName() {
        return this.templateClassName;
    }

    public void setTemplateClassName(String templateClassName) {
        this.templateClassName = templateClassName;
    }

    public List<String> getUserutilPackages() {
        return this.userutilPackages;
    }

    public void setUserutilPackages(List<String> userutilPackages) {
        this.userutilPackages = userutilPackages;
    }

    public Boolean getNotify() {
        return this.notify;
    }

    public void setNotify(Boolean notify) {
        this.notify = notify;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CalendarToStringStyle.instance());
    }
}

