/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.codetemplates;

import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.model.CalendarToStringStyle;
import com.mirth.connect.model.codetemplates.CodeTemplateFunctionDefinition;
import com.mirth.connect.util.CodeTemplateUtil;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class CodeTemplateProperties
implements Serializable,
Purgable {
    private CodeTemplateType type;
    private transient String description;
    private transient CodeTemplateFunctionDefinition functionDefinition;

    public CodeTemplateProperties(CodeTemplateType type) {
        this.type = type;
    }

    public abstract String getPluginPointName();

    public abstract String getCode();

    public CodeTemplateType getType() {
        return this.type;
    }

    public void setType(CodeTemplateType type) {
        this.type = type;
    }

    public String getDescription() {
        if (this.description == null) {
            this.updateDocumentation();
        }
        return this.description;
    }

    public CodeTemplateFunctionDefinition getFunctionDefinition() {
        if (this.functionDefinition == null) {
            this.updateDocumentation();
        }
        return this.functionDefinition;
    }

    protected void updateDocumentation() {
        String code = this.getCode();
        String description = null;
        CodeTemplateFunctionDefinition functionDefinition = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            CodeTemplateUtil.CodeTemplateDocumentation documentation = CodeTemplateUtil.getDocumentation(code);
            description = documentation.getDescription();
            functionDefinition = documentation.getFunctionDefinition();
        }
        this.description = description;
        this.functionDefinition = functionDefinition;
    }

    public abstract CodeTemplateProperties clone();

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CalendarToStringStyle.instance());
    }

    public static enum CodeTemplateType {
        FUNCTION("Function"),
        DRAG_AND_DROP_CODE("Drag-and-Drop Code Block"),
        COMPILED_CODE("Compiled Code Block");

        private String value;

        private CodeTemplateType(String value) {
            this.value = value;
        }

        public static CodeTemplateType fromString(String value) {
            for (CodeTemplateType type : CodeTemplateType.values()) {
                if (!StringUtils.equals((CharSequence)type.toString(), (CharSequence)value)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

