/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.converters.MigratableConverter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class ChannelConverter
extends MigratableConverter {
    private HierarchicalStreamCopier copier = new HierarchicalStreamCopier();

    public ChannelConverter(String currentVersion, Mapper mapper) {
        super(currentVersion, mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return type != null && Channel.class.isAssignableFrom(type);
    }

    @Override
    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (value instanceof InvalidChannel) {
            try {
                DonkeyElement element = new DonkeyElement(((InvalidChannel)value).getChannelXml());
                String version = element.getAttribute("version");
                if (StringUtils.isNotEmpty((CharSequence)version)) {
                    writer.addAttribute("version", version);
                }
                for (DonkeyElement child : element.getChildElements()) {
                    this.copier.copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(child.toXml()), (XmlPullParser)new MXParser()), writer);
                }
            }
            catch (Exception e) {
                throw new SerializerException((Throwable)e);
            }
        } else {
            super.marshal(value, writer, context);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.underlyingReader() instanceof DocumentReader) {
            DonkeyElement channel = new DonkeyElement((Element)((DocumentReader)reader.underlyingReader()).getCurrent());
            String preUnmarshalXml = null;
            try {
                try {
                    preUnmarshalXml = channel.toXml();
                }
                catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                    // empty catch block
                }
                return super.unmarshal(reader, context);
            }
            catch (LinkageError e) {
                return new InvalidChannel(preUnmarshalXml, channel, e, reader);
            }
            catch (Exception e) {
                return new InvalidChannel(preUnmarshalXml, channel, e, reader);
            }
        }
        return super.unmarshal(reader, context);
    }
}

